/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util;

import com.google.common.annotations.Beta;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.model.api.TypeComment;
import org.opendaylight.mdsal.binding.model.util.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.model.util.FormattingUtils;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;

@Beta
@NonNullByDefault
public final class TypeComments {
    private static final Escaper ENTITY_ESCAPER = Escapers.builder().addEscape('<', "&lt;").addEscape('>', "&gt;").addEscape('&', "&amp;").addEscape('@', "&#64;").build();
    private static final Pattern TAIL_COMMENT_PATTERN = Pattern.compile("*/", 16);

    private TypeComments() {
    }

    public static Optional<TypeComment> javadoc(String javadoc) {
        return javadoc.isEmpty() ? Optional.empty() : Optional.of(() -> javadoc);
    }

    public static Optional<TypeComment> description(DocumentedNode node) {
        String description = node.getDescription().orElse("");
        return description.isEmpty() ? Optional.empty() : Optional.of(() -> BindingGeneratorUtil.replaceAllIllegalChars(FormattingUtils.formatToParagraph(TAIL_COMMENT_PATTERN.matcher(ENTITY_ESCAPER.escape(description)).replaceAll("&#42;&#47;"), 0)));
    }
}

