/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.model.api.AbstractBaseType;
import org.opendaylight.mdsal.binding.model.api.BaseTypeWithRestrictions;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.WildcardType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;

public final class Types {
    private static final CacheLoader<Class<?>, ConcreteType> TYPE_LOADER = new CacheLoader<Class<?>, ConcreteType>(){

        public ConcreteType load(Class<?> key) {
            return new ConcreteTypeImpl(JavaTypeName.create(key), null);
        }
    };
    private static final LoadingCache<Class<?>, ConcreteType> TYPE_CACHE = CacheBuilder.newBuilder().weakKeys().build(TYPE_LOADER);
    public static final @NonNull ConcreteType BOOLEAN = Types.typeForClass(Boolean.class);
    public static final @NonNull ConcreteType STRING = Types.typeForClass(String.class);
    public static final @NonNull ConcreteType VOID = Types.typeForClass(Void.class);
    public static final @NonNull ConcreteType BYTE_ARRAY = Types.typeForClass(byte[].class);
    private static final @NonNull ConcreteType BUILDER = Types.typeForClass(Builder.class);
    private static final @NonNull ConcreteType CLASS = Types.typeForClass(Class.class);
    private static final @NonNull ConcreteType LIST_TYPE = Types.typeForClass(List.class);
    private static final @NonNull ConcreteType LISTENABLE_FUTURE = Types.typeForClass(ListenableFuture.class);
    private static final @NonNull ConcreteType MAP_TYPE = Types.typeForClass(Map.class);
    private static final @NonNull ConcreteType OBJECT = Types.typeForClass(Object.class);
    private static final @NonNull ConcreteType PRIMITIVE_VOID = Types.typeForClass(Void.TYPE);
    private static final @NonNull ConcreteType SERIALIZABLE = Types.typeForClass(Serializable.class);
    private static final @NonNull ConcreteType SET_TYPE = Types.typeForClass(Set.class);

    private Types() {
    }

    public static @NonNull ParameterizedType classType(Type type) {
        return Types.parameterizedTypeFor((Type)CLASS, type);
    }

    public static @NonNull ConcreteType voidType() {
        return VOID;
    }

    public static @NonNull ConcreteType objectType() {
        return OBJECT;
    }

    public static @NonNull ConcreteType primitiveVoidType() {
        return PRIMITIVE_VOID;
    }

    public static @NonNull ConcreteType serializableType() {
        return SERIALIZABLE;
    }

    public static @NonNull ConcreteType typeForClass(@NonNull Class<?> cls) {
        return (ConcreteType)TYPE_CACHE.getUnchecked(cls);
    }

    public static @NonNull ConcreteType typeForClass(@NonNull Class<?> cls, @Nullable Restrictions restrictions) {
        return restrictions == null ? Types.typeForClass(cls) : Types.restrictedType(JavaTypeName.create(cls), restrictions);
    }

    @Beta
    public static @NonNull ConcreteType restrictedType(Type type, @NonNull Restrictions restrictions) {
        return Types.restrictedType((JavaTypeName)type.getIdentifier(), restrictions);
    }

    private static @NonNull ConcreteType restrictedType(JavaTypeName identifier, @NonNull Restrictions restrictions) {
        return restrictions instanceof DefaultRestrictions ? new ConcreteTypeImpl(identifier, restrictions) : new BaseTypeWithRestrictionsImpl(identifier, restrictions);
    }

    public static @NonNull ParameterizedType mapTypeFor(Type keyType, Type valueType) {
        return Types.parameterizedTypeFor((Type)MAP_TYPE, keyType, valueType);
    }

    public static boolean isMapType(ParameterizedType type) {
        return MAP_TYPE.equals(type.getRawType());
    }

    public static boolean isMapType(Type type) {
        return type instanceof ParameterizedType && Types.isMapType((ParameterizedType)type);
    }

    public static @NonNull ParameterizedType setTypeFor(Type valueType) {
        return Types.parameterizedTypeFor((Type)SET_TYPE, valueType);
    }

    public static @NonNull ParameterizedType listTypeFor(Type valueType) {
        return Types.parameterizedTypeFor((Type)LIST_TYPE, valueType);
    }

    public static boolean isListType(ParameterizedType type) {
        return LIST_TYPE.equals(type.getRawType());
    }

    public static boolean isListType(Type type) {
        return type instanceof ParameterizedType && Types.isListType((ParameterizedType)type);
    }

    public static @NonNull ParameterizedType listenableFutureTypeFor(Type valueType) {
        return Types.parameterizedTypeFor((Type)LISTENABLE_FUTURE, valueType);
    }

    public static @NonNull ParameterizedType builderTypeFor(Type valueType) {
        return Types.parameterizedTypeFor((Type)BUILDER, valueType);
    }

    public static @NonNull ParameterizedType parameterizedTypeFor(Type type, Type ... parameters) {
        return new ParametrizedTypeImpl(type, parameters);
    }

    public static WildcardType wildcardTypeFor(JavaTypeName identifier) {
        return new WildcardTypeImpl(identifier);
    }

    public static @Nullable String getOuterClassName(Type valueType) {
        return ((JavaTypeName)valueType.getIdentifier()).immediatelyEnclosingClass().map(Object::toString).orElse(null);
    }

    public static <T extends Number> DefaultRestrictions<T> getDefaultRestrictions(T min, T max) {
        return new DefaultRestrictions<T>(min, max);
    }

    private static final class DefaultRangeConstraint<T extends Number>
    implements RangeConstraint<T> {
        private final T min;
        private final T max;

        DefaultRangeConstraint(T min, T max) {
            this.min = (Number)Objects.requireNonNull(min);
            this.max = (Number)Objects.requireNonNull(max);
        }

        public Optional<String> getErrorAppTag() {
            return Optional.empty();
        }

        public Optional<String> getErrorMessage() {
            return Optional.empty();
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getReference() {
            return Optional.empty();
        }

        public RangeSet<T> getAllowedRanges() {
            return ImmutableRangeSet.of((Range)Range.closed(this.min, this.max));
        }
    }

    private static final class DefaultRestrictions<T extends Number>
    implements Restrictions {
        private final RangeConstraint<?> rangeConstraint;

        DefaultRestrictions(T min, T max) {
            this.rangeConstraint = new DefaultRangeConstraint(min, max);
        }

        public boolean isEmpty() {
            return false;
        }

        public Optional<? extends RangeConstraint<?>> getRangeConstraint() {
            return Optional.of(this.rangeConstraint);
        }

        public List<PatternConstraint> getPatternConstraints() {
            return Collections.emptyList();
        }

        public Optional<LengthConstraint> getLengthConstraint() {
            return Optional.empty();
        }
    }

    private static class WildcardTypeImpl
    extends AbstractBaseType
    implements WildcardType {
        WildcardTypeImpl(JavaTypeName identifier) {
            super(identifier);
        }
    }

    private static class ParametrizedTypeImpl
    extends AbstractBaseType
    implements ParameterizedType {
        private final Type[] actualTypes;
        private final Type rawType;

        ParametrizedTypeImpl(Type rawType, Type[] actTypes) {
            super((JavaTypeName)rawType.getIdentifier());
            this.rawType = Objects.requireNonNull(rawType);
            this.actualTypes = (Type[])actTypes.clone();
            if (Arrays.stream(this.actualTypes).anyMatch(Objects::isNull)) {
                throw new NullPointerException("actTypes contains a null");
            }
        }

        public Type[] getActualTypeArguments() {
            return this.actualTypes;
        }

        public Type getRawType() {
            return this.rawType;
        }
    }

    private static final class BaseTypeWithRestrictionsImpl
    extends AbstractBaseType
    implements BaseTypeWithRestrictions {
        private final Restrictions restrictions;

        BaseTypeWithRestrictionsImpl(JavaTypeName identifier, Restrictions restrictions) {
            super(identifier);
            this.restrictions = Objects.requireNonNull(restrictions);
        }

        public Restrictions getRestrictions() {
            return this.restrictions;
        }
    }

    private static final class ConcreteTypeImpl
    extends AbstractBaseType
    implements ConcreteType {
        private final Restrictions restrictions;

        ConcreteTypeImpl(JavaTypeName identifier, Restrictions restrictions) {
            super(identifier);
            this.restrictions = restrictions;
        }

        public Restrictions getRestrictions() {
            return this.restrictions;
        }
    }
}

