/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.model.api.AbstractBaseType;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.Constant;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AnnotationTypeBuilderImpl;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.util.LazyCollections;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

public abstract class AbstractEnumerationBuilder
extends AbstractBaseType
implements EnumBuilder {
    private List<Enumeration.Pair> values = ImmutableList.of();
    private List<AnnotationTypeBuilder> annotationBuilders = ImmutableList.of();

    AbstractEnumerationBuilder(JavaTypeName identifier) {
        super(identifier);
    }

    public final AnnotationTypeBuilder addAnnotation(JavaTypeName identifier) {
        AnnotationTypeBuilderImpl builder = new AnnotationTypeBuilderImpl(identifier);
        if (!this.annotationBuilders.contains((Object)builder)) {
            this.annotationBuilders = LazyCollections.lazyAdd(this.annotationBuilders, (Object)((Object)builder));
            return builder;
        }
        return null;
    }

    @VisibleForTesting
    final void addValue(String name, String mappedName, int value, Status status, String description, String reference) {
        this.values = LazyCollections.lazyAdd(this.values, (Object)this.createEnumPair(name, mappedName, value, status, description, reference));
    }

    public abstract void setReference(String var1);

    public abstract void setModuleName(String var1);

    public abstract void setSchemaPath(SchemaPath var1);

    abstract AbstractPair createEnumPair(String var1, String var2, int var3, Status var4, String var5, String var6);

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EnumerationBuilderImpl [packageName=");
        builder.append(this.getPackageName());
        builder.append(", name=");
        builder.append(this.getName());
        builder.append(", values=");
        builder.append(this.values);
        builder.append("]");
        return builder.toString();
    }

    public final void updateEnumPairsFromEnumTypeDef(EnumTypeDefinition enumTypeDef) {
        List enums = enumTypeDef.getValues();
        BiMap valueIds = BindingMapping.mapEnumAssignedNames((Collection)enums.stream().map(EnumTypeDefinition.EnumPair::getName).collect(Collectors.toList()));
        for (EnumTypeDefinition.EnumPair enumPair : enums) {
            this.addValue(enumPair.getName(), (String)valueIds.get(enumPair.getName()), enumPair.getValue(), enumPair.getStatus(), enumPair.getDescription().orElse(null), enumPair.getReference().orElse(null));
        }
    }

    static abstract class AbstractEnumeration
    extends AbstractBaseType
    implements Enumeration {
        private final Type definingType;
        private final List<Enumeration.Pair> values;
        private final List<AnnotationType> annotations;

        AbstractEnumeration(AbstractEnumerationBuilder builder, Type definingType) {
            super(builder.getIdentifier());
            this.definingType = definingType;
            this.values = ImmutableList.copyOf(builder.values);
            ArrayList<AnnotationType> a = new ArrayList<AnnotationType>();
            for (AnnotationTypeBuilder b : builder.annotationBuilders) {
                a.add(b.build());
            }
            this.annotations = ImmutableList.copyOf(a);
        }

        public final Type getParentType() {
            return this.definingType;
        }

        public final List<Enumeration.Pair> getValues() {
            return this.values;
        }

        public final List<AnnotationType> getAnnotations() {
            return this.annotations;
        }

        public final String toFormattedString() {
            StringBuilder builder = new StringBuilder();
            builder.append("public enum");
            builder.append(" ");
            builder.append(this.getName());
            builder.append(" {");
            builder.append("\n");
            int offset = 0;
            for (Enumeration.Pair valPair : this.values) {
                builder.append("\t ");
                builder.append(valPair.getMappedName());
                builder.append(" (");
                builder.append(valPair.getValue());
                if (offset == this.values.size() - 1) {
                    builder.append(" );");
                } else {
                    builder.append(" ),");
                }
                ++offset;
            }
            builder.append("\n}");
            return builder.toString();
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Enumeration [packageName=");
            builder.append(this.getPackageName());
            if (this.definingType != null) {
                builder.append(", definingType=");
                builder.append(this.definingType.getPackageName());
                builder.append(".");
                builder.append(this.definingType.getName());
            } else {
                builder.append(", definingType= null");
            }
            builder.append(", name=");
            builder.append(this.getName());
            builder.append(", values=");
            builder.append(this.values);
            builder.append("]");
            return builder.toString();
        }

        public final boolean isAbstract() {
            return false;
        }

        public final List<Type> getImplements() {
            return Collections.emptyList();
        }

        public final List<GeneratedType> getEnclosedTypes() {
            return Collections.emptyList();
        }

        public final List<Enumeration> getEnumerations() {
            return Collections.emptyList();
        }

        public final List<Constant> getConstantDefinitions() {
            return Collections.emptyList();
        }

        public final List<MethodSignature> getMethodDefinitions() {
            return Collections.emptyList();
        }

        public final List<GeneratedProperty> getProperties() {
            return Collections.emptyList();
        }
    }

    static abstract class AbstractPair
    implements Enumeration.Pair {
        private final String name;
        private final String mappedName;
        private final int value;

        AbstractPair(String name, String mappedName, int value) {
            this.name = Objects.requireNonNull(name);
            this.mappedName = Objects.requireNonNull(mappedName);
            this.value = value;
        }

        public final String getName() {
            return this.name;
        }

        public final String getMappedName() {
            return this.mappedName;
        }

        public final int getValue() {
            return this.value;
        }

        public final int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.name);
            result = 31 * result + Objects.hashCode(this.value);
            return result;
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AbstractPair)) {
                return false;
            }
            AbstractPair other = (AbstractPair)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
        }

        public final String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("EnumPair [name=");
            builder.append(this.name);
            builder.append(", mappedName=");
            builder.append(this.getMappedName());
            builder.append(", value=");
            builder.append(this.value);
            builder.append("]");
            return builder.toString();
        }
    }
}

