/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.TypeComment;
import org.opendaylight.mdsal.binding.model.api.YangSourceDefinition;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractEnumerationBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;

public final class CodegenEnumerationBuilder
extends AbstractEnumerationBuilder {
    private String description;
    private String reference;
    private String moduleName;
    private SchemaPath schemaPath;

    public CodegenEnumerationBuilder(JavaTypeName identifier) {
        super(identifier);
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public void setSchemaPath(SchemaPath schemaPath) {
        this.schemaPath = schemaPath;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Enumeration toInstance(Type definingType) {
        return new EnumerationImpl(this, definingType);
    }

    @Override
    EnumPair createEnumPair(String name, String mappedName, int value, Status status, String enumDescription, String enumReference) {
        return new EnumPair(name, mappedName, value, status, enumDescription, enumReference);
    }

    private static final class EnumerationImpl
    extends AbstractEnumerationBuilder.AbstractEnumeration {
        private final String description;
        private final String reference;
        private final String moduleName;
        private final SchemaPath schemaPath;

        EnumerationImpl(CodegenEnumerationBuilder builder, Type definingType) {
            super(builder, definingType);
            this.description = builder.description;
            this.moduleName = builder.moduleName;
            this.schemaPath = builder.schemaPath;
            this.reference = builder.reference;
        }

        public TypeComment getComment() {
            return null;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Iterable<QName> getSchemaPath() {
            return this.schemaPath.getPathFromRoot();
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public Optional<YangSourceDefinition> getYangSourceDefinition() {
            return Optional.empty();
        }
    }

    private static final class EnumPair
    extends AbstractEnumerationBuilder.AbstractPair {
        private final String description;
        private final String reference;
        private final Status status;

        EnumPair(String name, String mappedName, int value, Status status, String description, String reference) {
            super(name, mappedName, value);
            this.status = Objects.requireNonNull(status);
            this.description = description;
            this.reference = reference;
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        public Optional<String> getReference() {
            return Optional.ofNullable(this.reference);
        }

        public Status getStatus() {
            return this.status;
        }
    }
}

