/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractTypeMember;

class MethodSignatureImpl
extends AbstractTypeMember
implements MethodSignature {
    private final List<MethodSignature.Parameter> params;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MethodSignature.ValueMechanics mechanics;
    private final boolean isAbstract;
    private final boolean isDefault;

    @VisibleForTesting
    MethodSignatureImpl(Type definingType, String name, List<AnnotationType> annotations, String comment, AccessModifier accessModifier, Type returnType, List<MethodSignature.Parameter> params, boolean isFinal, boolean isAbstract, boolean isStatic) {
        this(definingType, name, annotations, comment, accessModifier, returnType, params, isFinal, isAbstract, isStatic, false, MethodSignature.ValueMechanics.NORMAL);
    }

    MethodSignatureImpl(Type definingType, String name, List<AnnotationType> annotations, String comment, AccessModifier accessModifier, Type returnType, List<MethodSignature.Parameter> params, boolean isFinal, boolean isAbstract, boolean isStatic, boolean isDefault, MethodSignature.ValueMechanics mechanics) {
        super(definingType, name, annotations, comment, accessModifier, returnType, isFinal, isStatic);
        this.params = params;
        this.isAbstract = isAbstract;
        this.isDefault = isDefault;
        this.mechanics = Objects.requireNonNull(mechanics);
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public List<MethodSignature.Parameter> getParameters() {
        return this.params;
    }

    public MethodSignature.ValueMechanics getMechanics() {
        return this.mechanics;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.getName());
        result = 31 * result + Objects.hashCode(this.params);
        result = 31 * result + Objects.hashCode(this.getReturnType());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignatureImpl other = (MethodSignatureImpl)obj;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.params, other.params) && Objects.equals(this.getReturnType(), other.getReturnType());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder().append("MethodSignatureImpl [name=").append(this.getName()).append(", comment=").append(this.getComment()).append(", definingType=");
        Type defType = this.getDefiningType();
        if (defType != null) {
            builder.append(defType.getPackageName()).append('.').append(defType.getName());
        } else {
            builder.append(" null");
        }
        return builder.append(", returnType=").append(this.getReturnType()).append(", params=").append(this.params).append(", annotations=").append(this.getAnnotations()).append(']').toString();
    }
}

