/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Destination;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DestinationBuilder
implements Builder<Destination> {
    private NodeId _destNode;
    private TpId _destTp;
    Map<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> augmentation = Collections.emptyMap();

    public DestinationBuilder() {
    }

    public DestinationBuilder(Destination base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>(aug);
        }
        this._destNode = base.getDestNode();
        this._destTp = base.getDestTp();
    }

    public NodeId getDestNode() {
        return this._destNode;
    }

    public TpId getDestTp() {
        return this._destTp;
    }

    public <E$$ extends Augmentation<Destination>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public DestinationBuilder setDestNode(NodeId value) {
        this._destNode = value;
        return this;
    }

    public DestinationBuilder setDestTp(TpId value) {
        this._destTp = value;
        return this;
    }

    public DestinationBuilder addAugmentation(Augmentation<Destination> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public DestinationBuilder addAugmentation(Class<? extends Augmentation<Destination>> augmentationType, Augmentation<Destination> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public DestinationBuilder removeAugmentation(Class<? extends Augmentation<Destination>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private DestinationBuilder doAddAugmentation(Class<? extends Augmentation<Destination>> augmentationType, Augmentation<Destination> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Destination build() {
        return new DestinationImpl(this);
    }

    private static final class DestinationImpl
    extends AbstractAugmentable<Destination>
    implements Destination {
        private final NodeId _destNode;
        private final TpId _destTp;
        private int hash = 0;
        private volatile boolean hashValid = false;

        DestinationImpl(DestinationBuilder base) {
            super(base.augmentation);
            this._destNode = base.getDestNode();
            this._destTp = base.getDestTp();
        }

        @Override
        public NodeId getDestNode() {
            return this._destNode;
        }

        @Override
        public TpId getDestTp() {
            return this._destTp;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._destNode);
            result = 31 * result + Objects.hashCode(this._destTp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Destination.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Destination other = (Destination)obj;
            if (!Objects.equals(this._destNode, other.getDestNode())) {
                return false;
            }
            if (!Objects.equals(this._destTp, other.getDestTp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DestinationImpl otherImpl = (DestinationImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Destination");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_destNode", (Object)this._destNode);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_destTp", (Object)this._destTp);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

