/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Link;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.LinkKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.TopologyTypes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.UnderlayTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.UnderlayTopologyKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TopologyBuilder
implements Builder<Topology> {
    private Map<LinkKey, Link> _link;
    private Map<NodeKey, Node> _node;
    private TopologyId _topologyId;
    private TopologyTypes _topologyTypes;
    private Map<UnderlayTopologyKey, UnderlayTopology> _underlayTopology;
    private Boolean _serverProvided;
    private TopologyKey key;
    Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = Collections.emptyMap();

    public TopologyBuilder() {
    }

    public TopologyBuilder(Topology base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>(aug);
        }
        this.key = base.key();
        this._topologyId = base.getTopologyId();
        this._link = base.getLink();
        this._node = base.getNode();
        this._topologyTypes = base.getTopologyTypes();
        this._underlayTopology = base.getUnderlayTopology();
        this._serverProvided = base.isServerProvided();
    }

    public TopologyKey key() {
        return this.key;
    }

    public Map<LinkKey, Link> getLink() {
        return this._link;
    }

    public Map<NodeKey, Node> getNode() {
        return this._node;
    }

    public TopologyId getTopologyId() {
        return this._topologyId;
    }

    public TopologyTypes getTopologyTypes() {
        return this._topologyTypes;
    }

    public Map<UnderlayTopologyKey, UnderlayTopology> getUnderlayTopology() {
        return this._underlayTopology;
    }

    public Boolean isServerProvided() {
        return this._serverProvided;
    }

    public <E$$ extends Augmentation<Topology>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TopologyBuilder withKey(TopologyKey key) {
        this.key = key;
        return this;
    }

    public TopologyBuilder setLink(Map<LinkKey, Link> values) {
        this._link = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public TopologyBuilder setLink(List<Link> values) {
        return this.setLink(CodeHelpers.compatMap(values));
    }

    public TopologyBuilder setNode(Map<NodeKey, Node> values) {
        this._node = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public TopologyBuilder setNode(List<Node> values) {
        return this.setNode(CodeHelpers.compatMap(values));
    }

    public TopologyBuilder setTopologyId(TopologyId value) {
        this._topologyId = value;
        return this;
    }

    public TopologyBuilder setTopologyTypes(TopologyTypes value) {
        this._topologyTypes = value;
        return this;
    }

    public TopologyBuilder setUnderlayTopology(Map<UnderlayTopologyKey, UnderlayTopology> values) {
        this._underlayTopology = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public TopologyBuilder setUnderlayTopology(List<UnderlayTopology> values) {
        return this.setUnderlayTopology(CodeHelpers.compatMap(values));
    }

    public TopologyBuilder setServerProvided(Boolean value) {
        this._serverProvided = value;
        return this;
    }

    public TopologyBuilder addAugmentation(Augmentation<Topology> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public TopologyBuilder addAugmentation(Class<? extends Augmentation<Topology>> augmentationType, Augmentation<Topology> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public TopologyBuilder removeAugmentation(Class<? extends Augmentation<Topology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private TopologyBuilder doAddAugmentation(Class<? extends Augmentation<Topology>> augmentationType, Augmentation<Topology> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public Topology build() {
        return new TopologyImpl(this);
    }

    private static final class TopologyImpl
    extends AbstractAugmentable<Topology>
    implements Topology {
        private final Map<LinkKey, Link> _link;
        private final Map<NodeKey, Node> _node;
        private final TopologyId _topologyId;
        private final TopologyTypes _topologyTypes;
        private final Map<UnderlayTopologyKey, UnderlayTopology> _underlayTopology;
        private final Boolean _serverProvided;
        private final TopologyKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TopologyImpl(TopologyBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new TopologyKey(base.getTopologyId());
            this._topologyId = this.key.getTopologyId();
            this._link = CodeHelpers.emptyToNull(base.getLink());
            this._node = CodeHelpers.emptyToNull(base.getNode());
            this._topologyTypes = base.getTopologyTypes();
            this._underlayTopology = CodeHelpers.emptyToNull(base.getUnderlayTopology());
            this._serverProvided = base.isServerProvided();
        }

        @Override
        public TopologyKey key() {
            return this.key;
        }

        @Override
        public Map<LinkKey, Link> getLink() {
            return this._link;
        }

        @Override
        public Map<NodeKey, Node> getNode() {
            return this._node;
        }

        @Override
        public TopologyId getTopologyId() {
            return this._topologyId;
        }

        @Override
        public TopologyTypes getTopologyTypes() {
            return this._topologyTypes;
        }

        @Override
        public Map<UnderlayTopologyKey, UnderlayTopology> getUnderlayTopology() {
            return this._underlayTopology;
        }

        @Override
        public Boolean isServerProvided() {
            return this._serverProvided;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._link);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._topologyId);
            result = 31 * result + Objects.hashCode(this._topologyTypes);
            result = 31 * result + Objects.hashCode(this._underlayTopology);
            result = 31 * result + Objects.hashCode(this._serverProvided);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Topology.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            Topology other = (Topology)obj;
            if (!Objects.equals(this._link, other.getLink())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._topologyId, other.getTopologyId())) {
                return false;
            }
            if (!Objects.equals(this._topologyTypes, other.getTopologyTypes())) {
                return false;
            }
            if (!Objects.equals(this._underlayTopology, other.getUnderlayTopology())) {
                return false;
            }
            if (!Objects.equals(this._serverProvided, other.isServerProvided())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TopologyImpl otherImpl = (TopologyImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Topology");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_link", this._link);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_node", this._node);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_topologyId", (Object)this._topologyId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_topologyTypes", (Object)this._topologyTypes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_underlayTopology", this._underlayTopology);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_serverProvided", (Object)this._serverProvided);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

