/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidates;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.codec.binfmt.DeletedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.ModifiedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.UnmodifiedRootDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ReusableImmutableNormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class DataTreeCandidateInputOutput {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeCandidateInputOutput.class);
    private static final byte DELETE = 0;
    private static final byte SUBTREE_MODIFIED = 1;
    private static final byte UNMODIFIED = 2;
    private static final byte WRITE = 3;
    private static final byte APPEARED = 4;
    private static final byte DISAPPEARED = 5;

    private DataTreeCandidateInputOutput() {
    }

    public static @NonNull DataTreeCandidate readDataTreeCandidate(NormalizedNodeDataInput in) throws IOException {
        return DataTreeCandidateInputOutput.readDataTreeCandidate(in, (ReusableStreamReceiver)ReusableImmutableNormalizedNodeStreamWriter.create());
    }

    public static @NonNull DataTreeCandidate readDataTreeCandidate(NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        DataTreeCandidateNode rootNode;
        YangInstanceIdentifier rootPath = in.readYangInstanceIdentifier();
        byte type = in.readByte();
        switch (type) {
            case 4: {
                rootNode = ModifiedDataTreeCandidateNode.create(ModificationType.APPEARED, DataTreeCandidateInputOutput.readChildren(in, receiver));
                break;
            }
            case 0: {
                rootNode = DeletedDataTreeCandidateNode.create();
                break;
            }
            case 5: {
                rootNode = ModifiedDataTreeCandidateNode.create(ModificationType.DISAPPEARED, DataTreeCandidateInputOutput.readChildren(in, receiver));
                break;
            }
            case 1: {
                rootNode = ModifiedDataTreeCandidateNode.create(ModificationType.SUBTREE_MODIFIED, DataTreeCandidateInputOutput.readChildren(in, receiver));
                break;
            }
            case 3: {
                rootNode = DataTreeCandidateNodes.written(in.readNormalizedNode(receiver));
                break;
            }
            case 2: {
                rootNode = UnmodifiedRootDataTreeCandidateNode.INSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled node type " + type);
            }
        }
        return DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)rootPath, (DataTreeCandidateNode)rootNode);
    }

    public static void writeDataTreeCandidate(NormalizedNodeDataOutput out, DataTreeCandidate candidate) throws IOException {
        out.writeYangInstanceIdentifier(candidate.getRootPath());
        DataTreeCandidateNode node = candidate.getRootNode();
        switch (node.getModificationType()) {
            case APPEARED: {
                out.writeByte(4);
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case DELETE: {
                out.writeByte(0);
                break;
            }
            case DISAPPEARED: {
                out.writeByte(5);
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case SUBTREE_MODIFIED: {
                out.writeByte(1);
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case UNMODIFIED: {
                out.writeByte(2);
                break;
            }
            case WRITE: {
                out.writeByte(3);
                out.writeNormalizedNode((NormalizedNode)node.getDataAfter().get());
                break;
            }
            default: {
                DataTreeCandidateInputOutput.throwUnhandledNodeType(node);
            }
        }
    }

    private static DataTreeCandidateNode readModifiedNode(ModificationType type, NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        YangInstanceIdentifier.PathArgument identifier = in.readPathArgument();
        Collection<DataTreeCandidateNode> children = DataTreeCandidateInputOutput.readChildren(in, receiver);
        if (children.isEmpty()) {
            LOG.debug("Modified node {} does not have any children, not instantiating it", (Object)identifier);
            return null;
        }
        return ModifiedDataTreeCandidateNode.create(identifier, type, children);
    }

    private static Collection<DataTreeCandidateNode> readChildren(NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return ImmutableList.of();
        }
        ArrayList<DataTreeCandidateNode> ret = new ArrayList<DataTreeCandidateNode>(size);
        for (int i = 0; i < size; ++i) {
            DataTreeCandidateNode child = DataTreeCandidateInputOutput.readNode(in, receiver);
            if (child == null) continue;
            ret.add(child);
        }
        return ret;
    }

    private static DataTreeCandidateNode readNode(NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 4: {
                return DataTreeCandidateInputOutput.readModifiedNode(ModificationType.APPEARED, in, receiver);
            }
            case 0: {
                return DeletedDataTreeCandidateNode.create(in.readPathArgument());
            }
            case 5: {
                return DataTreeCandidateInputOutput.readModifiedNode(ModificationType.DISAPPEARED, in, receiver);
            }
            case 1: {
                return DataTreeCandidateInputOutput.readModifiedNode(ModificationType.SUBTREE_MODIFIED, in, receiver);
            }
            case 2: {
                return null;
            }
            case 3: {
                return DataTreeCandidateNodes.written(in.readNormalizedNode(receiver));
            }
        }
        throw new IllegalArgumentException("Unhandled node type " + type);
    }

    private static void writeChildren(NormalizedNodeDataOutput out, Collection<DataTreeCandidateNode> children) throws IOException {
        out.writeInt(children.size());
        for (DataTreeCandidateNode child : children) {
            DataTreeCandidateInputOutput.writeNode(out, child);
        }
    }

    private static void writeNode(NormalizedNodeDataOutput out, DataTreeCandidateNode node) throws IOException {
        switch (node.getModificationType()) {
            case APPEARED: {
                out.writeByte(4);
                out.writePathArgument(node.getIdentifier());
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case DELETE: {
                out.writeByte(0);
                out.writePathArgument(node.getIdentifier());
                break;
            }
            case DISAPPEARED: {
                out.writeByte(5);
                out.writePathArgument(node.getIdentifier());
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case SUBTREE_MODIFIED: {
                out.writeByte(1);
                out.writePathArgument(node.getIdentifier());
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case WRITE: {
                out.writeByte(3);
                out.writeNormalizedNode((NormalizedNode)node.getDataAfter().get());
                break;
            }
            case UNMODIFIED: {
                out.writeByte(2);
                break;
            }
            default: {
                DataTreeCandidateInputOutput.throwUnhandledNodeType(node);
            }
        }
    }

    private static void throwUnhandledNodeType(DataTreeCandidateNode node) {
        throw new IllegalArgumentException("Unhandled node type " + node.getModificationType());
    }
}

