/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.annotations.Beta;
import java.io.DataOutput;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.data.codec.binfmt.LithiumNormalizedNodeOutputStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.binfmt.MagnesiumDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NeonSR2NormalizedNodeOutputStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.SodiumSR1DataOutput;

@Beta
@NonNullByDefault
public enum NormalizedNodeStreamVersion {
    LITHIUM{

        @Override
        @Deprecated
        public NormalizedNodeDataOutput newDataOutput(DataOutput output) {
            return new LithiumNormalizedNodeOutputStreamWriter(output);
        }
    }
    ,
    NEON_SR2{

        @Override
        @Deprecated
        public NormalizedNodeDataOutput newDataOutput(DataOutput output) {
            return new NeonSR2NormalizedNodeOutputStreamWriter(output);
        }
    }
    ,
    SODIUM_SR1{

        @Override
        public NormalizedNodeDataOutput newDataOutput(DataOutput output) {
            return new SodiumSR1DataOutput(output);
        }
    }
    ,
    MAGNESIUM{

        @Override
        public NormalizedNodeDataOutput newDataOutput(DataOutput output) {
            return new MagnesiumDataOutput(output);
        }
    };


    public static NormalizedNodeStreamVersion current() {
        return MAGNESIUM;
    }

    public abstract NormalizedNodeDataOutput newDataOutput(DataOutput var1);
}

