/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.codec.binfmt.AbstractNormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.ForwardingNormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.InvalidNormalizedNodeStreamException;
import org.opendaylight.yangtools.yang.data.codec.binfmt.LithiumNormalizedNodeInputStreamReader;
import org.opendaylight.yangtools.yang.data.codec.binfmt.MagnesiumDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NeonSR2NormalizedNodeInputStreamReader;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.SodiumSR1DataInput;

final class VersionedNormalizedNodeDataInput
extends ForwardingNormalizedNodeDataInput {
    private DataInput input;
    private NormalizedNodeDataInput delegate;

    VersionedNormalizedNodeDataInput(DataInput input) {
        this.input = Objects.requireNonNull(input);
    }

    @Override
    NormalizedNodeDataInput delegate() throws IOException {
        AbstractNormalizedNodeDataInput ret;
        if (this.delegate != null) {
            return this.delegate;
        }
        byte marker = this.input.readByte();
        if (marker != -85) {
            throw this.defunct("Invalid signature marker: %d", marker);
        }
        short version = this.input.readShort();
        switch (version) {
            case 1: {
                ret = new LithiumNormalizedNodeInputStreamReader(this.input);
                break;
            }
            case 2: {
                ret = new NeonSR2NormalizedNodeInputStreamReader(this.input);
                break;
            }
            case 3: {
                ret = new SodiumSR1DataInput(this.input);
                break;
            }
            case 4: {
                ret = new MagnesiumDataInput(this.input);
                break;
            }
            default: {
                throw this.defunct("Unhandled stream version %s", version);
            }
        }
        this.setDelegate(ret);
        return ret;
    }

    private InvalidNormalizedNodeStreamException defunct(String format, Object ... args) {
        final InvalidNormalizedNodeStreamException ret = new InvalidNormalizedNodeStreamException(String.format(format, args));
        this.setDelegate(new ForwardingNormalizedNodeDataInput(){

            @Override
            NormalizedNodeDataInput delegate() throws IOException {
                throw new InvalidNormalizedNodeStreamException("Stream is not usable", ret);
            }
        });
        return ret;
    }

    private void setDelegate(NormalizedNodeDataInput delegate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.input = null;
    }
}

