/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.binding.runtime.spi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.io.ByteSource;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.binding.runtime.spi.DefaultModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaContextResolver;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaSourceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractModuleInfoTracker
implements Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractModuleInfoTracker.class);
    private final YangTextSchemaContextResolver ctxResolver;
    private final @GuardedBy(value={"this"}) ListMultimap<String, AbstractRegisteredModuleInfo> packageToInfoReg = MultimapBuilder.hashKeys().arrayListValues().build();
    private final @GuardedBy(value={"this"}) ListMultimap<SourceIdentifier, AbstractRegisteredModuleInfo> sourceToInfoReg = MultimapBuilder.hashKeys().arrayListValues().build();
    private @GuardedBy(value={"this"}) @Nullable ModuleInfoSnapshot currentSnapshot;

    AbstractModuleInfoTracker(YangTextSchemaContextResolver resolver) {
        this.ctxResolver = Objects.requireNonNull(resolver);
    }

    public final synchronized List<ObjectRegistration<YangModuleInfo>> registerModuleInfos(Iterable<? extends YangModuleInfo> moduleInfos) {
        ArrayList<ObjectRegistration<YangModuleInfo>> ret = new ArrayList<ObjectRegistration<YangModuleInfo>>();
        for (YangModuleInfo yangModuleInfo : moduleInfos) {
            ret.add(this.register(Objects.requireNonNull(yangModuleInfo)));
        }
        return ret;
    }

    @Holding(value={"this"})
    private ObjectRegistration<YangModuleInfo> register(@NonNull YangModuleInfo moduleInfo) {
        ImmutableList.Builder regBuilder = ImmutableList.builder();
        for (YangModuleInfo info : AbstractModuleInfoTracker.flatDependencies(moduleInfo)) {
            regBuilder.add((Object)this.registerExplicitModuleInfo(info));
        }
        final ImmutableList regInfos = regBuilder.build();
        return new AbstractObjectRegistration<YangModuleInfo>(moduleInfo){

            protected void removeRegistration() {
                AbstractModuleInfoTracker.this.unregister((ImmutableList<ExplicitRegisteredModuleInfo>)regInfos);
            }
        };
    }

    @Holding(value={"this"})
    final void registerImplicitBindingClass(Class<?> bindingClass) {
        this.registerImplicitModuleInfo(BindingRuntimeHelpers.extractYangModuleInfo(bindingClass));
    }

    @Holding(value={"this"})
    final @Nullable ClassLoader findClassLoader(String fullyQualifiedName) {
        String modulePackageName = BindingReflections.getModelRootPackageName((String)fullyQualifiedName);
        Iterator iterator = this.packageToInfoReg.get((Object)modulePackageName).iterator();
        if (iterator.hasNext()) {
            AbstractRegisteredModuleInfo reg = (AbstractRegisteredModuleInfo)iterator.next();
            return reg.loader;
        }
        return null;
    }

    @Holding(value={"this"})
    private void registerImplicitModuleInfo(@NonNull YangModuleInfo moduleInfo) {
        for (YangModuleInfo info : AbstractModuleInfoTracker.flatDependencies(moduleInfo)) {
            YangTextSchemaSourceRegistration reg;
            Class<?> infoClass = info.getClass();
            SourceIdentifier sourceId = AbstractModuleInfoTracker.sourceIdentifierFrom(info);
            if (this.sourceToInfoReg.containsKey((Object)sourceId)) {
                LOG.debug("Skipping implicit registration of {} as source {} is already registered", (Object)info, (Object)sourceId);
                continue;
            }
            try {
                reg = this.ctxResolver.registerSource(AbstractModuleInfoTracker.toYangTextSource(sourceId, info));
            }
            catch (IOException | YangSyntaxErrorException | SchemaSourceException e) {
                LOG.warn("Failed to register info {} source {}, ignoring it", new Object[]{info, sourceId, e});
                continue;
            }
            ImplicitRegisteredModuleInfo regInfo = new ImplicitRegisteredModuleInfo(info, reg, infoClass.getClassLoader());
            this.sourceToInfoReg.put((Object)sourceId, (Object)regInfo);
            this.packageToInfoReg.put((Object)BindingReflections.getModelRootPackageName((Package)infoClass.getPackage()), (Object)regInfo);
        }
    }

    @Holding(value={"this"})
    private ExplicitRegisteredModuleInfo registerExplicitModuleInfo(@NonNull YangModuleInfo info) {
        YangTextSchemaSourceRegistration reg;
        SourceIdentifier sourceId = AbstractModuleInfoTracker.sourceIdentifierFrom(info);
        for (AbstractRegisteredModuleInfo reg2 : this.sourceToInfoReg.get((Object)sourceId)) {
            if (!(reg2 instanceof ExplicitRegisteredModuleInfo) || !info.equals(reg2.info)) continue;
            ExplicitRegisteredModuleInfo explicit = (ExplicitRegisteredModuleInfo)reg2;
            explicit.incRef();
            LOG.debug("Reusing explicit registration {}", (Object)explicit);
            return explicit;
        }
        try {
            reg = this.ctxResolver.registerSource(AbstractModuleInfoTracker.toYangTextSource(sourceId, info));
        }
        catch (IOException | YangSyntaxErrorException | SchemaSourceException e) {
            throw new IllegalStateException("Failed to register info " + info, e);
        }
        Class<?> infoClass = info.getClass();
        String packageName = BindingReflections.getModelRootPackageName((Package)infoClass.getPackage());
        ExplicitRegisteredModuleInfo regInfo = new ExplicitRegisteredModuleInfo(info, reg, infoClass.getClassLoader());
        LOG.debug("Created new explicit registration {}", (Object)regInfo);
        this.sourceToInfoReg.put((Object)sourceId, (Object)regInfo);
        AbstractModuleInfoTracker.removeImplicit(this.sourceToInfoReg.get((Object)sourceId));
        this.packageToInfoReg.put((Object)packageName, (Object)regInfo);
        AbstractModuleInfoTracker.removeImplicit(this.packageToInfoReg.get((Object)packageName));
        return regInfo;
    }

    final Optional<? extends EffectiveModelContext> getResolverEffectiveModel() {
        return this.ctxResolver.getEffectiveModelContext();
    }

    @Deprecated
    final ListenableFuture<? extends YangTextSchemaSource> getResolverSource(SourceIdentifier sourceIdentifier) {
        return this.ctxResolver.getSource(sourceIdentifier);
    }

    @Holding(value={"this"})
    final @NonNull ModuleInfoSnapshot updateSnapshot() {
        EffectiveModelContext effectiveModel = (EffectiveModelContext)this.ctxResolver.getEffectiveModelContext().orElseThrow();
        ModuleInfoSnapshot local = this.currentSnapshot;
        if (local != null && local.getEffectiveModelContext().equals(effectiveModel)) {
            return local;
        }
        return this.updateSnapshot(effectiveModel);
    }

    @Holding(value={"this"})
    private @NonNull ModuleInfoSnapshot updateSnapshot(EffectiveModelContext effectiveModel) {
        HashSet<RevisionSourceIdentifier> sources = new HashSet<RevisionSourceIdentifier>();
        for (Map.Entry entry : effectiveModel.getModuleStatements().entrySet()) {
            Optional revision = ((QNameModule)entry.getKey()).getRevision();
            ModuleEffectiveStatement moduleEffectiveStatement = (ModuleEffectiveStatement)entry.getValue();
            sources.add(RevisionSourceIdentifier.create((String)((String)moduleEffectiveStatement.argument()), (Optional)revision));
            moduleEffectiveStatement.streamEffectiveSubstatements(SubmoduleEffectiveStatement.class).map(submodule -> RevisionSourceIdentifier.create((String)((String)submodule.argument()), (Optional)revision)).forEach(sources::add);
        }
        HashMap<SourceIdentifier, YangModuleInfo> moduleInfos = new HashMap<SourceIdentifier, YangModuleInfo>();
        HashMap<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();
        for (SourceIdentifier sourceIdentifier : sources) {
            List regs = this.sourceToInfoReg.get((Object)sourceIdentifier);
            Preconditions.checkState((!regs.isEmpty() ? 1 : 0) != 0, (String)"No registration for %s", (Object)sourceIdentifier);
            AbstractRegisteredModuleInfo reg = regs.stream().filter(ExplicitRegisteredModuleInfo.class::isInstance).findFirst().orElse(null);
            if (reg == null) {
                reg = (AbstractRegisteredModuleInfo)regs.get(0);
            }
            YangModuleInfo info = reg.info;
            moduleInfos.put(sourceIdentifier, info);
            Class<?> infoClass = info.getClass();
            classLoaders.put(BindingReflections.getModelRootPackageName((Package)infoClass.getPackage()), infoClass.getClassLoader());
        }
        DefaultModuleInfoSnapshot next = new DefaultModuleInfoSnapshot(effectiveModel, moduleInfos, classLoaders);
        this.currentSnapshot = next;
        return next;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private synchronized void unregister(ImmutableList<ExplicitRegisteredModuleInfo> regInfos) {
        for (ExplicitRegisteredModuleInfo regInfo : regInfos) {
            String packageName;
            if (!regInfo.decRef()) {
                LOG.debug("Registration {} has references, not removing it", (Object)regInfo);
                continue;
            }
            SourceIdentifier sourceId = AbstractModuleInfoTracker.sourceIdentifierFrom(regInfo.info);
            if (!this.sourceToInfoReg.remove((Object)sourceId, (Object)regInfo)) {
                LOG.warn("Failed to find {} registered under {}", (Object)regInfo, (Object)sourceId);
            }
            if (!this.packageToInfoReg.remove((Object)(packageName = BindingReflections.getModelRootPackageName((Package)regInfo.info.getClass().getPackage())), (Object)regInfo)) {
                LOG.warn("Failed to find {} registered under {}", (Object)regInfo, (Object)packageName);
            }
            regInfo.reg.close();
        }
    }

    @Holding(value={"this"})
    private static void removeImplicit(List<AbstractRegisteredModuleInfo> regs) {
        AbstractRegisteredModuleInfo reg = regs.get(0);
        if (reg instanceof ImplicitRegisteredModuleInfo) {
            LOG.debug("Removing implicit registration {}", (Object)reg);
            regs.remove(0);
            reg.reg.close();
        }
    }

    private static @NonNull YangTextSchemaSource toYangTextSource(SourceIdentifier identifier, YangModuleInfo moduleInfo) {
        return YangTextSchemaSource.delegateForByteSource((SourceIdentifier)identifier, (ByteSource)moduleInfo.getYangTextByteSource());
    }

    private static SourceIdentifier sourceIdentifierFrom(YangModuleInfo moduleInfo) {
        QName name = moduleInfo.getName();
        return RevisionSourceIdentifier.create((String)name.getLocalName(), (Optional)name.getRevision());
    }

    private static @NonNull List<@NonNull YangModuleInfo> flatDependencies(YangModuleInfo moduleInfo) {
        LinkedHashSet<YangModuleInfo> requiredInfos = new LinkedHashSet<YangModuleInfo>();
        AbstractModuleInfoTracker.flatDependencies(requiredInfos, moduleInfo);
        return ImmutableList.copyOf(requiredInfos).reverse();
    }

    private static void flatDependencies(Set<YangModuleInfo> set, YangModuleInfo moduleInfo) {
        if (set.add(moduleInfo)) {
            for (YangModuleInfo dep : moduleInfo.getImportedModules()) {
                AbstractModuleInfoTracker.flatDependencies(set, dep);
            }
        }
    }

    private static final class ImplicitRegisteredModuleInfo
    extends AbstractRegisteredModuleInfo {
        ImplicitRegisteredModuleInfo(YangModuleInfo info, YangTextSchemaSourceRegistration reg, ClassLoader loader) {
            super(info, reg, loader);
        }
    }

    private static final class ExplicitRegisteredModuleInfo
    extends AbstractRegisteredModuleInfo {
        private int refcount = 1;

        ExplicitRegisteredModuleInfo(YangModuleInfo info, YangTextSchemaSourceRegistration reg, ClassLoader loader) {
            super(info, reg, loader);
        }

        void incRef() {
            ++this.refcount;
        }

        boolean decRef() {
            return --this.refcount == 0;
        }

        @Override
        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return super.addToStringAttributes(helper).add("refCount", this.refcount);
        }
    }

    static abstract class AbstractRegisteredModuleInfo {
        final YangTextSchemaSourceRegistration reg;
        final YangModuleInfo info;
        final ClassLoader loader;

        AbstractRegisteredModuleInfo(YangModuleInfo info, YangTextSchemaSourceRegistration reg, ClassLoader loader) {
            this.info = Objects.requireNonNull(info);
            this.reg = Objects.requireNonNull(reg);
            this.loader = Objects.requireNonNull(loader);
        }

        public final String toString() {
            return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
        }

        MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
            return helper.add("info", (Object)this.info).add("registration", (Object)this.reg).add("classLoader", (Object)this.loader);
        }
    }
}

