/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.binding.runtime.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.binding.runtime.api.BindingRuntimeGenerator;
import org.opendaylight.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.binding.runtime.api.ClassLoadingStrategy;
import org.opendaylight.binding.runtime.api.DefaultBindingRuntimeContext;
import org.opendaylight.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.binding.runtime.spi.ModuleInfoSnapshotBuilder;
import org.opendaylight.binding.runtime.spi.ServiceLoaderState;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserFactory;

@Beta
public final class BindingRuntimeHelpers {
    private BindingRuntimeHelpers() {
    }

    public static @NonNull EffectiveModelContext createEffectiveModel(Class<?> ... classes) {
        return BindingRuntimeHelpers.createEffectiveModel(Arrays.stream(classes).map(BindingRuntimeHelpers::extractYangModuleInfo).collect(Collectors.toList()));
    }

    public static @NonNull EffectiveModelContext createEffectiveModel(Iterable<? extends YangModuleInfo> moduleInfos) {
        return BindingRuntimeHelpers.createEffectiveModel(ServiceLoaderState.ParserFactory.INSTANCE, moduleInfos);
    }

    public static @NonNull EffectiveModelContext createEffectiveModel(YangParserFactory parserFactory, Iterable<? extends YangModuleInfo> moduleInfos) {
        return BindingRuntimeHelpers.prepareContext(parserFactory, moduleInfos).getEffectiveModelContext();
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext() {
        ModuleInfoSnapshot infos = BindingRuntimeHelpers.prepareContext(ServiceLoaderState.ParserFactory.INSTANCE, (Iterable<? extends YangModuleInfo>)BindingReflections.loadModuleInfos());
        return DefaultBindingRuntimeContext.create((BindingRuntimeTypes)ServiceLoaderState.Generator.INSTANCE.generateTypeMapping(infos.getEffectiveModelContext()), (ClassLoadingStrategy)infos);
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(Class<?> ... classes) {
        return BindingRuntimeHelpers.createRuntimeContext(ServiceLoaderState.ParserFactory.INSTANCE, ServiceLoaderState.Generator.INSTANCE, classes);
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(YangParserFactory parserFactory, BindingRuntimeGenerator generator, Class<?> ... classes) {
        return BindingRuntimeHelpers.createRuntimeContext(parserFactory, generator, Arrays.asList(classes));
    }

    public static @NonNull BindingRuntimeContext createRuntimeContext(YangParserFactory parserFactory, BindingRuntimeGenerator generator, Collection<Class<?>> classes) {
        ModuleInfoSnapshot infos = BindingRuntimeHelpers.prepareContext(parserFactory, classes.stream().map(BindingRuntimeHelpers::extractYangModuleInfo).collect(Collectors.toList()));
        return DefaultBindingRuntimeContext.create((BindingRuntimeTypes)generator.generateTypeMapping(infos.getEffectiveModelContext()), (ClassLoadingStrategy)infos);
    }

    static @NonNull YangModuleInfo extractYangModuleInfo(Class<?> clazz) {
        try {
            return BindingReflections.getModuleInfo(clazz);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Failed to extract module info from " + clazz, e);
        }
    }

    private static @NonNull ModuleInfoSnapshot prepareContext(YangParserFactory parserFactory, Iterable<? extends YangModuleInfo> moduleInfos) {
        ModuleInfoSnapshotBuilder ctx = new ModuleInfoSnapshotBuilder("helper", parserFactory);
        ctx.registerModuleInfos(moduleInfos);
        return ctx.build();
    }
}

