/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcFutureAware;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.RpcResultUtil;
import org.opendaylight.mdsal.binding.dom.adapter.StaticConfiguration;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@NonNullByDefault
final class ActionAdapter
extends AbstractBindingAdapter<DOMActionService>
implements InvocationHandler {
    private final Class<? extends Action<?, ?, ?>> type;
    private final YangInstanceIdentifier.NodeIdentifier inputName;
    private final SchemaPath schemaPath;

    ActionAdapter(AdapterContext codec, DOMActionService delegate, Class<? extends Action<?, ?, ?>> type) {
        super(codec, delegate);
        this.type = Objects.requireNonNull(type);
        this.schemaPath = this.currentSerializer().getActionPath(type);
        this.inputName = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.operationInputQName((QNameModule)this.schemaPath.getLastComponent().getModule()));
    }

    @Override
    public @Nullable Object invoke(@Nullable Object proxy, @Nullable Method method, Object @Nullable [] args) throws Throwable {
        switch (method.getName()) {
            case "equals": {
                if (args.length != 1) break;
                return proxy == args[0];
            }
            case "hashCode": {
                if (args.length != 0) break;
                return System.identityHashCode(proxy);
            }
            case "toString": {
                if (args.length != 0) break;
                return this.type.getName() + "$Adapter{delegate=" + this.getDelegate() + "}";
            }
            case "invoke": {
                if (args.length != 2) break;
                InstanceIdentifier path = (InstanceIdentifier)Objects.requireNonNull(args[0]);
                RpcInput input = (RpcInput)Objects.requireNonNull(args[1]);
                CurrentAdapterSerializer serializer = this.currentSerializer();
                ListenableFuture future = ((DOMActionService)this.getDelegate()).invokeAction(this.schemaPath, new DOMDataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, serializer.toYangInstanceIdentifier(path)), (ContainerNode)serializer.toLazyNormalizedNodeActionInput(this.type, this.inputName, input));
                if (StaticConfiguration.ENABLE_CODEC_SHORTCUT && future instanceof BindingRpcFutureAware) {
                    return ((BindingRpcFutureAware)future).getBindingFuture();
                }
                return Futures.transform((ListenableFuture)future, dom -> RpcResultUtil.rpcResultFromDOM(dom.getErrors(), dom.getOutput().map(output -> serializer.fromNormalizedNodeActionOutput(this.type, (ContainerNode)output)).orElse(null)), (Executor)MoreExecutors.directExecutor());
            }
        }
        throw new NoSuchMethodError("Method " + method.toString() + "is unsupported.");
    }
}

