/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.cache.CacheLoader;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterBuilder;

public abstract class AdapterLoader<T, D>
extends CacheLoader<Class<? extends T>, Optional<T>> {
    public Optional<T> load(Class<? extends T> key) {
        AdapterBuilder<T, D> builder = this.createBuilder(key);
        for (Class<D> reqDeleg : builder.getRequiredDelegates()) {
            D deleg = this.getDelegate(reqDeleg);
            if (deleg != null) {
                builder.addDelegate(reqDeleg, deleg);
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(builder.build());
    }

    protected abstract @Nullable D getDelegate(Class<? extends D> var1);

    protected abstract @NonNull AdapterBuilder<? extends T, D> createBuilder(Class<? extends T> var1);
}

