/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataObjectModification;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

final class LazyDataTreeModification<T extends DataObject>
implements DataTreeModification<T> {
    private final @NonNull DataTreeIdentifier<T> path;
    private final @NonNull DataObjectModification<T> rootNode;

    private LazyDataTreeModification(DataTreeIdentifier<T> path, DataObjectModification<T> modification) {
        this.path = Objects.requireNonNull(path);
        this.rootNode = Objects.requireNonNull(modification);
    }

    static <T extends DataObject> DataTreeModification<T> create(CurrentAdapterSerializer serializer, DataTreeCandidate domChange, LogicalDatastoreType datastoreType) {
        InstanceIdentifier bindingPath = serializer.coerceInstanceIdentifier(domChange.getRootPath());
        BindingDataObjectCodecTreeNode codec = serializer.getSubtreeCodec(bindingPath);
        DataTreeIdentifier path = DataTreeIdentifier.create((LogicalDatastoreType)datastoreType, bindingPath);
        return new LazyDataTreeModification(path, LazyDataObjectModification.create(codec, domChange.getRootNode()));
    }

    static <T extends DataObject> DataTreeModification<T> create(CurrentAdapterSerializer serializer, DOMDataTreeCandidate candidate) {
        DOMDataTreeIdentifier domRootPath = candidate.getRootPath();
        InstanceIdentifier bindingPath = serializer.coerceInstanceIdentifier(domRootPath.getRootIdentifier());
        BindingDataObjectCodecTreeNode codec = serializer.getSubtreeCodec(bindingPath);
        return new LazyDataTreeModification(DataTreeIdentifier.create((LogicalDatastoreType)domRootPath.getDatastoreType(), bindingPath), LazyDataObjectModification.create(codec, candidate.getRootNode()));
    }

    static <T extends DataObject> @NonNull Collection<DataTreeModification<T>> from(CurrentAdapterSerializer codec, Collection<DataTreeCandidate> domChanges, LogicalDatastoreType datastoreType) {
        ArrayList<DataTreeModification<T>> result = new ArrayList<DataTreeModification<T>>(domChanges.size());
        for (DataTreeCandidate domChange : domChanges) {
            result.add(LazyDataTreeModification.create(codec, domChange, datastoreType));
        }
        return result;
    }

    public DataObjectModification<T> getRootNode() {
        return this.rootNode;
    }

    public DataTreeIdentifier<T> getRootPath() {
        return this.path;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", this.path).add("rootNode", this.rootNode).toString();
    }
}

