/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.time.Instant;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMEvent;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class LazySerializedDOMNotification
implements DOMNotification,
DOMEvent {
    private final @NonNull BindingNormalizedNodeSerializer codec;
    private final @NonNull Notification data;
    private final @NonNull SchemaPath type;
    private final @NonNull Instant eventInstant;
    private volatile ContainerNode domBody;

    LazySerializedDOMNotification(BindingNormalizedNodeSerializer codec, Notification data, SchemaPath type, Instant eventInstant) {
        this.codec = Objects.requireNonNull(codec);
        this.data = Objects.requireNonNull(data);
        this.type = Objects.requireNonNull(type);
        this.eventInstant = Objects.requireNonNull(eventInstant);
    }

    static @NonNull DOMNotification create(BindingNormalizedNodeSerializer codec, Notification data, Instant eventInstant) {
        SchemaPath type = SchemaPath.ROOT.createChild(BindingReflections.findQName((Class)data.implementedInterface()));
        return new LazySerializedDOMNotification(codec, data, type, eventInstant);
    }

    public SchemaPath getType() {
        return this.type;
    }

    public ContainerNode getBody() {
        ContainerNode local = this.domBody;
        if (local == null) {
            this.domBody = local = this.codec.toNormalizedNodeNotification(this.data);
        }
        return local;
    }

    public Instant getEventInstant() {
        return this.eventInstant;
    }

    public @NonNull Notification getBindingData() {
        return this.data;
    }
}

