/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcFutureAware;
import org.opendaylight.mdsal.binding.dom.adapter.ContextReferenceExtractor;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazySerializedContainerNode;
import org.opendaylight.mdsal.binding.dom.adapter.RpcResultUtil;
import org.opendaylight.mdsal.binding.dom.adapter.StaticConfiguration;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.spi.RpcRoutingStrategy;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

class RpcServiceAdapter
implements InvocationHandler {
    private final ImmutableMap<Method, RpcInvocationStrategy> rpcNames;
    private final Class<? extends RpcService> type;
    private final AdapterContext adapterContext;
    private final DOMRpcService delegate;
    private final RpcService proxy;

    RpcServiceAdapter(Class<? extends RpcService> type, AdapterContext adapterContext, DOMRpcService domService) {
        this.type = Objects.requireNonNull(type);
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.delegate = Objects.requireNonNull(domService);
        ImmutableBiMap<Method, RpcDefinition> methods = adapterContext.currentSerializer().getRpcMethodToSchema(type);
        ImmutableMap.Builder rpcBuilder = ImmutableMap.builderWithExpectedSize((int)methods.size());
        for (Map.Entry rpc : methods.entrySet()) {
            rpcBuilder.put((Object)((Method)rpc.getKey()), (Object)this.createStrategy((Method)rpc.getKey(), (RpcDefinition)rpc.getValue()));
        }
        this.rpcNames = rpcBuilder.build();
        this.proxy = (RpcService)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)this);
    }

    private RpcInvocationStrategy createStrategy(Method method, RpcDefinition schema) {
        RpcRoutingStrategy strategy = RpcRoutingStrategy.from((RpcDefinition)schema);
        if (strategy.isContextBasedRouted()) {
            return new RoutedStrategy(schema.getPath(), method, strategy.getLeaf());
        }
        return new NonRoutedStrategy(schema.getPath());
    }

    RpcService getProxy() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        RpcInvocationStrategy rpc = (RpcInvocationStrategy)this.rpcNames.get((Object)method);
        if (rpc != null) {
            if (args.length != 1) {
                throw new IllegalArgumentException("Input must be provided.");
            }
            return rpc.invoke((DataObject)Objects.requireNonNull(args[0]));
        }
        switch (method.getName()) {
            case "toString": {
                if (!method.getReturnType().equals(String.class) || method.getParameterCount() != 0) break;
                return this.type.getName() + "$Adapter{delegate=" + this.delegate.toString() + "}";
            }
            case "hashCode": {
                if (!method.getReturnType().equals(Integer.TYPE) || method.getParameterCount() != 0) break;
                return System.identityHashCode(proxy);
            }
            case "equals": {
                if (!method.getReturnType().equals(Boolean.TYPE) || method.getParameterCount() != 1 || method.getParameterTypes()[0] != Object.class) break;
                return proxy == args[0];
            }
        }
        throw new UnsupportedOperationException("Method " + method.toString() + "is unsupported.");
    }

    private final class RoutedStrategy
    extends RpcInvocationStrategy {
        private final ContextReferenceExtractor refExtractor;
        private final YangInstanceIdentifier.NodeIdentifier contextName;

        RoutedStrategy(SchemaPath path, Method rpcMethod, QName leafName) {
            super(path);
            Optional maybeInputType = BindingReflections.resolveRpcInputClass((Method)rpcMethod);
            Preconditions.checkState((boolean)maybeInputType.isPresent(), (String)"RPC method %s has no input", (Object)rpcMethod.getName());
            Class inputType = (Class)maybeInputType.get();
            this.refExtractor = ContextReferenceExtractor.from(inputType);
            this.contextName = new YangInstanceIdentifier.NodeIdentifier(leafName);
        }

        @Override
        ContainerNode serialize(DataObject input) {
            InstanceIdentifier<?> bindingII = this.refExtractor.extract(input);
            CurrentAdapterSerializer serializer = RpcServiceAdapter.this.adapterContext.currentSerializer();
            if (bindingII != null) {
                YangInstanceIdentifier yangII = serializer.toCachedYangInstanceIdentifier(bindingII);
                LeafNode contextRef = ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)this.contextName, (Object)yangII);
                return LazySerializedContainerNode.withContextRef(this.getRpcName(), input, contextRef, (BindingNormalizedNodeSerializer)serializer);
            }
            return LazySerializedContainerNode.create(this.getRpcName(), input, (BindingNormalizedNodeSerializer)serializer);
        }
    }

    private final class NonRoutedStrategy
    extends RpcInvocationStrategy {
        NonRoutedStrategy(SchemaPath path) {
            super(path);
        }

        @Override
        ContainerNode serialize(DataObject input) {
            return LazySerializedContainerNode.create(this.getRpcName(), input, (BindingNormalizedNodeSerializer)RpcServiceAdapter.this.adapterContext.currentSerializer());
        }
    }

    private abstract class RpcInvocationStrategy {
        private final SchemaPath rpcName;

        RpcInvocationStrategy(SchemaPath path) {
            this.rpcName = path;
        }

        final ListenableFuture<RpcResult<?>> invoke(DataObject input) {
            return this.invoke0(this.rpcName, this.serialize(input));
        }

        abstract ContainerNode serialize(DataObject var1);

        final SchemaPath getRpcName() {
            return this.rpcName;
        }

        ListenableFuture<RpcResult<?>> invoke0(SchemaPath schemaPath, ContainerNode input) {
            ListenableFuture result = RpcServiceAdapter.this.delegate.invokeRpc(schemaPath, (NormalizedNode)input);
            if (StaticConfiguration.ENABLE_CODEC_SHORTCUT && result instanceof BindingRpcFutureAware) {
                return ((BindingRpcFutureAware)result).getBindingFuture();
            }
            return this.transformFuture(schemaPath, (ListenableFuture<? extends DOMRpcResult>)result, (BindingNormalizedNodeSerializer)RpcServiceAdapter.this.adapterContext.currentSerializer());
        }

        private ListenableFuture<RpcResult<?>> transformFuture(SchemaPath rpc, ListenableFuture<? extends DOMRpcResult> domFuture, BindingNormalizedNodeSerializer resultCodec) {
            return Futures.transform(domFuture, input -> {
                DataObject bindingResult;
                NormalizedNode domData = input.getResult();
                if (domData != null) {
                    SchemaPath rpcOutput = rpc.createChild(YangConstants.operationOutputQName((QNameModule)rpc.getLastComponent().getModule()));
                    bindingResult = resultCodec.fromNormalizedNodeRpcData(rpcOutput, (ContainerNode)domData);
                } else {
                    bindingResult = null;
                }
                return RpcResultUtil.rpcResultFromDOM(input.getErrors(), bindingResult);
            }, (Executor)MoreExecutors.directExecutor());
        }
    }
}

