/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.invoke;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.common.QName;

public final class NotificationListenerInvoker {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final LoadingCache<Class<? extends NotificationListener>, NotificationListenerInvoker> INVOKERS = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Class<? extends NotificationListener>, NotificationListenerInvoker>(){

        public NotificationListenerInvoker load(Class<? extends NotificationListener> key) {
            return new NotificationListenerInvoker(this.createInvokerMap(key));
        }

        private ImmutableMap<QName, MethodHandle> createInvokerMap(Class<? extends NotificationListener> key) {
            ImmutableMap.Builder ret = ImmutableMap.builder();
            for (Method method : key.getMethods()) {
                if (!BindingReflections.isNotificationCallback((Method)method)) continue;
                Class<?> notification = method.getParameterTypes()[0];
                QName name = BindingReflections.findQName(notification);
                try {
                    MethodHandle handle = LOOKUP.unreflect(method).asType(MethodType.methodType(Void.TYPE, NotificationListener.class, DataContainer.class));
                    ret.put((Object)name, (Object)handle);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Can not access public method.", e);
                }
            }
            return ret.build();
        }
    });
    private final ImmutableMap<QName, MethodHandle> methodInvokers;

    NotificationListenerInvoker(ImmutableMap<QName, MethodHandle> map) {
        this.methodInvokers = map;
    }

    public static NotificationListenerInvoker from(Class<? extends NotificationListener> type) {
        Preconditions.checkArgument((boolean)type.isInterface());
        Preconditions.checkArgument((boolean)BindingReflections.isBindingClass(type));
        return (NotificationListenerInvoker)INVOKERS.getUnchecked(type);
    }

    public void invokeNotification(@NonNull NotificationListener impl, @NonNull QName rpcName, @Nullable DataContainer input) {
        Objects.requireNonNull(impl, "implemetation must be supplied");
        MethodHandle invoker = (MethodHandle)this.methodInvokers.get((Object)rpcName);
        Preconditions.checkArgument((invoker != null ? 1 : 0) != 0, (String)"Supplied notification is not valid for implementation %s", (Object)impl);
        try {
            invoker.invokeExact(impl, input);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

