/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.invoke;

import com.google.common.util.concurrent.ListenableFuture;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Optional;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.RpcMethodInvokerWithInput;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.RpcMethodInvokerWithoutInput;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

abstract class RpcMethodInvoker {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();

    RpcMethodInvoker() {
    }

    abstract ListenableFuture<RpcResult<?>> invokeOn(RpcService var1, DataObject var2);

    protected static RpcMethodInvoker from(Method method) {
        MethodHandle methodHandle;
        try {
            methodHandle = LOOKUP.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Lookup on public method failed.", e);
        }
        Optional input = BindingReflections.resolveRpcInputClass((Method)method);
        if (input.isPresent()) {
            return new RpcMethodInvokerWithInput(methodHandle);
        }
        return new RpcMethodInvokerWithoutInput(methodHandle);
    }
}

