/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.osgi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
final class Dict
extends Dictionary<String, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(Dict.class);
    private final Map<String, Object> map;

    private Dict(Map<String, Object> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    static Dict fromReference(ServiceReference<?> ref, BindingService service) {
        Object value;
        String[] keys = ref.getPropertyKeys();
        HashMap props = Maps.newHashMapWithExpectedSize((int)(keys.length + 1));
        for (String key : keys) {
            if (key.startsWith("odl.mdsal.binding.adapter.") || (value = ref.getProperty(key)) == null) continue;
            props.put(key, value);
        }
        for (String key : keys) {
            String newKey;
            if (!key.startsWith("odl.mdsal.binding.adapter.override.") || (value = ref.getProperty(key)) == null || (newKey = key.substring("odl.mdsal.binding.adapter.override.".length())).isEmpty()) continue;
            LOG.debug("Overriding property {}", (Object)newKey);
            props.put(newKey, value);
        }
        props.put("org.opendaylight.mdsal.binding.dom.adapter.osgi.AbstractAdaptedService.DELEGATE", service);
        return new Dict(props);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Enumeration<String> keys() {
        return Iterators.asEnumeration(this.map.keySet().iterator());
    }

    @Override
    public Enumeration<Object> elements() {
        return Iterators.asEnumeration(this.map.values().iterator());
    }

    @Override
    public Object get(@Nullable Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object remove(@Nullable Object key) {
        return this.map.remove(key);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Dict && this.map.equals(((Dict)obj).map);
    }

    public String toString() {
        return this.map.toString();
    }
}

