/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.query;

import org.opendaylight.mdsal.binding.api.query.DescendantQueryBuilder;
import org.opendaylight.mdsal.binding.api.query.MatchBuilderPath;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.api.query.QueryStructureException;
import org.opendaylight.mdsal.binding.dom.adapter.query.DefaultMatchBuilderPath;
import org.opendaylight.mdsal.binding.dom.adapter.query.QueryBuilderState;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

final class DefaultDescendantQueryBuilder<R extends DataObject, T extends DataObject>
implements DescendantQueryBuilder<T> {
    private final InstanceIdentifier.InstanceIdentifierBuilder<T> childPath;
    private final QueryBuilderState builder;

    DefaultDescendantQueryBuilder(BindingCodecTree codec, InstanceIdentifier<T> rootPath) {
        this.builder = new QueryBuilderState(codec, rootPath);
        this.childPath = rootPath.builder();
    }

    public <N extends ChildOf<? super T>> DescendantQueryBuilder<N> extractChild(Class<N> childClass) {
        this.childPath.child(childClass);
        return this;
    }

    public <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> DescendantQueryBuilder<N> extractChild(Class<C> caseClass, Class<N> childClass) {
        this.childPath.child(caseClass, childClass);
        return this;
    }

    public MatchBuilderPath<T, T> matching() {
        InstanceIdentifier selectPath = this.childPath.build();
        this.builder.setSelectPath(selectPath);
        return new DefaultMatchBuilderPath(this.builder, selectPath, this.childPath);
    }

    public QueryExpression<T> build() throws QueryStructureException {
        this.builder.setSelectPath(this.childPath.build());
        return this.builder.buildQuery();
    }
}

