/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.cds.types.rev191024.ClientGeneration;
import org.opendaylight.yangtools.concepts.WritableIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;
import org.opendaylight.yangtools.yang.common.Uint64;

@Beta
public final class ClientIdentifier
implements WritableIdentifier {
    private static final long serialVersionUID = 1L;
    private final @NonNull FrontendIdentifier frontendId;
    private final long generation;

    ClientIdentifier(FrontendIdentifier frontendId, long generation) {
        this.frontendId = Objects.requireNonNull(frontendId);
        this.generation = generation;
    }

    public static @NonNull ClientIdentifier create(FrontendIdentifier frontendId, long generation) {
        return new ClientIdentifier(frontendId, generation);
    }

    public static @NonNull ClientIdentifier readFrom(DataInput in) throws IOException {
        FrontendIdentifier frontendId = FrontendIdentifier.readFrom(in);
        return new ClientIdentifier(frontendId, WritableObjects.readLong((DataInput)in));
    }

    public void writeTo(DataOutput out) throws IOException {
        this.frontendId.writeTo(out);
        WritableObjects.writeLong((DataOutput)out, (long)this.generation);
    }

    public @NonNull FrontendIdentifier getFrontendId() {
        return this.frontendId;
    }

    public long getGeneration() {
        return this.generation;
    }

    public @NonNull ClientGeneration getYangGeneration() {
        return new ClientGeneration(Uint64.fromLongBits((long)this.generation));
    }

    public int hashCode() {
        return this.frontendId.hashCode() * 31 + Long.hashCode(this.generation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClientIdentifier)) {
            return false;
        }
        ClientIdentifier other = (ClientIdentifier)obj;
        return this.generation == other.generation && this.frontendId.equals(other.frontendId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(ClientIdentifier.class).add("frontend", (Object)this.frontendId).add("generation", (Object)Long.toUnsignedString(this.generation)).toString();
    }

    private Object writeReplace() {
        return new Proxy(this.frontendId, this.generation);
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private FrontendIdentifier frontendId;
        private long generation;

        public Proxy() {
        }

        Proxy(FrontendIdentifier frontendId, long generation) {
            this.frontendId = Objects.requireNonNull(frontendId);
            this.generation = generation;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            this.frontendId.writeTo(out);
            WritableObjects.writeLong((DataOutput)out, (long)this.generation);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.frontendId = FrontendIdentifier.readFrom(in);
            this.generation = WritableObjects.readLong((DataInput)in);
        }

        private Object readResolve() {
            return new ClientIdentifier(this.frontendId, this.generation);
        }
    }
}

