/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.schema.osgi.impl;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.schema.osgi.OSGiModuleInfoSnapshot;
import org.opendaylight.mdsal.dom.schema.osgi.impl.EffectiveModelContextImpl;
import org.opendaylight.mdsal.dom.spi.AbstractDOMSchemaService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DOMSchemaService.class}, immediate=true)
public final class OSGiDOMSchemaService
extends AbstractDOMSchemaService.WithYangTextSources {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDOMSchemaService.class);
    @Reference(target="(component.factory=org.opendaylight.mdsal.dom.schema.osgi.impl.SchemaSchemaContextListener)")
    ComponentFactory listenerFactory = null;
    private final List<EffectiveModelContextListener> listeners = new CopyOnWriteArrayList<EffectiveModelContextListener>();
    private volatile ModuleInfoSnapshot currentSnapshot;

    public EffectiveModelContext getGlobalContext() {
        return this.currentSnapshot.getEffectiveModelContext();
    }

    public ListenerRegistration<EffectiveModelContextListener> registerSchemaContextListener(EffectiveModelContextListener listener) {
        return this.registerListener(Objects.requireNonNull(listener));
    }

    public ListenableFuture<? extends YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
        return this.currentSnapshot.getSource(sourceIdentifier);
    }

    @Reference(fieldOption=FieldOption.REPLACE)
    void bindSnapshot(OSGiModuleInfoSnapshot newContext) {
        LOG.trace("Updating context to generation {}", (Object)newContext.getGeneration());
        ModuleInfoSnapshot snapshot = (ModuleInfoSnapshot)newContext.getService();
        EffectiveModelContext ctx = snapshot.getEffectiveModelContext();
        this.currentSnapshot = snapshot;
        this.listeners.forEach(listener -> OSGiDOMSchemaService.notifyListener(ctx, listener));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void addListener(EffectiveModelContextListener listener) {
        LOG.trace("Adding listener {}", (Object)listener);
        this.listeners.add(listener);
        listener.onModelContextUpdated(this.getGlobalContext());
    }

    void removeListener(EffectiveModelContextListener listener) {
        LOG.trace("Removing listener {}", (Object)listener);
        this.listeners.remove(listener);
    }

    @Activate
    void activate() {
        LOG.info("DOM Schema services activated");
    }

    @Deactivate
    void deactivate() {
        LOG.info("DOM Schema services deactivated");
    }

    private @NonNull ListenerRegistration<EffectiveModelContextListener> registerListener(final @NonNull EffectiveModelContextListener listener) {
        final ComponentInstance reg = this.listenerFactory.newInstance(EffectiveModelContextImpl.props(listener));
        return new ListenerRegistration<EffectiveModelContextListener>(){

            public EffectiveModelContextListener getInstance() {
                return listener;
            }

            public void close() {
                reg.dispose();
            }
        };
    }

    private static void notifyListener(EffectiveModelContext context, EffectiveModelContextListener listener) {
        try {
            listener.onModelContextUpdated(context);
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to notify listener {}", (Object)listener, (Object)e);
        }
    }
}

