/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.messagebus.app.impl;

import com.google.common.annotations.Beta;
import org.opendaylight.controller.messagebus.app.impl.EventSourceTopology;
import org.opendaylight.controller.messagebus.spi.EventSource;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistration;
import org.opendaylight.controller.messagebus.spi.EventSourceRegistry;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
public final class OSGiEventSourceRegistry
implements EventSourceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiEventSourceRegistry.class);
    @Reference
    DataBroker dataBroker;
    @Reference
    RpcConsumerRegistry rpcConsumerRegistry;
    @Reference
    RpcProviderService rpcProviderService;
    private EventSourceTopology delegate;

    public <T extends EventSource> EventSourceRegistration<T> registerEventSource(T eventSource) {
        return this.delegate.registerEventSource(eventSource);
    }

    public void close() {
    }

    @Activate
    void activate() {
        this.delegate = new EventSourceTopology(this.dataBroker, this.rpcProviderService, this.rpcConsumerRegistry);
        LOG.info("Event Source Registry started");
    }

    @Deactivate
    void deactivate() {
        LOG.info("Event Source Registry stopping");
        this.delegate.close();
        LOG.info("Event Source Registry stopped");
    }
}

