/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc6241.parser;

import com.google.common.annotations.Beta;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc6241.model.api.GetFilterElementAttributesEffectiveStatement;
import org.opendaylight.yangtools.rfc6241.model.api.GetFilterElementAttributesSchemaNode;
import org.opendaylight.yangtools.rfc6241.model.api.GetFilterElementAttributesStatement;
import org.opendaylight.yangtools.rfc6241.model.api.NetconfStatements;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractVoidStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class GetFilterElementAttributesStatementSupport
extends AbstractVoidStatementSupport<GetFilterElementAttributesStatement, GetFilterElementAttributesEffectiveStatement> {
    private static final Logger LOG = LoggerFactory.getLogger(GetFilterElementAttributesStatementSupport.class);
    private static final GetFilterElementAttributesStatementSupport INSTANCE = new GetFilterElementAttributesStatementSupport((StatementDefinition)NetconfStatements.GET_FILTER_ELEMENT_ATTRIBUTES);
    private final SubstatementValidator validator;

    GetFilterElementAttributesStatementSupport(StatementDefinition definition) {
        super(definition);
        this.validator = SubstatementValidator.builder((StatementDefinition)definition).build();
    }

    public static GetFilterElementAttributesStatementSupport getInstance() {
        return INSTANCE;
    }

    public GetFilterElementAttributesStatement createDeclared(StmtContext<Void, GetFilterElementAttributesStatement, ?> ctx) {
        return new Declared(ctx);
    }

    public GetFilterElementAttributesEffectiveStatement createEffective(StmtContext<Void, GetFilterElementAttributesStatement, GetFilterElementAttributesEffectiveStatement> ctx) {
        return new Effective(ctx);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return this.validator;
    }

    public void onFullDefinitionDeclared(StmtContext.Mutable<Void, GetFilterElementAttributesStatement, GetFilterElementAttributesEffectiveStatement> stmt) {
        super.onFullDefinitionDeclared(stmt);
        stmt.setIsSupportedToBuildEffective(GetFilterElementAttributesStatementSupport.computeSupported(stmt));
    }

    private static boolean computeSupported(StmtContext<?, ?, ?> stmt) {
        StmtContext parent = stmt.getParentContext();
        if (parent == null) {
            LOG.debug("No parent, ignoring get-filter-element-attributes statement");
            return false;
        }
        if (parent.getPublicDefinition() != YangStmtMapping.ANYXML) {
            LOG.debug("Parent is not an anyxml node, ignoring get-filter-element-attributes statement");
            return false;
        }
        if (!"filter".equals(parent.rawStatementArgument())) {
            LOG.debug("Parent is not named 'filter', ignoring get-filter-element-attributes statement");
            return false;
        }
        StmtContext grandParent = parent.getParentContext();
        if (grandParent == null) {
            LOG.debug("No grandparent, ignoring get-filter-element-attributes statement");
            return false;
        }
        if (grandParent.getPublicDefinition() != YangStmtMapping.INPUT) {
            LOG.debug("Grandparent is not an input node, ignoring get-filter-element-attributes statement");
            return false;
        }
        StmtContext greatGrandParent = grandParent.getParentContext();
        if (greatGrandParent == null) {
            LOG.debug("No grandparent, ignoring get-filter-element-attributes statement");
            return false;
        }
        if (greatGrandParent.getPublicDefinition() != YangStmtMapping.RPC) {
            LOG.debug("Grandparent is not an RPC node, ignoring get-filter-element-attributes statement");
            return false;
        }
        switch (greatGrandParent.rawStatementArgument()) {
            case "get": 
            case "get-config": {
                return true;
            }
        }
        LOG.debug("Great-grandparent is not named 'get' nor 'get-config, ignoring get-filter-element-attributes statement");
        return false;
    }

    private static final class Effective
    extends UnknownEffectiveStatementBase<Void, GetFilterElementAttributesStatement>
    implements GetFilterElementAttributesEffectiveStatement,
    GetFilterElementAttributesSchemaNode {
        private final @NonNull SchemaPath path;

        Effective(StmtContext<Void, GetFilterElementAttributesStatement, ?> ctx) {
            super(ctx);
            this.path = ((SchemaPath)ctx.coerceParentContext().getSchemaPath().get()).createChild(ctx.getPublicDefinition().getStatementName());
        }

        public QName getQName() {
            return this.path.getLastComponent();
        }

        @Deprecated
        public SchemaPath getPath() {
            return this.path;
        }
    }

    private static final class Declared
    extends AbstractDeclaredStatement<Void>
    implements GetFilterElementAttributesStatement {
        Declared(StmtContext<Void, ?, ?> context) {
            super(context);
        }

        public Void getArgument() {
            return null;
        }
    }
}

