/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.entityownership;

import akka.actor.ActorRef;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfiguration;
import org.opendaylight.controller.cluster.datastore.messages.CreateShard;
import org.opendaylight.controller.cluster.datastore.messages.GetShardDataTree;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.entityownership.DistributedEntityOwnershipCandidateRegistration;
import org.opendaylight.controller.cluster.entityownership.DistributedEntityOwnershipListenerRegistration;
import org.opendaylight.controller.cluster.entityownership.EntityOwnersModel;
import org.opendaylight.controller.cluster.entityownership.EntityOwnershipShard;
import org.opendaylight.controller.cluster.entityownership.messages.RegisterCandidateLocal;
import org.opendaylight.controller.cluster.entityownership.messages.RegisterListenerLocal;
import org.opendaylight.controller.cluster.entityownership.messages.UnregisterCandidateLocal;
import org.opendaylight.controller.cluster.entityownership.messages.UnregisterListenerLocal;
import org.opendaylight.controller.cluster.entityownership.selectionstrategy.EntityOwnerSelectionStrategyConfig;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipState;
import org.opendaylight.mdsal.eos.common.api.GenericEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipCandidateRegistration;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListenerRegistration;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.EntityOwners;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class DistributedEntityOwnershipService
implements DOMEntityOwnershipService,
AutoCloseable {
    @VisibleForTesting
    static final String ENTITY_OWNERSHIP_SHARD_NAME = "entity-ownership";
    private static final Logger LOG = LoggerFactory.getLogger(DistributedEntityOwnershipService.class);
    private static final Timeout MESSAGE_TIMEOUT = new Timeout(1L, TimeUnit.MINUTES);
    private final ConcurrentMap<DOMEntity, DOMEntity> registeredEntities = new ConcurrentHashMap<DOMEntity, DOMEntity>();
    private final ActorUtils context;
    private volatile ActorRef localEntityOwnershipShard;
    private volatile DataTree localEntityOwnershipShardDataTree;

    DistributedEntityOwnershipService(ActorUtils context) {
        this.context = Objects.requireNonNull(context);
    }

    public static DistributedEntityOwnershipService start(ActorUtils context, EntityOwnerSelectionStrategyConfig strategyConfig) {
        ActorRef shardManagerActor = context.getShardManager();
        Configuration configuration = context.getConfiguration();
        Collection entityOwnersMemberNames = configuration.getUniqueMemberNamesForAllShards();
        CreateShard createShard = new CreateShard(new ModuleShardConfiguration(EntityOwners.QNAME.getNamespace(), "entity-owners", ENTITY_OWNERSHIP_SHARD_NAME, "module", entityOwnersMemberNames), (Shard.AbstractBuilder)DistributedEntityOwnershipService.newShardBuilder(context, strategyConfig), null);
        Future createFuture = context.executeOperationAsync(shardManagerActor, (Object)createShard, MESSAGE_TIMEOUT);
        createFuture.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    LOG.error("Failed to create {} shard", (Object)DistributedEntityOwnershipService.ENTITY_OWNERSHIP_SHARD_NAME, (Object)failure);
                } else {
                    LOG.info("Successfully created {} shard", (Object)DistributedEntityOwnershipService.ENTITY_OWNERSHIP_SHARD_NAME);
                }
            }
        }, context.getClientDispatcher());
        return new DistributedEntityOwnershipService(context);
    }

    private void executeEntityOwnershipShardOperation(final ActorRef shardActor, final Object message) {
        Future future = this.context.executeOperationAsync(shardActor, message, MESSAGE_TIMEOUT);
        future.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    LOG.error("Error sending message {} to {}", new Object[]{message, shardActor, failure});
                } else {
                    LOG.debug("{} message to {} succeeded", message, (Object)shardActor);
                }
            }
        }, this.context.getClientDispatcher());
    }

    @VisibleForTesting
    void executeLocalEntityOwnershipShardOperation(final Object message) {
        if (this.localEntityOwnershipShard == null) {
            Future future = this.context.findLocalShardAsync(ENTITY_OWNERSHIP_SHARD_NAME);
            future.onComplete((Function1)new OnComplete<ActorRef>(){

                public void onComplete(Throwable failure, ActorRef shardActor) {
                    if (failure != null) {
                        LOG.error("Failed to find local {} shard", (Object)DistributedEntityOwnershipService.ENTITY_OWNERSHIP_SHARD_NAME, (Object)failure);
                    } else {
                        DistributedEntityOwnershipService.this.localEntityOwnershipShard = shardActor;
                        DistributedEntityOwnershipService.this.executeEntityOwnershipShardOperation(DistributedEntityOwnershipService.this.localEntityOwnershipShard, message);
                    }
                }
            }, this.context.getClientDispatcher());
        } else {
            this.executeEntityOwnershipShardOperation(this.localEntityOwnershipShard, message);
        }
    }

    public DOMEntityOwnershipCandidateRegistration registerCandidate(DOMEntity entity) throws CandidateAlreadyRegisteredException {
        Objects.requireNonNull(entity, "entity cannot be null");
        if (this.registeredEntities.putIfAbsent(entity, entity) != null) {
            throw new CandidateAlreadyRegisteredException((GenericEntity)entity);
        }
        RegisterCandidateLocal registerCandidate = new RegisterCandidateLocal(entity);
        LOG.debug("Registering candidate with message: {}", (Object)registerCandidate);
        this.executeLocalEntityOwnershipShardOperation(registerCandidate);
        return new DistributedEntityOwnershipCandidateRegistration(entity, this);
    }

    void unregisterCandidate(DOMEntity entity) {
        LOG.debug("Unregistering candidate for {}", (Object)entity);
        this.executeLocalEntityOwnershipShardOperation(new UnregisterCandidateLocal(entity));
        this.registeredEntities.remove(entity);
    }

    public DOMEntityOwnershipListenerRegistration registerListener(String entityType, DOMEntityOwnershipListener listener) {
        RegisterListenerLocal registerListener = new RegisterListenerLocal(listener, entityType);
        LOG.debug("Registering listener with message: {}", (Object)registerListener);
        this.executeLocalEntityOwnershipShardOperation(registerListener);
        return new DistributedEntityOwnershipListenerRegistration(listener, entityType, this);
    }

    public Optional<EntityOwnershipState> getOwnershipState(DOMEntity forEntity) {
        boolean hasCandidates;
        Objects.requireNonNull(forEntity, "forEntity cannot be null");
        DataTree dataTree = this.getLocalEntityOwnershipShardDataTree();
        if (dataTree == null) {
            return Optional.empty();
        }
        Optional entityNode = dataTree.takeSnapshot().readNode(EntityOwnersModel.entityPath(forEntity.getType(), (YangInstanceIdentifier)forEntity.getIdentifier()));
        if (!entityNode.isPresent()) {
            return Optional.empty();
        }
        MapEntryNode entity = (MapEntryNode)entityNode.get();
        Optional optionalCandidates = entity.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.CANDIDATE_NODE_ID);
        boolean bl = hasCandidates = optionalCandidates.isPresent() && ((MapNode)optionalCandidates.get()).getValue().size() > 0;
        if (!hasCandidates) {
            return Optional.empty();
        }
        MemberName localMemberName = this.context.getCurrentMemberName();
        Optional ownerLeaf = entity.getChild((YangInstanceIdentifier.PathArgument)EntityOwnersModel.ENTITY_OWNER_NODE_ID);
        String owner = ownerLeaf.isPresent() ? ((DataContainerChild)ownerLeaf.get()).getValue().toString() : null;
        boolean hasOwner = !Strings.isNullOrEmpty(owner);
        boolean isOwner = hasOwner && localMemberName.getName().equals(owner);
        return Optional.of(EntityOwnershipState.from((boolean)isOwner, (boolean)hasOwner));
    }

    public boolean isCandidateRegistered(DOMEntity entity) {
        return this.registeredEntities.get(entity) != null;
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Akka's Await.result() API contract")
    DataTree getLocalEntityOwnershipShardDataTree() {
        DataTree local = this.localEntityOwnershipShardDataTree;
        if (local != null) {
            return local;
        }
        if (this.localEntityOwnershipShard == null) {
            try {
                this.localEntityOwnershipShard = (ActorRef)Await.result((Awaitable)this.context.findLocalShardAsync(ENTITY_OWNERSHIP_SHARD_NAME), (Duration)Duration.Inf());
            }
            catch (InterruptedException | TimeoutException e) {
                LOG.error("Failed to find local {} shard", (Object)ENTITY_OWNERSHIP_SHARD_NAME, (Object)e);
                return null;
            }
        }
        try {
            this.localEntityOwnershipShardDataTree = (DataTree)Await.result((Awaitable)Patterns.ask((ActorRef)this.localEntityOwnershipShard, (Object)GetShardDataTree.INSTANCE, (Timeout)MESSAGE_TIMEOUT), (Duration)Duration.Inf());
            return this.localEntityOwnershipShardDataTree;
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.error("Failed to find local {} shard", (Object)ENTITY_OWNERSHIP_SHARD_NAME, (Object)e);
            return null;
        }
    }

    void unregisterListener(String entityType, DOMEntityOwnershipListener listener) {
        LOG.debug("Unregistering listener {} for entity type {}", (Object)listener, (Object)entityType);
        this.executeLocalEntityOwnershipShardOperation(new UnregisterListenerLocal(listener, entityType));
    }

    @Override
    public void close() {
    }

    private static EntityOwnershipShard.Builder newShardBuilder(ActorUtils context, EntityOwnerSelectionStrategyConfig strategyConfig) {
        return EntityOwnershipShard.newBuilder().localMemberName(context.getCurrentMemberName()).ownerSelectionStrategyConfig(strategyConfig);
    }

    @VisibleForTesting
    ActorRef getLocalEntityOwnershipShard() {
        return this.localEntityOwnershipShard;
    }
}

