/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceXMLStreamReader;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.AbstractNormalizableAnydata;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.xml.sax.SAXException;

@NonNullByDefault
final class DOMSourceAnydata
extends AbstractNormalizableAnydata {
    private final DOMSource source;

    DOMSourceAnydata(DOMSource source) {
        this.source = Objects.requireNonNull(source);
    }

    XMLStreamReader toStreamReader() throws XMLStreamException {
        return new DOMSourceXMLStreamReader(this.source);
    }

    protected void writeTo(NormalizedNodeStreamWriter streamWriter, EffectiveModelContext schemaContext, DataSchemaNode contextNode) throws IOException {
        XmlParserStream xmlParser;
        try {
            xmlParser = XmlParserStream.create(streamWriter, schemaContext, (SchemaNode)contextNode);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Failed to instantiate XML parser", e);
        }
        try {
            XMLStreamReader reader = this.toStreamReader();
            reader.nextTag();
            xmlParser.parse(reader).flush();
        }
        catch (URISyntaxException | XMLStreamException | SAXException e) {
            throw new IOException("Failed to parse payload", e);
        }
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("source", (Object)this.source);
    }

    @VisibleForTesting
    DOMSource getSource() {
        return this.source;
    }
}

