/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.admin;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Status;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.admin.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.AddPrefixShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.AddShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.ChangeShardMembersVotingStatus;
import org.opendaylight.controller.cluster.datastore.messages.FlipShardMembersVotingStatus;
import org.opendaylight.controller.cluster.datastore.messages.GetKnownClients;
import org.opendaylight.controller.cluster.datastore.messages.GetKnownClientsReply;
import org.opendaylight.controller.cluster.datastore.messages.GetShardRole;
import org.opendaylight.controller.cluster.datastore.messages.GetShardRoleReply;
import org.opendaylight.controller.cluster.datastore.messages.MakeLeaderLocal;
import org.opendaylight.controller.cluster.datastore.messages.PrimaryShardInfo;
import org.opendaylight.controller.cluster.datastore.messages.RemovePrefixShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.RemoveShardReplica;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshotList;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.controller.cluster.raft.client.messages.GetSnapshot;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddPrefixShardReplicaInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddPrefixShardReplicaOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddPrefixShardReplicaOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddReplicasForAllShardsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddReplicasForAllShardsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddReplicasForAllShardsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddShardReplicaInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddShardReplicaOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddShardReplicaOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.BackupDatastoreInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.BackupDatastoreOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.BackupDatastoreOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForAllShardsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForAllShardsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForAllShardsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForShardInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForShardOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForShardOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ClusterAdminService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.FlipMemberVotingStatesForAllShardsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.FlipMemberVotingStatesForAllShardsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.FlipMemberVotingStatesForAllShardsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetKnownClientsForAllShardsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetKnownClientsForAllShardsOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetKnownClientsForAllShardsOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetPrefixShardRoleInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetPrefixShardRoleOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetPrefixShardRoleOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetShardRoleInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetShardRoleOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.GetShardRoleOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.LocateShardInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.LocateShardOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.LocateShardOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MakeLeaderLocalInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MakeLeaderLocalOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MakeLeaderLocalOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveAllShardReplicasInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveAllShardReplicasOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveAllShardReplicasOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemovePrefixShardReplicaInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemovePrefixShardReplicaOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemovePrefixShardReplicaOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveShardReplicaInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveShardReplicaOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.RemoveShardReplicaOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.get.known.clients._for.all.shards.output.ShardResult1Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.get.known.clients._for.all.shards.output.shard.result.KnownClients;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.get.known.clients._for.all.shards.output.shard.result.KnownClientsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.locate.shard.output.MemberNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.locate.shard.output.member.node.LeaderActorRefBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.locate.shard.output.member.node.LocalBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.member.voting.states.input.MemberVotingState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResult;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResultBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResultKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Promise;

public class ClusterAdminRpcService
implements ClusterAdminService {
    private static final Timeout SHARD_MGR_TIMEOUT = new Timeout(1L, TimeUnit.MINUTES);
    private static final Logger LOG = LoggerFactory.getLogger(ClusterAdminRpcService.class);
    private static final @NonNull RpcResult<LocateShardOutput> LOCAL_SHARD_RESULT = RpcResultBuilder.success((Object)new LocateShardOutputBuilder().setMemberNode((MemberNode)new LocalBuilder().setLocal(Empty.getInstance()).build()).build()).build();
    private final DistributedDataStoreInterface configDataStore;
    private final DistributedDataStoreInterface operDataStore;
    private final BindingNormalizedNodeSerializer serializer;
    private final Timeout makeLeaderLocalTimeout;

    public ClusterAdminRpcService(DistributedDataStoreInterface configDataStore, DistributedDataStoreInterface operDataStore, BindingNormalizedNodeSerializer serializer) {
        this.configDataStore = configDataStore;
        this.operDataStore = operDataStore;
        this.serializer = serializer;
        this.makeLeaderLocalTimeout = new Timeout(configDataStore.getActorUtils().getDatastoreContext().getShardLeaderElectionTimeout().duration().$times(2L));
    }

    public ListenableFuture<RpcResult<AddShardReplicaOutput>> addShardReplica(AddShardReplicaInput input) {
        final String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard name must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        LOG.info("Adding replica for shard {}", (Object)shardName);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new AddShardReplica(shardName));
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Status.Success>(){

            public void onSuccess(Status.Success success) {
                LOG.info("Successfully added replica for shard {}", (Object)shardName);
                returnFuture.set(ClusterAdminRpcService.newSuccessfulResult(new AddShardReplicaOutputBuilder().build()));
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onMessageFailure(String.format("Failed to add replica for shard %s", shardName), returnFuture, failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return returnFuture;
    }

    public ListenableFuture<RpcResult<RemoveShardReplicaOutput>> removeShardReplica(RemoveShardReplicaInput input) {
        final String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard name must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        String memberName = input.getMemberName();
        if (Strings.isNullOrEmpty((String)memberName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid member name must be specified");
        }
        LOG.info("Removing replica for shard {} memberName {}, datastoreType {}", new Object[]{shardName, memberName, dataStoreType});
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new RemoveShardReplica(shardName, MemberName.forName((String)memberName)));
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Status.Success>(){

            public void onSuccess(Status.Success success) {
                LOG.info("Successfully removed replica for shard {}", (Object)shardName);
                returnFuture.set(ClusterAdminRpcService.newSuccessfulResult(new RemoveShardReplicaOutputBuilder().build()));
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onMessageFailure(String.format("Failed to remove replica for shard %s", shardName), returnFuture, failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return returnFuture;
    }

    public ListenableFuture<RpcResult<LocateShardOutput>> locateShard(final LocateShardInput input) {
        ActorUtils utils;
        switch (input.getDataStoreType()) {
            case Config: {
                utils = this.configDataStore.getActorUtils();
                break;
            }
            case Operational: {
                utils = this.operDataStore.getActorUtils();
                break;
            }
            default: {
                return ClusterAdminRpcService.newFailedRpcResultFuture("Unhandled datastore in " + input);
            }
        }
        final SettableFuture ret = SettableFuture.create();
        utils.findPrimaryShardAsync(input.getShardName()).onComplete((Function1)new OnComplete<PrimaryShardInfo>(){

            public void onComplete(Throwable failure, PrimaryShardInfo success) throws Throwable {
                if (failure != null) {
                    LOG.debug("Failed to find shard for {}", (Object)input, (Object)failure);
                    ret.setException(failure);
                    return;
                }
                if (success.getLocalShardDataTree().isPresent()) {
                    ret.set(LOCAL_SHARD_RESULT);
                    return;
                }
                ActorSelection actorPath = success.getPrimaryShardActor();
                ret.set(ClusterAdminRpcService.newSuccessfulResult(new LocateShardOutputBuilder().setMemberNode((MemberNode)new LeaderActorRefBuilder().setLeaderActorRef(actorPath.toSerializationFormat()).build()).build()));
            }
        }, utils.getClientDispatcher());
        return ret;
    }

    public ListenableFuture<RpcResult<MakeLeaderLocalOutput>> makeLeaderLocal(MakeLeaderLocalInput input) {
        final String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard name must be specified");
        }
        final DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        final ActorUtils actorUtils = dataStoreType == DataStoreType.Config ? this.configDataStore.getActorUtils() : this.operDataStore.getActorUtils();
        LOG.info("Moving leader to local node {} for shard {}, datastoreType {}", new Object[]{actorUtils.getCurrentMemberName().getName(), shardName, dataStoreType});
        scala.concurrent.Future localShardReply = actorUtils.findLocalShardAsync(shardName);
        final Promise makeLeaderLocalAsk = akka.dispatch.Futures.promise();
        localShardReply.onComplete((Function1)new OnComplete<ActorRef>(){

            public void onComplete(Throwable failure, ActorRef actorRef) {
                if (failure != null) {
                    LOG.warn("No local shard found for {} datastoreType {} - Cannot request leadership transfer to local shard.", new Object[]{shardName, dataStoreType, failure});
                    makeLeaderLocalAsk.failure(failure);
                } else {
                    makeLeaderLocalAsk.completeWith(actorUtils.executeOperationAsync(actorRef, (Object)MakeLeaderLocal.INSTANCE, ClusterAdminRpcService.this.makeLeaderLocalTimeout));
                }
            }
        }, actorUtils.getClientDispatcher());
        final SettableFuture future = SettableFuture.create();
        makeLeaderLocalAsk.future().onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object success) {
                if (failure != null) {
                    LOG.error("Leadership transfer failed for shard {}.", (Object)shardName, (Object)failure);
                    future.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "leadership transfer failed", failure).build());
                    return;
                }
                LOG.debug("Leadership transfer complete");
                future.set((Object)RpcResultBuilder.success((Object)new MakeLeaderLocalOutputBuilder().build()).build());
            }
        }, actorUtils.getClientDispatcher());
        return future;
    }

    public ListenableFuture<RpcResult<AddPrefixShardReplicaOutput>> addPrefixShardReplica(AddPrefixShardReplicaInput input) {
        InstanceIdentifier identifier = input.getShardPrefix();
        if (identifier == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard identifier must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        LOG.info("Adding replica for shard {}, datastore type {}", (Object)identifier, (Object)dataStoreType);
        final YangInstanceIdentifier prefix = this.serializer.toYangInstanceIdentifier(identifier);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new AddPrefixShardReplica(prefix));
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Status.Success>(){

            public void onSuccess(Status.Success success) {
                LOG.info("Successfully added replica for shard {}", (Object)prefix);
                returnFuture.set(ClusterAdminRpcService.newSuccessfulResult(new AddPrefixShardReplicaOutputBuilder().build()));
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onMessageFailure(String.format("Failed to add replica for shard %s", prefix), returnFuture, failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return returnFuture;
    }

    public ListenableFuture<RpcResult<RemovePrefixShardReplicaOutput>> removePrefixShardReplica(RemovePrefixShardReplicaInput input) {
        InstanceIdentifier identifier = input.getShardPrefix();
        if (identifier == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard identifier must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        String memberName = input.getMemberName();
        if (Strings.isNullOrEmpty((String)memberName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid member name must be specified");
        }
        LOG.info("Removing replica for shard {} memberName {}, datastoreType {}", new Object[]{identifier, memberName, dataStoreType});
        final YangInstanceIdentifier prefix = this.serializer.toYangInstanceIdentifier(identifier);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new RemovePrefixShardReplica(prefix, MemberName.forName((String)memberName)));
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Status.Success>(){

            public void onSuccess(Status.Success success) {
                LOG.info("Successfully removed replica for shard {}", (Object)prefix);
                returnFuture.set(ClusterAdminRpcService.newSuccessfulResult(new RemovePrefixShardReplicaOutputBuilder().build()));
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onMessageFailure(String.format("Failed to remove replica for shard %s", prefix), returnFuture, failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return returnFuture;
    }

    public ListenableFuture<RpcResult<AddReplicasForAllShardsOutput>> addReplicasForAllShards(AddReplicasForAllShardsInput input) {
        LOG.info("Adding replicas for all shards");
        ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>> shardResultData = new ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>>();
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Config, shardResultData, AddShardReplica::new);
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Operational, shardResultData, AddShardReplica::new);
        return ClusterAdminRpcService.waitForShardResults(shardResultData, shardResults -> new AddReplicasForAllShardsOutputBuilder().setShardResult(shardResults).build(), "Failed to add replica");
    }

    public ListenableFuture<RpcResult<RemoveAllShardReplicasOutput>> removeAllShardReplicas(RemoveAllShardReplicasInput input) {
        LOG.info("Removing replicas for all shards");
        String memberName = input.getMemberName();
        if (Strings.isNullOrEmpty((String)memberName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid member name must be specified");
        }
        ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>> shardResultData = new ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>>();
        Function<String, Object> messageSupplier = shardName -> new RemoveShardReplica(shardName, MemberName.forName((String)memberName));
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Config, shardResultData, messageSupplier);
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Operational, shardResultData, messageSupplier);
        return ClusterAdminRpcService.waitForShardResults(shardResultData, shardResults -> new RemoveAllShardReplicasOutputBuilder().setShardResult(shardResults).build(), "       Failed to remove replica");
    }

    public ListenableFuture<RpcResult<ChangeMemberVotingStatesForShardOutput>> changeMemberVotingStatesForShard(ChangeMemberVotingStatesForShardInput input) {
        final String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard name must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        List memberVotingStates = input.getMemberVotingState();
        if (memberVotingStates == null || memberVotingStates.isEmpty()) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("No member voting state input was specified");
        }
        ChangeShardMembersVotingStatus changeVotingStatus = ClusterAdminRpcService.toChangeShardMembersVotingStatus(shardName, memberVotingStates);
        LOG.info("Change member voting states for shard {}: {}", (Object)shardName, (Object)changeVotingStatus.getMeberVotingStatusMap());
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, changeVotingStatus);
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Status.Success>(){

            public void onSuccess(Status.Success success) {
                LOG.info("Successfully changed member voting states for shard {}", (Object)shardName);
                returnFuture.set(ClusterAdminRpcService.newSuccessfulResult(new ChangeMemberVotingStatesForShardOutputBuilder().build()));
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onMessageFailure(String.format("Failed to change member voting states for shard %s", shardName), returnFuture, failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return returnFuture;
    }

    public ListenableFuture<RpcResult<ChangeMemberVotingStatesForAllShardsOutput>> changeMemberVotingStatesForAllShards(ChangeMemberVotingStatesForAllShardsInput input) {
        List memberVotingStates = input.getMemberVotingState();
        if (memberVotingStates == null || memberVotingStates.isEmpty()) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("No member voting state input was specified");
        }
        ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>> shardResultData = new ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>>();
        Function<String, Object> messageSupplier = shardName -> ClusterAdminRpcService.toChangeShardMembersVotingStatus(shardName, memberVotingStates);
        LOG.info("Change member voting states for all shards");
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Config, shardResultData, messageSupplier);
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Operational, shardResultData, messageSupplier);
        return ClusterAdminRpcService.waitForShardResults(shardResultData, shardResults -> new ChangeMemberVotingStatesForAllShardsOutputBuilder().setShardResult(shardResults).build(), "Failed to change member voting states");
    }

    public ListenableFuture<RpcResult<FlipMemberVotingStatesForAllShardsOutput>> flipMemberVotingStatesForAllShards(FlipMemberVotingStatesForAllShardsInput input) {
        ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>> shardResultData = new ArrayList<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>>();
        Function<String, Object> messageSupplier = FlipShardMembersVotingStatus::new;
        LOG.info("Flip member voting states for all shards");
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Config, shardResultData, messageSupplier);
        this.sendMessageToManagerForConfiguredShards(DataStoreType.Operational, shardResultData, messageSupplier);
        return ClusterAdminRpcService.waitForShardResults(shardResultData, shardResults -> new FlipMemberVotingStatesForAllShardsOutputBuilder().setShardResult(shardResults).build(), "Failed to change member voting states");
    }

    public ListenableFuture<RpcResult<GetShardRoleOutput>> getShardRole(GetShardRoleInput input) {
        final String shardName = input.getShardName();
        if (Strings.isNullOrEmpty((String)shardName)) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard name must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        LOG.info("Getting role for shard {}, datastore type {}", (Object)shardName, (Object)dataStoreType);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new GetShardRole(shardName));
        Futures.addCallback(future, (FutureCallback)new FutureCallback<GetShardRoleReply>(){

            public void onSuccess(GetShardRoleReply reply) {
                if (reply == null) {
                    returnFuture.set((Object)ClusterAdminRpcService.newFailedRpcResultBuilder("No Shard role present. Please retry..").build());
                    return;
                }
                LOG.info("Successfully received role:{} for shard {}", (Object)reply.getRole(), (Object)shardName);
                GetShardRoleOutputBuilder builder = new GetShardRoleOutputBuilder();
                if (reply.getRole() != null) {
                    builder.setRole(reply.getRole());
                }
                returnFuture.set(ClusterAdminRpcService.newSuccessfulResult(builder.build()));
            }

            public void onFailure(Throwable failure) {
                returnFuture.set((Object)ClusterAdminRpcService.newFailedRpcResultBuilder("Failed to get shard role.", failure).build());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return returnFuture;
    }

    public ListenableFuture<RpcResult<GetPrefixShardRoleOutput>> getPrefixShardRole(GetPrefixShardRoleInput input) {
        InstanceIdentifier identifier = input.getShardPrefix();
        if (identifier == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid shard identifier must be specified");
        }
        DataStoreType dataStoreType = input.getDataStoreType();
        if (dataStoreType == null) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid DataStoreType must be specified");
        }
        LOG.info("Getting prefix shard role for shard: {}, datastore type {}", (Object)identifier, (Object)dataStoreType);
        YangInstanceIdentifier prefix = this.serializer.toYangInstanceIdentifier(identifier);
        final String shardName = ClusterUtils.getCleanShardName((YangInstanceIdentifier)prefix);
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManager(dataStoreType, new GetShardRole(shardName));
        Futures.addCallback(future, (FutureCallback)new FutureCallback<GetShardRoleReply>(){

            public void onSuccess(GetShardRoleReply reply) {
                if (reply == null) {
                    returnFuture.set((Object)ClusterAdminRpcService.newFailedRpcResultBuilder("No Shard role present. Please retry..").build());
                    return;
                }
                LOG.info("Successfully received role:{} for shard {}", (Object)reply.getRole(), (Object)shardName);
                GetPrefixShardRoleOutputBuilder builder = new GetPrefixShardRoleOutputBuilder();
                if (reply.getRole() != null) {
                    builder.setRole(reply.getRole());
                }
                returnFuture.set(ClusterAdminRpcService.newSuccessfulResult(builder.build()));
            }

            public void onFailure(Throwable failure) {
                returnFuture.set((Object)ClusterAdminRpcService.newFailedRpcResultBuilder("Failed to get shard role.", failure).build());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return returnFuture;
    }

    public ListenableFuture<RpcResult<BackupDatastoreOutput>> backupDatastore(final BackupDatastoreInput input) {
        LOG.debug("backupDatastore: {}", (Object)input);
        if (Strings.isNullOrEmpty((String)input.getFilePath())) {
            return ClusterAdminRpcService.newFailedRpcResultFuture("A valid file path must be specified");
        }
        Uint32 timeout = input.getTimeout();
        Timeout opTimeout = timeout != null ? Timeout.apply((long)timeout.longValue(), (TimeUnit)TimeUnit.SECONDS) : SHARD_MGR_TIMEOUT;
        final SettableFuture returnFuture = SettableFuture.create();
        ListenableFuture future = this.sendMessageToShardManagers(new GetSnapshot(opTimeout));
        Futures.addCallback(future, (FutureCallback)new FutureCallback<List<DatastoreSnapshot>>(){

            public void onSuccess(List<DatastoreSnapshot> snapshots) {
                ClusterAdminRpcService.saveSnapshotsToFile(new DatastoreSnapshotList(snapshots), input.getFilePath(), (SettableFuture<RpcResult<BackupDatastoreOutput>>)returnFuture);
            }

            public void onFailure(Throwable failure) {
                ClusterAdminRpcService.onDatastoreBackupFailure(input.getFilePath(), returnFuture, failure);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return returnFuture;
    }

    public ListenableFuture<RpcResult<GetKnownClientsForAllShardsOutput>> getKnownClientsForAllShards(GetKnownClientsForAllShardsInput input) {
        ImmutableMap<ShardIdentifier, ListenableFuture<GetKnownClientsReply>> allShardReplies = this.getAllShardLeadersClients();
        return Futures.whenAllComplete((Iterable)allShardReplies.values()).call(() -> ClusterAdminRpcService.processReplies(allShardReplies), MoreExecutors.directExecutor());
    }

    private static RpcResult<GetKnownClientsForAllShardsOutput> processReplies(ImmutableMap<ShardIdentifier, ListenableFuture<GetKnownClientsReply>> allShardReplies) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)allShardReplies.size());
        for (Map.Entry entry : allShardReplies.entrySet()) {
            GetKnownClientsReply reply;
            ListenableFuture future = (ListenableFuture)entry.getValue();
            ShardResultBuilder builder = new ShardResultBuilder().setDataStoreType(((ShardIdentifier)entry.getKey()).getDataStoreType()).setShardName(((ShardIdentifier)entry.getKey()).getShardName());
            try {
                reply = (GetKnownClientsReply)Futures.getDone((Future)future);
            }
            catch (ExecutionException e) {
                LOG.debug("Shard {} failed to answer", entry.getKey(), (Object)e);
                ShardResult sr = builder.setSucceeded(Boolean.FALSE).setErrorMessage(e.getCause().getMessage()).build();
                result.put(sr.key(), sr);
                continue;
            }
            ShardResult sr = builder.setSucceeded(Boolean.TRUE).addAugmentation((Augmentation)new ShardResult1Builder().setKnownClients(reply.getClients().stream().map(client -> new KnownClientsBuilder().setMember(client.getFrontendId().getMemberName().toYang()).setType(client.getFrontendId().getClientType().toYang()).setGeneration(client.getYangGeneration()).build()).collect(Collectors.toMap(KnownClients::key, Function.identity()))).build()).build();
            result.put(sr.key(), sr);
        }
        return RpcResultBuilder.success((Object)new GetKnownClientsForAllShardsOutputBuilder().setShardResult((Map)result).build()).build();
    }

    private static ChangeShardMembersVotingStatus toChangeShardMembersVotingStatus(String shardName, List<MemberVotingState> memberVotingStatus) {
        HashMap<String, Boolean> serverVotingStatusMap = new HashMap<String, Boolean>();
        for (MemberVotingState memberStatus : memberVotingStatus) {
            serverVotingStatusMap.put(memberStatus.getMemberName(), memberStatus.isVoting());
        }
        return new ChangeShardMembersVotingStatus(shardName, serverVotingStatusMap);
    }

    private static <T> SettableFuture<RpcResult<T>> waitForShardResults(final List<Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder>> shardResultData, final Function<Map<ShardResultKey, ShardResult>, T> resultDataSupplier, final String failureLogMsgPrefix) {
        final SettableFuture returnFuture = SettableFuture.create();
        final HashMap shardResults = new HashMap();
        for (final Map.Entry<ListenableFuture<Status.Success>, ShardResultBuilder> entry : shardResultData) {
            Futures.addCallback(entry.getKey(), (FutureCallback)new FutureCallback<Status.Success>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(Status.Success result) {
                    Map map = shardResults;
                    synchronized (map) {
                        ShardResultBuilder builder = (ShardResultBuilder)entry.getValue();
                        LOG.debug("onSuccess for shard {}, type {}", (Object)builder.getShardName(), (Object)builder.getDataStoreType());
                        ShardResult sr = builder.setSucceeded(Boolean.TRUE).build();
                        shardResults.put(sr.key(), sr);
                        this.checkIfComplete();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Throwable failure) {
                    Map map = shardResults;
                    synchronized (map) {
                        ShardResultBuilder builder = (ShardResultBuilder)entry.getValue();
                        LOG.warn("{} for shard {}, type {}", new Object[]{failureLogMsgPrefix, builder.getShardName(), builder.getDataStoreType(), failure});
                        ShardResult sr = builder.setSucceeded(Boolean.FALSE).setErrorMessage(Throwables.getRootCause((Throwable)failure).getMessage()).build();
                        shardResults.put(sr.key(), sr);
                        this.checkIfComplete();
                    }
                }

                void checkIfComplete() {
                    LOG.debug("checkIfComplete: expected {}, actual {}", (Object)shardResultData.size(), (Object)shardResults.size());
                    if (shardResults.size() == shardResultData.size()) {
                        returnFuture.set(ClusterAdminRpcService.newSuccessfulResult(resultDataSupplier.apply(shardResults)));
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        return returnFuture;
    }

    private <T> void sendMessageToManagerForConfiguredShards(DataStoreType dataStoreType, List<Map.Entry<ListenableFuture<T>, ShardResultBuilder>> shardResultData, Function<String, Object> messageSupplier) {
        ActorUtils actorUtils = dataStoreType == DataStoreType.Config ? this.configDataStore.getActorUtils() : this.operDataStore.getActorUtils();
        Set allShardNames = actorUtils.getConfiguration().getAllShardNames();
        LOG.debug("Sending message to all shards {} for data store {}", (Object)allShardNames, (Object)actorUtils.getDataStoreName());
        for (String shardName : allShardNames) {
            ListenableFuture<T> future = this.ask(actorUtils.getShardManager(), messageSupplier.apply(shardName), SHARD_MGR_TIMEOUT);
            shardResultData.add(new AbstractMap.SimpleEntry<ListenableFuture<T>, ShardResultBuilder>(future, new ShardResultBuilder().setShardName(shardName).setDataStoreType(dataStoreType)));
        }
    }

    private <T> ListenableFuture<List<T>> sendMessageToShardManagers(Object message) {
        Timeout timeout = SHARD_MGR_TIMEOUT;
        ListenableFuture<T> configFuture = this.ask(this.configDataStore.getActorUtils().getShardManager(), message, timeout);
        ListenableFuture<T> operFuture = this.ask(this.operDataStore.getActorUtils().getShardManager(), message, timeout);
        return Futures.allAsList((ListenableFuture[])new ListenableFuture[]{configFuture, operFuture});
    }

    private <T> ListenableFuture<T> sendMessageToShardManager(DataStoreType dataStoreType, Object message) {
        ActorRef shardManager = dataStoreType == DataStoreType.Config ? this.configDataStore.getActorUtils().getShardManager() : this.operDataStore.getActorUtils().getShardManager();
        return this.ask(shardManager, message, SHARD_MGR_TIMEOUT);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private static void saveSnapshotsToFile(DatastoreSnapshotList snapshots, String fileName, SettableFuture<RpcResult<BackupDatastoreOutput>> returnFuture) {
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            SerializationUtils.serialize((Serializable)snapshots, (OutputStream)fos);
            returnFuture.set(ClusterAdminRpcService.newSuccessfulResult(new BackupDatastoreOutputBuilder().build()));
            LOG.info("Successfully backed up datastore to file {}", (Object)fileName);
        }
        catch (IOException | RuntimeException e) {
            ClusterAdminRpcService.onDatastoreBackupFailure(fileName, returnFuture, e);
        }
    }

    private static <T> void onDatastoreBackupFailure(String fileName, SettableFuture<RpcResult<T>> returnFuture, Throwable failure) {
        ClusterAdminRpcService.onMessageFailure(String.format("Failed to back up datastore to file %s", fileName), returnFuture, failure);
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    private static <T> void onMessageFailure(String msg, SettableFuture<RpcResult<T>> returnFuture, Throwable failure) {
        LOG.error("{}", (Object)msg, (Object)failure);
        returnFuture.set((Object)ClusterAdminRpcService.newFailedRpcResultBuilder(String.format("%s: %s", msg, failure.getMessage())).build());
    }

    private <T> ListenableFuture<T> ask(ActorRef actor, Object message, Timeout timeout) {
        final SettableFuture returnFuture = SettableFuture.create();
        scala.concurrent.Future askFuture = Patterns.ask((ActorRef)actor, (Object)message, (Timeout)timeout);
        askFuture.onComplete((Function1)new OnComplete<T>(){

            public void onComplete(Throwable failure, T resp) {
                if (failure != null) {
                    returnFuture.setException(failure);
                } else {
                    returnFuture.set(resp);
                }
            }
        }, this.configDataStore.getActorUtils().getClientDispatcher());
        return returnFuture;
    }

    private ImmutableMap<ShardIdentifier, ListenableFuture<GetKnownClientsReply>> getAllShardLeadersClients() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ClusterAdminRpcService.addAllShardsClients((ImmutableMap.Builder<ShardIdentifier, ListenableFuture<GetKnownClientsReply>>)builder, DataStoreType.Config, this.configDataStore.getActorUtils());
        ClusterAdminRpcService.addAllShardsClients((ImmutableMap.Builder<ShardIdentifier, ListenableFuture<GetKnownClientsReply>>)builder, DataStoreType.Operational, this.operDataStore.getActorUtils());
        return builder.build();
    }

    private static void addAllShardsClients(ImmutableMap.Builder<ShardIdentifier, ListenableFuture<GetKnownClientsReply>> builder, DataStoreType type, ActorUtils utils) {
        for (String shardName : utils.getConfiguration().getAllShardNames()) {
            final SettableFuture future = SettableFuture.create();
            builder.put((Object)new ShardIdentifier(type, shardName), (Object)future);
            utils.findPrimaryShardAsync(shardName).flatMap(info -> Patterns.ask((ActorSelection)info.getPrimaryShardActor(), (Object)GetKnownClients.INSTANCE, (Timeout)SHARD_MGR_TIMEOUT), utils.getClientDispatcher()).onComplete((Function1)new OnComplete<Object>(){

                public void onComplete(Throwable failure, Object success) {
                    if (failure == null) {
                        future.set((Object)((GetKnownClientsReply)success));
                    } else {
                        future.setException(failure);
                    }
                }
            }, utils.getClientDispatcher());
        }
    }

    private static <T> ListenableFuture<RpcResult<T>> newFailedRpcResultFuture(String message) {
        return ClusterAdminRpcService.newFailedRpcResultBuilder(message).buildFuture();
    }

    private static <T> RpcResultBuilder<T> newFailedRpcResultBuilder(String message) {
        return ClusterAdminRpcService.newFailedRpcResultBuilder(message, null);
    }

    private static <T> RpcResultBuilder<T> newFailedRpcResultBuilder(String message, Throwable cause) {
        return RpcResultBuilder.failed().withError(RpcError.ErrorType.RPC, message, cause);
    }

    private static <T> RpcResult<T> newSuccessfulResult(T data) {
        return RpcResultBuilder.success(data).build();
    }
}

