/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.IncludedModuleContext;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.AbstractResumedStatement;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SourceSpecificContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;

public class RootStatementContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends AbstractResumedStatement<A, D, E> {
    public static final YangVersion DEFAULT_VERSION = YangVersion.VERSION_1;
    private final @NonNull SourceSpecificContext sourceContext;
    private final A argument;
    private YangVersion rootVersion;
    private Set<SourceIdentifier> requiredSources = ImmutableSet.of();
    private SourceIdentifier rootIdentifier;
    private List<RootStatementContext<?, ?, ?>> includedContexts = ImmutableList.of();

    RootStatementContext(SourceSpecificContext sourceContext, StatementDefinitionContext<A, D, E> def, StatementSourceReference ref, String rawArgument) {
        super(def, ref, rawArgument);
        this.sourceContext = Objects.requireNonNull(sourceContext);
        this.argument = def.parseArgumentValue((StmtContext<A, D, E>)this, this.rawStatementArgument());
    }

    RootStatementContext(SourceSpecificContext sourceContext, StatementDefinitionContext<A, D, E> def, StatementSourceReference ref, String rawArgument, YangVersion version, SourceIdentifier identifier) {
        this(sourceContext, def, ref, rawArgument);
        this.setRootVersion(version);
        this.setRootIdentifier(identifier);
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentContext() {
        return null;
    }

    @Override
    public NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage() {
        return this.sourceContext;
    }

    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.ROOT_STATEMENT_LOCAL;
    }

    @Override
    public RootStatementContext<?, ?, ?> getRoot() {
        return this;
    }

    SourceSpecificContext getSourceContext() {
        return this.sourceContext;
    }

    public A getStatementArgument() {
        return this.argument;
    }

    @Deprecated
    public Optional<SchemaPath> getSchemaPath() {
        return Optional.of(SchemaPath.ROOT);
    }

    public boolean isConfiguration() {
        return true;
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> V putToLocalStorage(Class<N> type, K key, V value) {
        if (IncludedModuleContext.class.isAssignableFrom(type)) {
            if (this.includedContexts.isEmpty()) {
                this.includedContexts = new ArrayList(1);
            }
            Verify.verify((boolean)(value instanceof RootStatementContext));
            this.includedContexts.add((RootStatementContext)value);
        }
        return (V)super.putToLocalStorage((Class)type, (Object)key, (Object)value);
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> V getFromLocalStorage(Class<N> type, K key) {
        return this.getFromLocalStorage(type, key, new HashSet());
    }

    private <K, V, N extends IdentifierNamespace<K, V>> @Nullable V getFromLocalStorage(Class<N> type, K key, HashSet<RootStatementContext<?, ?, ?>> alreadyChecked) {
        Object potentialLocal = super.getFromLocalStorage((Class)type, (Object)key);
        if (potentialLocal != null) {
            return (V)potentialLocal;
        }
        alreadyChecked.add(this);
        for (RootStatementContext<?, ?, ?> includedSource : this.includedContexts) {
            V potential;
            if (alreadyChecked.contains(includedSource) || (potential = includedSource.getFromLocalStorage(type, key, alreadyChecked)) == null) continue;
            return potential;
        }
        return null;
    }

    @Override
    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromLocalStorage(Class<N> type) {
        return this.getAllFromLocalStorage(type, new HashSet());
    }

    private <K, V, N extends IdentifierNamespace<K, V>> @Nullable Map<K, V> getAllFromLocalStorage(Class<N> type, HashSet<RootStatementContext<?, ?, ?>> alreadyChecked) {
        Map potentialLocal = super.getAllFromLocalStorage((Class)type);
        if (potentialLocal != null) {
            return potentialLocal;
        }
        alreadyChecked.add(this);
        for (RootStatementContext<?, ?, ?> includedSource : this.includedContexts) {
            Map<K, V> potential;
            if (alreadyChecked.contains(includedSource) || (potential = includedSource.getAllFromLocalStorage(type, alreadyChecked)) == null) continue;
            return potential;
        }
        return null;
    }

    Collection<SourceIdentifier> getRequiredSources() {
        return ImmutableSet.copyOf(this.requiredSources);
    }

    SourceIdentifier getRootIdentifier() {
        return this.rootIdentifier;
    }

    @Override
    protected boolean isIgnoringIfFeatures() {
        return false;
    }

    @Override
    protected boolean isIgnoringConfig() {
        return false;
    }

    @Override
    protected boolean isParentSupportedByFeatures() {
        return true;
    }

    void setRootIdentifierImpl(SourceIdentifier identifier) {
        this.rootIdentifier = Objects.requireNonNull(identifier);
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull NamespaceBehaviour.Registry getBehaviourRegistryImpl() {
        return this.sourceContext;
    }

    boolean isEnabledSemanticVersioningImpl() {
        return this.sourceContext.globalContext().isEnabledSemanticVersioning();
    }

    @NonNull YangVersion getRootVersionImpl() {
        return this.rootVersion == null ? DEFAULT_VERSION : this.rootVersion;
    }

    void setRootVersionImpl(YangVersion version) {
        Preconditions.checkArgument((boolean)this.sourceContext.globalContext().getSupportedVersions().contains(version), (String)"Unsupported yang version %s in %s", (Object)version, (Object)this.getStatementSourceReference());
        Preconditions.checkState((this.rootVersion == null ? 1 : 0) != 0, (String)"Version of root %s has been already set to %s", this.argument, (Object)this.rootVersion);
        this.rootVersion = Objects.requireNonNull(version);
    }

    void addMutableStmtToSealImpl(MutableStatement mutableStatement) {
        this.sourceContext.globalContext().addMutableStmtToSeal(mutableStatement);
    }

    void addRequiredSourceImpl(SourceIdentifier dependency) {
        Preconditions.checkState((this.sourceContext.getInProgressPhase() == ModelProcessingPhase.SOURCE_PRE_LINKAGE ? 1 : 0) != 0, (Object)"Add required module is allowed only in ModelProcessingPhase.SOURCE_PRE_LINKAGE phase");
        if (this.requiredSources.isEmpty()) {
            this.requiredSources = new HashSet<SourceIdentifier>();
        }
        this.requiredSources.add(dependency);
    }

    @Override
    StatementContextBase<A, D, E> reparent(StatementContextBase<?, ?, ?> newParent) {
        throw new UnsupportedOperationException("Root statement cannot be reparented to" + newParent);
    }
}

