/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class YangIdentifier
implements ScalarTypeObject<String>,
Serializable {
    private static final long serialVersionUID = 7734916821492871556L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of((Object)"^(?:.|..|[^xX].*|.[^mM].*|..[^lL].*)$", (Object)"^(?:[a-zA-Z_][a-zA-Z0-9\\-_.]*)$");
    private static final Pattern[] patterns = CodeHelpers.compilePatterns(PATTERN_CONSTANTS);
    private static final String[] regexes = new String[]{".|..|[^xX].*|.[^mM].*|..[^lL].*", "[a-zA-Z_][a-zA-Z0-9\\-_.]*"};
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.length();
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..2147483647]]", (Object)value);
    }

    @ConstructorParameters(value={"value"})
    @ConstructorProperties(value={"value"})
    public YangIdentifier(String _value) {
        if (_value != null) {
            YangIdentifier.check_valueLength(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        CodeHelpers.checkPattern((String)_value, (Pattern[])patterns, (String[])regexes);
        this._value = _value;
    }

    public YangIdentifier(YangIdentifier source) {
        this._value = source._value;
    }

    public static YangIdentifier getDefaultInstance(String defaultValue) {
        return new YangIdentifier(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof YangIdentifier)) {
            return false;
        }
        YangIdentifier other = (YangIdentifier)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(YangIdentifier.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

