/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.PoisonPill;
import akka.dispatch.OnComplete;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerActor;
import org.opendaylight.controller.cluster.datastore.exceptions.LocalShardNotFoundException;
import org.opendaylight.controller.cluster.datastore.messages.CloseDataTreeNotificationListenerRegistration;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeNotificationListenerReply;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.concurrent.Future;

final class DataTreeChangeListenerProxy<T extends DOMDataTreeChangeListener>
extends AbstractListenerRegistration<T> {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeChangeListenerProxy.class);
    private final ActorRef dataChangeListenerActor;
    private final ActorUtils actorUtils;
    private final YangInstanceIdentifier registeredPath;
    private @GuardedBy(value={"this"}) ActorSelection listenerRegistrationActor;

    DataTreeChangeListenerProxy(ActorUtils actorUtils, T listener, YangInstanceIdentifier registeredPath) {
        super(listener);
        this.actorUtils = Objects.requireNonNull(actorUtils);
        this.registeredPath = Objects.requireNonNull(registeredPath);
        this.dataChangeListenerActor = actorUtils.getActorSystem().actorOf(DataTreeChangeListenerActor.props((DOMDataTreeChangeListener)this.getInstance(), registeredPath).withDispatcher(actorUtils.getNotificationDispatcherPath()));
        LOG.debug("{}: Created actor {} for DTCL {}", new Object[]{actorUtils.getDatastoreContext().getLogicalStoreType(), this.dataChangeListenerActor, listener});
    }

    protected synchronized void removeRegistration() {
        if (this.listenerRegistrationActor != null) {
            this.listenerRegistrationActor.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), ActorRef.noSender());
            this.listenerRegistrationActor = null;
        }
        this.dataChangeListenerActor.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
    }

    void init(final String shardName) {
        Future<ActorRef> findFuture = this.actorUtils.findLocalShardAsync(shardName);
        findFuture.onComplete((Function1)new OnComplete<ActorRef>(){

            public void onComplete(Throwable failure, ActorRef shard) {
                if (failure instanceof LocalShardNotFoundException) {
                    LOG.debug("{}: No local shard found for {} - DataTreeChangeListener {} at path {} cannot be registered", new Object[]{DataTreeChangeListenerProxy.this.logContext(), shardName, DataTreeChangeListenerProxy.this.getInstance(), DataTreeChangeListenerProxy.this.registeredPath});
                } else if (failure != null) {
                    LOG.error("{}: Failed to find local shard {} - DataTreeChangeListener {} at path {} cannot be registered", new Object[]{DataTreeChangeListenerProxy.this.logContext(), shardName, DataTreeChangeListenerProxy.this.getInstance(), DataTreeChangeListenerProxy.this.registeredPath, failure});
                } else {
                    DataTreeChangeListenerProxy.this.doRegistration(shard);
                }
            }
        }, this.actorUtils.getClientDispatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private void setListenerRegistrationActor(ActorSelection actor) {
        if (actor == null) {
            LOG.debug("{}: Ignoring null actor on {}", (Object)this.logContext(), (Object)this);
            return;
        }
        DataTreeChangeListenerProxy dataTreeChangeListenerProxy = this;
        synchronized (dataTreeChangeListenerProxy) {
            if (!this.isClosed()) {
                this.listenerRegistrationActor = actor;
                return;
            }
        }
        actor.tell((Object)CloseDataTreeNotificationListenerRegistration.getInstance(), null);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private void doRegistration(ActorRef shard) {
        Future<Object> future = this.actorUtils.executeOperationAsync(shard, (Object)new RegisterDataTreeChangeListener(this.registeredPath, this.dataChangeListenerActor, this.getInstance() instanceof ClusteredDOMDataTreeChangeListener), this.actorUtils.getDatastoreContext().getShardInitializationTimeout());
        future.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object result) {
                if (failure != null) {
                    LOG.error("{}: Failed to register DataTreeChangeListener {} at path {}", new Object[]{DataTreeChangeListenerProxy.this.logContext(), DataTreeChangeListenerProxy.this.getInstance(), DataTreeChangeListenerProxy.this.registeredPath, failure});
                } else {
                    RegisterDataTreeNotificationListenerReply reply = (RegisterDataTreeNotificationListenerReply)result;
                    DataTreeChangeListenerProxy.this.setListenerRegistrationActor(DataTreeChangeListenerProxy.this.actorUtils.actorSelection(reply.getListenerRegistrationPath()));
                }
            }
        }, this.actorUtils.getClientDispatcher());
    }

    @VisibleForTesting
    synchronized ActorSelection getListenerRegistrationActor() {
        return this.listenerRegistrationActor;
    }

    @VisibleForTesting
    ActorRef getDataChangeListenerActor() {
        return this.dataChangeListenerActor;
    }

    private String logContext() {
        return this.actorUtils.getDatastoreContext().getLogicalStoreType().toString();
    }
}

