/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.Map;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.DistributedDataStoreInterface;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistration;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.store.DOMStore;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(factory="org.opendaylight.controller.cluster.datastore.OSGiDOMStore", service={DOMStore.class, DistributedDataStoreInterface.class})
public final class OSGiDOMStore
implements DistributedDataStoreInterface,
DOMStoreTreeChangePublisher,
DOMDataTreeCommitCohortRegistry {
    static final String FACTORY_NAME = "org.opendaylight.controller.cluster.datastore.OSGiDOMStore";
    static final String DATASTORE_INST_PROP = ".datastore.instance";
    static final String DATASTORE_TYPE_PROP = ".datastore.type";
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDOMStore.class);
    private LogicalDatastoreType datastoreType;
    private AbstractDataStore datastore;

    @Override
    public ActorUtils getActorUtils() {
        return this.datastore.getActorUtils();
    }

    @Override
    public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerShardConfigListener(YangInstanceIdentifier internalPath, DOMDataTreeChangeListener delegate) {
        return this.datastore.registerShardConfigListener(internalPath, delegate);
    }

    @Override
    public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerProxyListener(YangInstanceIdentifier shardLookup, YangInstanceIdentifier insideShard, DOMDataTreeChangeListener delegate) {
        return this.datastore.registerProxyListener(shardLookup, insideShard, delegate);
    }

    public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerTreeChangeListener(YangInstanceIdentifier treeId, L listener) {
        return this.datastore.registerTreeChangeListener(treeId, listener);
    }

    public <T extends DOMDataTreeCommitCohort> DOMDataTreeCommitCohortRegistration<T> registerCommitCohort(DOMDataTreeIdentifier path, T cohort) {
        return this.datastore.registerCommitCohort(path, cohort);
    }

    public DOMStoreTransactionChain createTransactionChain() {
        return this.datastore.createTransactionChain();
    }

    public DOMStoreReadTransaction newReadOnlyTransaction() {
        return this.datastore.newReadOnlyTransaction();
    }

    public DOMStoreWriteTransaction newWriteOnlyTransaction() {
        return this.datastore.newWriteOnlyTransaction();
    }

    public DOMStoreReadWriteTransaction newReadWriteTransaction() {
        return this.datastore.newReadWriteTransaction();
    }

    @Activate
    void activate(Map<String, ?> properties) {
        this.datastoreType = (LogicalDatastoreType)Verify.verifyNotNull(properties.get(DATASTORE_TYPE_PROP));
        this.datastore = (AbstractDataStore)Verify.verifyNotNull(properties.get(DATASTORE_INST_PROP));
        LOG.info("Datastore service type {} activated", (Object)this.datastoreType);
    }

    @Deactivate
    void deactivate() {
        this.datastore = null;
        LOG.info("Datastore service type {} deactivated", (Object)this.datastoreType);
    }
}

