/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.AbstractActor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Cancellable;
import akka.actor.ExtendedActorSystem;
import akka.actor.Props;
import akka.actor.Status;
import akka.serialization.JavaSerializer;
import akka.serialization.Serialization;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.ConnectClientRequest;
import org.opendaylight.controller.cluster.access.commands.ConnectClientSuccess;
import org.opendaylight.controller.cluster.access.commands.LocalHistoryRequest;
import org.opendaylight.controller.cluster.access.commands.NotLeaderException;
import org.opendaylight.controller.cluster.access.commands.OutOfSequenceEnvelopeException;
import org.opendaylight.controller.cluster.access.commands.TransactionRequest;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.RequestEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestSuccess;
import org.opendaylight.controller.cluster.access.concepts.RetiredGenerationException;
import org.opendaylight.controller.cluster.access.concepts.RuntimeRequestException;
import org.opendaylight.controller.cluster.access.concepts.SliceableMessage;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.access.concepts.UnsupportedRequestException;
import org.opendaylight.controller.cluster.common.actor.CommonConfig;
import org.opendaylight.controller.cluster.common.actor.Dispatchers;
import org.opendaylight.controller.cluster.common.actor.MessageTracker;
import org.opendaylight.controller.cluster.common.actor.MeteringBehavior;
import org.opendaylight.controller.cluster.datastore.DataTreeChangeListenerSupport;
import org.opendaylight.controller.cluster.datastore.DataTreeCohortActorRegistry;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.FrontendMetadata;
import org.opendaylight.controller.cluster.datastore.LeaderFrontendState;
import org.opendaylight.controller.cluster.datastore.ShardCommitCoordinator;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeChangeListenerPublisherActorProxy;
import org.opendaylight.controller.cluster.datastore.ShardRecoveryCoordinator;
import org.opendaylight.controller.cluster.datastore.ShardSnapshotCohort;
import org.opendaylight.controller.cluster.datastore.ShardTransactionActorFactory;
import org.opendaylight.controller.cluster.datastore.ShardTransactionMessageRetrySupport;
import org.opendaylight.controller.cluster.datastore.SimpleShardDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.ShardDataTreeListenerInfoMXBeanImpl;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.ShardMBeanFactory;
import org.opendaylight.controller.cluster.datastore.jmx.mbeans.shard.ShardStats;
import org.opendaylight.controller.cluster.datastore.messages.AbortTransaction;
import org.opendaylight.controller.cluster.datastore.messages.ActorInitialized;
import org.opendaylight.controller.cluster.datastore.messages.BatchedModifications;
import org.opendaylight.controller.cluster.datastore.messages.CanCommitTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CloseTransactionChain;
import org.opendaylight.controller.cluster.datastore.messages.CommitTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CreateTransaction;
import org.opendaylight.controller.cluster.datastore.messages.CreateTransactionReply;
import org.opendaylight.controller.cluster.datastore.messages.ForwardedReadyTransaction;
import org.opendaylight.controller.cluster.datastore.messages.GetKnownClients;
import org.opendaylight.controller.cluster.datastore.messages.GetKnownClientsReply;
import org.opendaylight.controller.cluster.datastore.messages.GetShardDataTree;
import org.opendaylight.controller.cluster.datastore.messages.MakeLeaderLocal;
import org.opendaylight.controller.cluster.datastore.messages.OnDemandShardState;
import org.opendaylight.controller.cluster.datastore.messages.PeerAddressResolved;
import org.opendaylight.controller.cluster.datastore.messages.ReadyLocalTransaction;
import org.opendaylight.controller.cluster.datastore.messages.RegisterDataTreeChangeListener;
import org.opendaylight.controller.cluster.datastore.messages.ShardLeaderStateChanged;
import org.opendaylight.controller.cluster.datastore.messages.UpdateSchemaContext;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.DisableTrackingPayload;
import org.opendaylight.controller.cluster.messaging.MessageAssembler;
import org.opendaylight.controller.cluster.messaging.MessageSlicer;
import org.opendaylight.controller.cluster.messaging.SliceOptions;
import org.opendaylight.controller.cluster.notifications.LeaderStateChanged;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListener;
import org.opendaylight.controller.cluster.notifications.RoleChangeNotifier;
import org.opendaylight.controller.cluster.raft.LeadershipTransferFailedException;
import org.opendaylight.controller.cluster.raft.RaftActor;
import org.opendaylight.controller.cluster.raft.RaftActorRecoveryCohort;
import org.opendaylight.controller.cluster.raft.RaftActorSnapshotCohort;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.base.messages.FollowerInitialSyncUpStatus;
import org.opendaylight.controller.cluster.raft.client.messages.OnDemandRaftState;
import org.opendaylight.controller.cluster.raft.messages.AppendEntriesReply;
import org.opendaylight.controller.cluster.raft.messages.RequestLeadership;
import org.opendaylight.controller.cluster.raft.messages.ServerRemoved;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.Payload;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ReadOnlyDataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TreeType;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;
import scala.PartialFunction;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class Shard
extends RaftActor {
    @VisibleForTesting
    static final Object TX_COMMIT_TIMEOUT_CHECK_MESSAGE = new Object(){

        public String toString() {
            return "txCommitTimeoutCheck";
        }
    };
    @VisibleForTesting
    static final Object GET_SHARD_MBEAN_MESSAGE = new Object(){

        public String toString() {
            return "getShardMBeanMessage";
        }
    };
    static final Object RESUME_NEXT_PENDING_TRANSACTION = new Object(){

        public String toString() {
            return "resumeNextPendingTransaction";
        }
    };
    public static final String DEFAULT_NAME = "default";
    private static final Collection<ABIVersion> SUPPORTED_ABIVERSIONS;
    public static final String NON_PERSISTENT_JOURNAL_ID = "akka.persistence.non-persistent.journal";
    private static final int CLIENT_MAX_MESSAGES = 1000;
    private final ShardDataTree store;
    private final String name;
    private final String shardName;
    private final ShardStats shardMBean;
    private final ShardDataTreeListenerInfoMXBeanImpl listenerInfoMXBean;
    private DatastoreContext datastoreContext;
    private final ShardCommitCoordinator commitCoordinator;
    private long transactionCommitTimeout;
    private Cancellable txCommitTimeoutCheckSchedule;
    private final Optional<ActorRef> roleChangeNotifier;
    private final MessageTracker appendEntriesReplyTracker;
    private final ShardTransactionActorFactory transactionActorFactory;
    private final ShardSnapshotCohort snapshotCohort;
    private final DataTreeChangeListenerSupport treeChangeSupport = new DataTreeChangeListenerSupport(this);
    private DatastoreSnapshot.ShardSnapshot restoreFromSnapshot;
    private final ShardTransactionMessageRetrySupport messageRetrySupport;
    @VisibleForTesting
    final FrontendMetadata frontendMetadata;
    private Map<FrontendIdentifier, LeaderFrontendState> knownFrontends = ImmutableMap.of();
    private boolean paused;
    private final MessageSlicer responseMessageSlicer;
    private final Dispatchers dispatchers;
    private final MessageAssembler requestMessageAssembler;

    protected Shard(AbstractBuilder<?, ?> builder) {
        super(builder.getId().toString(), builder.getPeerAddresses(), Optional.of(builder.getDatastoreContext().getShardRaftConfig()), (short)11);
        this.name = builder.getId().toString();
        this.shardName = builder.getId().getShardName();
        this.datastoreContext = builder.getDatastoreContext();
        this.restoreFromSnapshot = builder.getRestoreFromSnapshot();
        this.frontendMetadata = new FrontendMetadata(this.name);
        this.setPersistence(this.datastoreContext.isPersistent());
        this.LOG.info("Shard created : {}, persistent : {}", (Object)this.name, (Object)this.datastoreContext.isPersistent());
        ShardDataTreeChangeListenerPublisherActorProxy treeChangeListenerPublisher = new ShardDataTreeChangeListenerPublisherActorProxy((ActorContext)this.getContext(), this.name + "-DTCL-publisher", this.name);
        this.store = builder.getDataTree() != null ? new ShardDataTree(this, builder.getSchemaContext(), builder.getDataTree(), treeChangeListenerPublisher, this.name, this.frontendMetadata) : new ShardDataTree(this, builder.getSchemaContext(), builder.getTreeType(), builder.getDatastoreContext().getStoreRoot(), treeChangeListenerPublisher, this.name, this.frontendMetadata);
        this.shardMBean = ShardMBeanFactory.getShardStatsMBean(this.name, this.datastoreContext.getDataStoreMXBeanType(), this);
        if (this.isMetricsCaptureEnabled()) {
            this.getContext().become((PartialFunction)new MeteringBehavior((AbstractActor)this));
        }
        this.commitCoordinator = new ShardCommitCoordinator(this.store, this.LOG, this.name);
        this.setTransactionCommitTimeout();
        this.roleChangeNotifier = this.createRoleChangeNotifier(this.name);
        this.appendEntriesReplyTracker = new MessageTracker(AppendEntriesReply.class, this.getRaftActorContext().getConfigParams().getIsolatedCheckIntervalInMillis());
        this.dispatchers = new Dispatchers(this.context().system().dispatchers());
        this.transactionActorFactory = new ShardTransactionActorFactory(this.store, this.datastoreContext, this.dispatchers.getDispatcherPath(Dispatchers.DispatcherType.Transaction), this.self(), this.getContext(), this.shardMBean, builder.getId().getShardName());
        this.snapshotCohort = ShardSnapshotCohort.create((ActorContext)this.getContext(), builder.getId().getMemberName(), this.store, this.LOG, this.name, this.datastoreContext);
        this.messageRetrySupport = new ShardTransactionMessageRetrySupport(this);
        this.responseMessageSlicer = MessageSlicer.builder().logContext(this.name).messageSliceSize(this.datastoreContext.getMaximumMessageSliceSize()).fileBackedStreamFactory(this.getRaftActorContext().getFileBackedOutputStreamFactory()).expireStateAfterInactivity(2L, TimeUnit.MINUTES).build();
        this.requestMessageAssembler = MessageAssembler.builder().logContext(this.name).fileBackedStreamFactory(this.getRaftActorContext().getFileBackedOutputStreamFactory()).assembledMessageCallback((message, sender) -> this.self().tell(message, sender)).expireStateAfterInactivity(this.datastoreContext.getRequestTimeout(), TimeUnit.NANOSECONDS).build();
        this.listenerInfoMXBean = new ShardDataTreeListenerInfoMXBeanImpl(this.name, this.datastoreContext.getDataStoreMXBeanType(), this.self());
        this.listenerInfoMXBean.register();
    }

    private void setTransactionCommitTimeout() {
        this.transactionCommitTimeout = TimeUnit.MILLISECONDS.convert(this.datastoreContext.getShardTransactionCommitTimeoutInSeconds(), TimeUnit.SECONDS) / 2L;
    }

    private Optional<ActorRef> createRoleChangeNotifier(String shardId) {
        ActorRef shardRoleChangeNotifier = this.getContext().actorOf(RoleChangeNotifier.getProps((String)shardId), shardId + "-notifier");
        return Optional.of(shardRoleChangeNotifier);
    }

    public void postStop() throws Exception {
        this.LOG.info("Stopping Shard {}", (Object)this.persistenceId());
        super.postStop();
        this.messageRetrySupport.close();
        if (this.txCommitTimeoutCheckSchedule != null) {
            this.txCommitTimeoutCheckSchedule.cancel();
        }
        this.commitCoordinator.abortPendingTransactions("Transaction aborted due to shutdown.", this);
        this.shardMBean.unregisterMBean();
        this.listenerInfoMXBean.unregister();
    }

    protected void handleRecover(Object message) {
        this.LOG.debug("{}: onReceiveRecover: Received message {} from {}", new Object[]{this.persistenceId(), message.getClass(), this.getSender()});
        super.handleRecover(message);
        if (this.LOG.isTraceEnabled()) {
            this.appendEntriesReplyTracker.begin();
        }
    }

    protected void handleNonRaftCommand(Object message) {
        try (MessageTracker.Context context = this.appendEntriesReplyTracker.received(message);){
            Optional maybeError = context.error();
            if (maybeError.isPresent()) {
                this.LOG.trace("{} : AppendEntriesReply failed to arrive at the expected interval {}", (Object)this.persistenceId(), maybeError.get());
            }
            this.store.resetTransactionBatch();
            if (message instanceof RequestEnvelope) {
                this.handleRequestEnvelope((RequestEnvelope)message);
            } else if (MessageAssembler.isHandledMessage((Object)message)) {
                this.handleRequestAssemblerMessage(message);
            } else if (message instanceof ConnectClientRequest) {
                this.handleConnectClient((ConnectClientRequest)message);
            } else if (CreateTransaction.isSerializedType(message)) {
                this.handleCreateTransaction(message);
            } else if (message instanceof BatchedModifications) {
                this.handleBatchedModifications((BatchedModifications)message);
            } else if (message instanceof ForwardedReadyTransaction) {
                this.handleForwardedReadyTransaction((ForwardedReadyTransaction)message);
            } else if (message instanceof ReadyLocalTransaction) {
                this.handleReadyLocalTransaction((ReadyLocalTransaction)message);
            } else if (CanCommitTransaction.isSerializedType(message)) {
                this.handleCanCommitTransaction(CanCommitTransaction.fromSerializable(message));
            } else if (CommitTransaction.isSerializedType(message)) {
                this.handleCommitTransaction(CommitTransaction.fromSerializable(message));
            } else if (AbortTransaction.isSerializedType(message)) {
                this.handleAbortTransaction(AbortTransaction.fromSerializable(message));
            } else if (CloseTransactionChain.isSerializedType(message)) {
                this.closeTransactionChain(CloseTransactionChain.fromSerializable(message));
            } else if (message instanceof RegisterDataTreeChangeListener) {
                this.treeChangeSupport.onMessage((RegisterDataTreeChangeListener)message, this.isLeader(), this.hasLeader());
            } else if (message instanceof UpdateSchemaContext) {
                this.updateSchemaContext((UpdateSchemaContext)((Object)message));
            } else if (message instanceof PeerAddressResolved) {
                PeerAddressResolved resolved = (PeerAddressResolved)message;
                this.setPeerAddress(resolved.getPeerId(), resolved.getPeerAddress());
            } else if (TX_COMMIT_TIMEOUT_CHECK_MESSAGE.equals(message)) {
                this.commitTimeoutCheck();
            } else if (message instanceof DatastoreContext) {
                this.onDatastoreContext((DatastoreContext)message);
            } else if (message instanceof RegisterRoleChangeListener) {
                this.roleChangeNotifier.get().forward(message, this.context());
            } else if (message instanceof FollowerInitialSyncUpStatus) {
                this.shardMBean.setFollowerInitialSyncStatus(((FollowerInitialSyncUpStatus)message).isInitialSyncDone());
                this.context().parent().tell(message, this.self());
            } else if (GET_SHARD_MBEAN_MESSAGE.equals(message)) {
                this.sender().tell((Object)this.getShardMBean(), this.self());
            } else if (message instanceof GetShardDataTree) {
                this.sender().tell((Object)this.store.getDataTree(), this.self());
            } else if (message instanceof ServerRemoved) {
                this.context().parent().forward(message, this.context());
            } else if (ShardTransactionMessageRetrySupport.TIMER_MESSAGE_CLASS.isInstance(message)) {
                this.messageRetrySupport.onTimerMessage(message);
            } else if (message instanceof DataTreeCohortActorRegistry.CohortRegistryCommand) {
                this.store.processCohortRegistryCommand(this.getSender(), (DataTreeCohortActorRegistry.CohortRegistryCommand)message);
            } else if (message instanceof MakeLeaderLocal) {
                this.onMakeLeaderLocal();
            } else if (RESUME_NEXT_PENDING_TRANSACTION.equals(message)) {
                this.store.resumeNextPendingTransaction();
            } else if (GetKnownClients.INSTANCE.equals(message)) {
                this.handleGetKnownClients();
            } else if (!this.responseMessageSlicer.handleMessage(message)) {
                super.handleNonRaftCommand(message);
            }
        }
    }

    private void handleRequestAssemblerMessage(Object message) {
        this.dispatchers.getDispatcher(Dispatchers.DispatcherType.Serialization).execute(() -> {
            JavaSerializer.currentSystem().value_$eq((Object)((ExtendedActorSystem)this.context().system()));
            this.requestMessageAssembler.handleMessage(message, this.self());
        });
    }

    private void handleRequestEnvelope(RequestEnvelope envelope) {
        long now = this.ticker().read();
        try {
            RequestSuccess<?, ?> success = this.handleRequest(envelope, now);
            if (success != null) {
                long executionTimeNanos = this.ticker().read() - now;
                if (success instanceof SliceableMessage) {
                    this.dispatchers.getDispatcher(Dispatchers.DispatcherType.Serialization).execute(() -> this.responseMessageSlicer.slice(SliceOptions.builder().identifier((Identifier)success.getTarget()).message((Serializable)envelope.newSuccessEnvelope(success, executionTimeNanos)).sendTo(((Request)envelope.getMessage()).getReplyTo()).replyTo(this.self()).onFailureCallback(t -> this.LOG.warn("Error slicing response {}", (Object)success, t)).build()));
                } else {
                    envelope.sendSuccess(success, executionTimeNanos);
                }
            }
        }
        catch (RequestException e) {
            this.LOG.debug("{}: request {} failed", new Object[]{this.persistenceId(), envelope, e});
            envelope.sendFailure(e, this.ticker().read() - now);
        }
        catch (Exception e) {
            this.LOG.debug("{}: request {} caused failure", new Object[]{this.persistenceId(), envelope, e});
            envelope.sendFailure((RequestException)new RuntimeRequestException("Request failed to process", (Throwable)e), this.ticker().read() - now);
        }
    }

    private void commitTimeoutCheck() {
        this.store.checkForExpiredTransactions(this.transactionCommitTimeout, this::updateAccess);
        this.commitCoordinator.checkForExpiredTransactions(this.transactionCommitTimeout, this);
        this.requestMessageAssembler.checkExpiredAssembledMessageState();
    }

    private OptionalLong updateAccess(SimpleShardDataTreeCohort cohort) {
        FrontendIdentifier frontend = cohort.getIdentifier().getHistoryId().getClientId().getFrontendId();
        LeaderFrontendState state = this.knownFrontends.get(frontend);
        if (state == null) {
            return OptionalLong.empty();
        }
        if (this.isIsolatedLeader()) {
            return OptionalLong.of(state.getLastSeenTicks());
        }
        return OptionalLong.of(state.getLastConnectTicks());
    }

    private void disableTracking(DisableTrackingPayload payload) {
        ClientIdentifier clientId = (ClientIdentifier)payload.getIdentifier();
        this.LOG.debug("{}: disabling tracking of {}", (Object)this.persistenceId(), (Object)clientId);
        this.frontendMetadata.disableTracking(clientId);
        if (this.isLeader()) {
            FrontendIdentifier frontendId = clientId.getFrontendId();
            LeaderFrontendState frontend = this.knownFrontends.get(frontendId);
            if (frontend != null) {
                if (clientId.equals((Object)frontend.getIdentifier())) {
                    if (!(frontend instanceof LeaderFrontendState.Disabled)) {
                        Verify.verify((boolean)this.knownFrontends.replace(frontendId, frontend, new LeaderFrontendState.Disabled(this.persistenceId(), clientId, this.store)));
                        this.LOG.debug("{}: leader state for {} disabled", (Object)this.persistenceId(), (Object)clientId);
                    } else {
                        this.LOG.debug("{}: leader state {} is already disabled", (Object)this.persistenceId(), (Object)frontend);
                    }
                } else {
                    this.LOG.debug("{}: leader state {} does not match {}", new Object[]{this.persistenceId(), frontend, clientId});
                }
            } else {
                this.LOG.debug("{}: leader state for {} not found", (Object)this.persistenceId(), (Object)clientId);
                this.knownFrontends.put(frontendId, new LeaderFrontendState.Disabled(this.persistenceId(), clientId, this.getDataStore()));
            }
        }
    }

    private void onMakeLeaderLocal() {
        this.LOG.debug("{}: onMakeLeaderLocal received", (Object)this.persistenceId());
        if (this.isLeader()) {
            this.getSender().tell((Object)new Status.Success(null), this.getSelf());
            return;
        }
        ActorSelection leader = this.getLeader();
        if (leader == null) {
            this.getSender().tell((Object)new Status.Failure((Throwable)new LeadershipTransferFailedException("We cannot initiate leadership transfer to local node. Currently there is no leader for " + this.persistenceId())), this.getSelf());
            return;
        }
        leader.tell((Object)new RequestLeadership(this.getId(), this.getSender()), this.getSelf());
    }

    private @Nullable LeaderFrontendState findFrontend(ClientIdentifier clientId) throws RequestException {
        LeaderFrontendState existing = this.knownFrontends.get(clientId.getFrontendId());
        if (existing != null) {
            int cmp = Long.compareUnsigned(existing.getIdentifier().getGeneration(), clientId.getGeneration());
            if (cmp == 0) {
                existing.touch();
                return existing;
            }
            if (cmp > 0) {
                this.LOG.debug("{}: rejecting request from outdated client {}", (Object)this.persistenceId(), (Object)clientId);
                throw new RetiredGenerationException(clientId.getGeneration(), existing.getIdentifier().getGeneration());
            }
            this.LOG.info("{}: retiring state {}, outdated by request from client {}", new Object[]{this.persistenceId(), existing, clientId});
            existing.retire();
            this.knownFrontends.remove(clientId.getFrontendId());
        } else {
            this.LOG.debug("{}: client {} is not yet known", (Object)this.persistenceId(), (Object)clientId);
        }
        return null;
    }

    private LeaderFrontendState getFrontend(ClientIdentifier clientId) throws RequestException {
        LeaderFrontendState ret = this.findFrontend(clientId);
        if (ret != null) {
            return ret;
        }
        throw new OutOfSequenceEnvelopeException(0L);
    }

    private static @NonNull ABIVersion selectVersion(ConnectClientRequest message) {
        Range clientRange = Range.closed((Comparable)message.getMinVersion(), (Comparable)message.getMaxVersion());
        for (ABIVersion v : SUPPORTED_ABIVERSIONS) {
            if (!clientRange.contains((Comparable)v)) continue;
            return v;
        }
        throw new IllegalArgumentException(String.format("No common version between backend versions %s and client versions %s", SUPPORTED_ABIVERSIONS, clientRange));
    }

    private void handleConnectClient(ConnectClientRequest message) {
        try {
            LeaderFrontendState frontend;
            ClientIdentifier clientId = (ClientIdentifier)message.getTarget();
            LeaderFrontendState existing = this.findFrontend(clientId);
            if (existing != null) {
                existing.touch();
            }
            if (!this.isLeader() || !this.isLeaderActive()) {
                this.LOG.info("{}: not currently leader, rejecting request {}. isLeader: {}, isLeaderActive: {},isLeadershipTransferInProgress: {}.", new Object[]{this.persistenceId(), message, this.isLeader(), this.isLeaderActive(), this.isLeadershipTransferInProgress()});
                throw new NotLeaderException(this.getSelf());
            }
            ABIVersion selectedVersion = Shard.selectVersion(message);
            if (existing == null) {
                frontend = new LeaderFrontendState.Enabled(this.persistenceId(), clientId, this.store);
                this.knownFrontends.put(clientId.getFrontendId(), frontend);
                this.LOG.debug("{}: created state {} for client {}", new Object[]{this.persistenceId(), frontend, clientId});
            } else {
                frontend = existing;
            }
            frontend.reconnect();
            message.getReplyTo().tell((Object)new ConnectClientSuccess((ClientIdentifier)message.getTarget(), message.getSequence(), this.getSelf(), (List)ImmutableList.of(), (ReadOnlyDataTree)this.store.getDataTree(), 1000).toVersion(selectedVersion), ActorRef.noSender());
        }
        catch (RuntimeException | RequestException e) {
            message.getReplyTo().tell((Object)new Status.Failure(e), ActorRef.noSender());
        }
    }

    private @Nullable RequestSuccess<?, ?> handleRequest(RequestEnvelope envelope, long now) throws RequestException {
        if (!this.isLeader() || this.paused || !this.isLeaderActive()) {
            this.LOG.debug("{}: not currently active leader, rejecting request {}. isLeader: {}, isLeaderActive: {},isLeadershipTransferInProgress: {}, paused: {}", new Object[]{this.persistenceId(), envelope, this.isLeader(), this.isLeaderActive(), this.isLeadershipTransferInProgress(), this.paused});
            throw new NotLeaderException(this.getSelf());
        }
        Request request = (Request)envelope.getMessage();
        if (request instanceof TransactionRequest) {
            TransactionRequest txReq = (TransactionRequest)request;
            ClientIdentifier clientId = ((TransactionIdentifier)txReq.getTarget()).getHistoryId().getClientId();
            return this.getFrontend(clientId).handleTransactionRequest(txReq, envelope, now);
        }
        if (request instanceof LocalHistoryRequest) {
            LocalHistoryRequest lhReq = (LocalHistoryRequest)request;
            ClientIdentifier clientId = ((LocalHistoryIdentifier)lhReq.getTarget()).getClientId();
            return this.getFrontend(clientId).handleLocalHistoryRequest(lhReq, envelope, now);
        }
        this.LOG.warn("{}: rejecting unsupported request {}", (Object)this.persistenceId(), (Object)request);
        throw new UnsupportedRequestException(request);
    }

    private void handleGetKnownClients() {
        ImmutableSet clients = this.isLeader() ? (ImmutableSet)this.knownFrontends.values().stream().map(LeaderFrontendState::getIdentifier).collect(ImmutableSet.toImmutableSet()) : this.frontendMetadata.getClients();
        this.sender().tell((Object)new GetKnownClientsReply((ImmutableSet<ClientIdentifier>)clients), this.self());
    }

    private boolean hasLeader() {
        return this.getLeaderId() != null;
    }

    public int getPendingTxCommitQueueSize() {
        return this.store.getQueueSize();
    }

    public int getCohortCacheSize() {
        return this.commitCoordinator.getCohortCacheSize();
    }

    protected Optional<ActorRef> getRoleChangeNotifier() {
        return this.roleChangeNotifier;
    }

    String getShardName() {
        return this.shardName;
    }

    protected LeaderStateChanged newLeaderStateChanged(String memberId, String leaderId, short leaderPayloadVersion) {
        return this.isLeader() ? new ShardLeaderStateChanged(memberId, leaderId, (ReadOnlyDataTree)this.store.getDataTree(), leaderPayloadVersion) : new ShardLeaderStateChanged(memberId, leaderId, leaderPayloadVersion);
    }

    protected void onDatastoreContext(DatastoreContext context) {
        this.datastoreContext = (DatastoreContext)Verify.verifyNotNull((Object)context);
        this.setTransactionCommitTimeout();
        this.setPersistence(this.datastoreContext.isPersistent());
        this.updateConfigParams(this.datastoreContext.getShardRaftConfig());
    }

    void persistPayload(Identifier id, Payload payload, boolean batchHint) {
        boolean canSkipPayload;
        boolean bl = canSkipPayload = !this.hasFollowers() && !this.persistence().isRecoveryApplicable();
        if (canSkipPayload) {
            this.applyState(this.self(), id, payload);
        } else {
            this.persistData(this.self(), id, payload, batchHint);
        }
    }

    private void handleCommitTransaction(CommitTransaction commit) {
        TransactionIdentifier txId = commit.getTransactionId();
        if (this.isLeader()) {
            this.askProtocolEncountered(txId);
            this.commitCoordinator.handleCommit((Identifier)txId, this.getSender(), this);
        } else {
            ActorSelection leader = this.getLeader();
            if (leader == null) {
                this.messageRetrySupport.addMessageToRetry(commit, this.getSender(), "Could not commit transaction " + txId);
            } else {
                this.LOG.debug("{}: Forwarding CommitTransaction to leader {}", (Object)this.persistenceId(), (Object)leader);
                leader.forward((Object)commit, (ActorContext)this.getContext());
            }
        }
    }

    private void handleCanCommitTransaction(CanCommitTransaction canCommit) {
        TransactionIdentifier txId = canCommit.getTransactionId();
        this.LOG.debug("{}: Can committing transaction {}", (Object)this.persistenceId(), (Object)txId);
        if (this.isLeader()) {
            this.askProtocolEncountered(txId);
            this.commitCoordinator.handleCanCommit((Identifier)txId, this.getSender(), this);
        } else {
            ActorSelection leader = this.getLeader();
            if (leader == null) {
                this.messageRetrySupport.addMessageToRetry(canCommit, this.getSender(), "Could not canCommit transaction " + txId);
            } else {
                this.LOG.debug("{}: Forwarding CanCommitTransaction to leader {}", (Object)this.persistenceId(), (Object)leader);
                leader.forward((Object)canCommit, (ActorContext)this.getContext());
            }
        }
    }

    protected void handleBatchedModificationsLocal(BatchedModifications batched, ActorRef sender) {
        this.askProtocolEncountered(batched.getTransactionId());
        try {
            this.commitCoordinator.handleBatchedModifications(batched, sender, this);
        }
        catch (Exception e) {
            this.LOG.error("{}: Error handling BatchedModifications for Tx {}", new Object[]{this.persistenceId(), batched.getTransactionId(), e});
            sender.tell((Object)new Status.Failure((Throwable)e), this.getSelf());
        }
    }

    private void handleBatchedModifications(BatchedModifications batched) {
        boolean isLeaderActive = this.isLeaderActive();
        if (this.isLeader() && isLeaderActive) {
            this.handleBatchedModificationsLocal(batched, this.getSender());
        } else {
            ActorSelection leader = this.getLeader();
            if (!isLeaderActive || leader == null) {
                this.messageRetrySupport.addMessageToRetry(batched, this.getSender(), "Could not process BatchedModifications " + batched.getTransactionId());
            } else {
                Collection<BatchedModifications> newModifications = this.commitCoordinator.createForwardedBatchedModifications(batched, this.datastoreContext.getShardBatchedModificationCount());
                this.LOG.debug("{}: Forwarding {} BatchedModifications to leader {}", new Object[]{this.persistenceId(), newModifications.size(), leader});
                for (BatchedModifications bm : newModifications) {
                    leader.forward((Object)bm, (ActorContext)this.getContext());
                }
            }
        }
    }

    private boolean failIfIsolatedLeader(ActorRef sender) {
        if (this.isIsolatedLeader()) {
            sender.tell((Object)new Status.Failure((Throwable)new NoShardLeaderException(String.format("Shard %s was the leader but has lost contact with all of its followers. Either all other follower nodes are down or this node is isolated by a network partition.", this.persistenceId()))), this.getSelf());
            return true;
        }
        return false;
    }

    protected boolean isIsolatedLeader() {
        return this.getRaftState() == RaftState.IsolatedLeader;
    }

    private void handleReadyLocalTransaction(ReadyLocalTransaction message) {
        this.LOG.debug("{}: handleReadyLocalTransaction for {}", (Object)this.persistenceId(), (Object)message.getTransactionId());
        boolean isLeaderActive = this.isLeaderActive();
        if (this.isLeader() && isLeaderActive) {
            try {
                this.commitCoordinator.handleReadyLocalTransaction(message, this.getSender(), this);
            }
            catch (Exception e) {
                this.LOG.error("{}: Error handling ReadyLocalTransaction for Tx {}", new Object[]{this.persistenceId(), message.getTransactionId(), e});
                this.getSender().tell((Object)new Status.Failure((Throwable)e), this.getSelf());
            }
        } else {
            ActorSelection leader = this.getLeader();
            if (!isLeaderActive || leader == null) {
                this.messageRetrySupport.addMessageToRetry(message, this.getSender(), "Could not process ready local transaction " + message.getTransactionId());
            } else {
                this.LOG.debug("{}: Forwarding ReadyLocalTransaction to leader {}", (Object)this.persistenceId(), (Object)leader);
                message.setRemoteVersion(this.getCurrentBehavior().getLeaderPayloadVersion());
                leader.forward((Object)message, (ActorContext)this.getContext());
            }
        }
    }

    private void handleForwardedReadyTransaction(ForwardedReadyTransaction forwardedReady) {
        this.LOG.debug("{}: handleForwardedReadyTransaction for {}", (Object)this.persistenceId(), (Object)forwardedReady.getTransactionId());
        boolean isLeaderActive = this.isLeaderActive();
        if (this.isLeader() && isLeaderActive) {
            this.askProtocolEncountered(forwardedReady.getTransactionId());
            this.commitCoordinator.handleForwardedReadyTransaction(forwardedReady, this.getSender(), this);
        } else {
            ActorSelection leader = this.getLeader();
            if (!isLeaderActive || leader == null) {
                this.messageRetrySupport.addMessageToRetry(forwardedReady, this.getSender(), "Could not process forwarded ready transaction " + forwardedReady.getTransactionId());
            } else {
                this.LOG.debug("{}: Forwarding ForwardedReadyTransaction to leader {}", (Object)this.persistenceId(), (Object)leader);
                ReadyLocalTransaction readyLocal = new ReadyLocalTransaction(forwardedReady.getTransactionId(), (DataTreeModification)forwardedReady.getTransaction().getSnapshot(), forwardedReady.isDoImmediateCommit(), forwardedReady.getParticipatingShardNames());
                readyLocal.setRemoteVersion(this.getCurrentBehavior().getLeaderPayloadVersion());
                leader.forward((Object)readyLocal, (ActorContext)this.getContext());
            }
        }
    }

    private void handleAbortTransaction(AbortTransaction abort) {
        TransactionIdentifier transactionId = abort.getTransactionId();
        this.askProtocolEncountered(transactionId);
        this.doAbortTransaction((Identifier)transactionId, this.getSender());
    }

    void doAbortTransaction(Identifier transactionID, ActorRef sender) {
        this.commitCoordinator.handleAbort(transactionID, sender, this);
    }

    private void handleCreateTransaction(Object message) {
        if (this.isLeader()) {
            this.createTransaction(CreateTransaction.fromSerializable(message));
        } else if (this.getLeader() != null) {
            this.getLeader().forward(message, (ActorContext)this.getContext());
        } else {
            this.getSender().tell((Object)new Status.Failure((Throwable)new NoShardLeaderException("Could not create a shard transaction", this.persistenceId())), this.getSelf());
        }
    }

    private void closeTransactionChain(CloseTransactionChain closeTransactionChain) {
        if (this.isLeader()) {
            LocalHistoryIdentifier id = closeTransactionChain.getIdentifier();
            this.askProtocolEncountered(id.getClientId());
            this.store.closeTransactionChain(id);
        } else if (this.getLeader() != null) {
            this.getLeader().forward((Object)closeTransactionChain, (ActorContext)this.getContext());
        } else {
            this.LOG.warn("{}: Could not close transaction {}", (Object)this.persistenceId(), (Object)closeTransactionChain.getIdentifier());
        }
    }

    private void createTransaction(CreateTransaction createTransaction) {
        this.askProtocolEncountered(createTransaction.getTransactionId());
        try {
            if (TransactionType.fromInt(createTransaction.getTransactionType()) != TransactionType.READ_ONLY && this.failIfIsolatedLeader(this.getSender())) {
                return;
            }
            ActorRef transactionActor = this.createTransaction(createTransaction.getTransactionType(), createTransaction.getTransactionId());
            this.getSender().tell(new CreateTransactionReply(Serialization.serializedActorPath((ActorRef)transactionActor), createTransaction.getTransactionId(), createTransaction.getVersion()).toSerializable(), this.getSelf());
        }
        catch (Exception e) {
            this.getSender().tell((Object)new Status.Failure((Throwable)e), this.getSelf());
        }
    }

    private ActorRef createTransaction(int transactionType, TransactionIdentifier transactionId) {
        this.LOG.debug("{}: Creating transaction : {} ", (Object)this.persistenceId(), (Object)transactionId);
        return this.transactionActorFactory.newShardTransaction(TransactionType.fromInt(transactionType), transactionId);
    }

    private void askProtocolEncountered(TransactionIdentifier transactionId) {
        this.askProtocolEncountered(transactionId.getHistoryId().getClientId());
    }

    private void askProtocolEncountered(ClientIdentifier clientId) {
        FrontendIdentifier frontend = clientId.getFrontendId();
        LeaderFrontendState state = this.knownFrontends.get(frontend);
        if (!(state instanceof LeaderFrontendState.Disabled)) {
            this.LOG.debug("{}: encountered ask-based client {}, disabling transaction tracking", (Object)this.persistenceId(), (Object)clientId);
            if (this.knownFrontends.isEmpty()) {
                this.knownFrontends = new HashMap<FrontendIdentifier, LeaderFrontendState>();
            }
            this.knownFrontends.put(frontend, new LeaderFrontendState.Disabled(this.persistenceId(), clientId, this.getDataStore()));
            this.persistPayload((Identifier)clientId, (Payload)DisableTrackingPayload.create(clientId, this.datastoreContext.getInitialPayloadSerializedBufferCapacity()), false);
        }
    }

    private void updateSchemaContext(UpdateSchemaContext message) {
        this.updateSchemaContext(message.getEffectiveModelContext());
    }

    @VisibleForTesting
    void updateSchemaContext(@NonNull EffectiveModelContext schemaContext) {
        this.store.updateSchemaContext(schemaContext);
    }

    private boolean isMetricsCaptureEnabled() {
        CommonConfig config = new CommonConfig(this.getContext().system().settings().config());
        return config.isMetricCaptureEnabled();
    }

    @VisibleForTesting
    public RaftActorSnapshotCohort getRaftActorSnapshotCohort() {
        return this.snapshotCohort;
    }

    protected RaftActorRecoveryCohort getRaftActorRecoveryCohort() {
        if (this.restoreFromSnapshot == null) {
            return ShardRecoveryCoordinator.create(this.store, this.persistenceId(), this.LOG);
        }
        return ShardRecoveryCoordinator.forSnapshot(this.store, this.persistenceId(), this.LOG, this.restoreFromSnapshot.getSnapshot());
    }

    protected void onRecoveryComplete() {
        this.restoreFromSnapshot = null;
        this.getContext().parent().tell((Object)new ActorInitialized(), this.getSelf());
        if (this.txCommitTimeoutCheckSchedule == null) {
            FiniteDuration period = FiniteDuration.create((long)(this.transactionCommitTimeout / 3L), (TimeUnit)TimeUnit.MILLISECONDS);
            this.txCommitTimeoutCheckSchedule = this.getContext().system().scheduler().schedule(period, period, this.getSelf(), TX_COMMIT_TIMEOUT_CHECK_MESSAGE, (ExecutionContext)this.getContext().dispatcher(), ActorRef.noSender());
        }
    }

    protected void applyState(ActorRef clientActor, Identifier identifier, Object data) {
        if (data instanceof Payload) {
            if (data instanceof DisableTrackingPayload) {
                this.disableTracking((DisableTrackingPayload)data);
                return;
            }
            try {
                this.store.applyReplicatedPayload(identifier, (Payload)data);
            }
            catch (IOException | DataValidationFailedException e) {
                this.LOG.error("{}: Error applying replica {}", new Object[]{this.persistenceId(), identifier, e});
            }
        } else {
            this.LOG.error("{}: Unknown state for {} received {}", new Object[]{this.persistenceId(), identifier, data});
        }
    }

    protected void onStateChanged() {
        boolean isLeader = this.isLeader();
        boolean hasLeader = this.hasLeader();
        this.treeChangeSupport.onLeadershipChange(isLeader, hasLeader);
        if (!isLeader) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("{}: onStateChanged: Closing all transaction chains because shard {} is no longer the leader", (Object)this.persistenceId(), (Object)this.getId());
            }
            this.paused = false;
            this.store.purgeLeaderState();
        }
        if (hasLeader && !this.isIsolatedLeader()) {
            this.messageRetrySupport.retryMessages();
        }
    }

    protected void onLeaderChanged(String oldLeader, String newLeader) {
        this.shardMBean.incrementLeadershipChangeCount();
        this.paused = false;
        if (!this.isLeader()) {
            if (!this.knownFrontends.isEmpty()) {
                this.LOG.debug("{}: removing frontend state for {}", (Object)this.persistenceId(), this.knownFrontends.keySet());
                this.knownFrontends = ImmutableMap.of();
            }
            this.requestMessageAssembler.close();
            if (!this.hasLeader()) {
                return;
            }
            ActorSelection leader = this.getLeader();
            if (leader != null) {
                Collection<?> messagesToForward = this.convertPendingTransactionsToMessages();
                if (!messagesToForward.isEmpty()) {
                    this.LOG.debug("{}: Forwarding {} pending transaction messages to leader {}", new Object[]{this.persistenceId(), messagesToForward.size(), leader});
                    for (Object message : messagesToForward) {
                        this.LOG.debug("{}: Forwarding pending transaction message {}", (Object)this.persistenceId(), message);
                        leader.tell(message, this.self());
                    }
                }
            } else {
                this.commitCoordinator.abortPendingTransactions("The transacton was aborted due to inflight leadership change and the leader address isn't available.", this);
            }
        } else {
            this.knownFrontends = (Map)Verify.verifyNotNull(this.frontendMetadata.toLeaderState(this));
            this.LOG.debug("{}: became leader with frontend state for {}", (Object)this.persistenceId(), this.knownFrontends.keySet());
        }
        if (!this.isIsolatedLeader()) {
            this.messageRetrySupport.retryMessages();
        }
    }

    public Collection<?> convertPendingTransactionsToMessages() {
        return this.commitCoordinator.convertPendingTransactionsToMessages(this.datastoreContext.getShardBatchedModificationCount());
    }

    protected void pauseLeader(Runnable operation) {
        this.LOG.debug("{}: In pauseLeader, operation: {}", (Object)this.persistenceId(), (Object)operation);
        this.paused = true;
        if (this.datastoreContext.isUseTellBasedProtocol()) {
            this.knownFrontends.values().forEach(LeaderFrontendState::retire);
            this.knownFrontends = ImmutableMap.of();
        }
        this.store.setRunOnPendingTransactionsComplete(operation);
    }

    protected void unpauseLeader() {
        this.LOG.debug("{}: In unpauseLeader", (Object)this.persistenceId());
        this.paused = false;
        this.store.setRunOnPendingTransactionsComplete(null);
        this.knownFrontends = (Map)Verify.verifyNotNull(this.frontendMetadata.toLeaderState(this));
    }

    protected OnDemandRaftState.AbstractBuilder<?, ?> newOnDemandRaftStateBuilder() {
        return OnDemandShardState.newBuilder().treeChangeListenerActors(this.treeChangeSupport.getListenerActors()).commitCohortActors(this.store.getCohortActors());
    }

    public String persistenceId() {
        return this.name;
    }

    public String journalPluginId() {
        if (this.datastoreContext != null && !this.datastoreContext.isPersistent()) {
            return NON_PERSISTENT_JOURNAL_ID;
        }
        return super.journalPluginId();
    }

    @VisibleForTesting
    ShardCommitCoordinator getCommitCoordinator() {
        return this.commitCoordinator;
    }

    public DatastoreContext getDatastoreContext() {
        return this.datastoreContext;
    }

    @VisibleForTesting
    public ShardDataTree getDataStore() {
        return this.store;
    }

    @VisibleForTesting
    ShardStats getShardMBean() {
        return this.shardMBean;
    }

    public static Builder builder() {
        return new Builder();
    }

    Ticker ticker() {
        return Ticker.systemTicker();
    }

    void scheduleNextPendingTransaction() {
        this.self().tell(RESUME_NEXT_PENDING_TRANSACTION, ActorRef.noSender());
    }

    static {
        ABIVersion[] values = ABIVersion.values();
        Object[] real = Arrays.copyOfRange(values, 1, values.length - 1);
        SUPPORTED_ABIVERSIONS = ImmutableList.copyOf((Object[])real).reverse();
    }

    public static class Builder
    extends AbstractBuilder<Builder, Shard> {
        Builder() {
            this((Class<? extends Shard>)Shard.class);
        }

        Builder(Class<? extends Shard> shardClass) {
            super(shardClass);
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T, S>, S extends Shard> {
        private final Class<? extends S> shardClass;
        private ShardIdentifier id;
        private Map<String, String> peerAddresses = Collections.emptyMap();
        private DatastoreContext datastoreContext;
        private EffectiveModelContextProvider schemaContextProvider;
        private DatastoreSnapshot.ShardSnapshot restoreFromSnapshot;
        private DataTree dataTree;
        private volatile boolean sealed;

        protected AbstractBuilder(Class<? extends S> shardClass) {
            this.shardClass = shardClass;
        }

        protected void checkSealed() {
            Preconditions.checkState((!this.sealed ? 1 : 0) != 0, (Object)"Builder isalready sealed - further modifications are not allowed");
        }

        private T self() {
            return (T)this;
        }

        public T id(ShardIdentifier newId) {
            this.checkSealed();
            this.id = newId;
            return this.self();
        }

        public T peerAddresses(Map<String, String> newPeerAddresses) {
            this.checkSealed();
            this.peerAddresses = newPeerAddresses;
            return this.self();
        }

        public T datastoreContext(DatastoreContext newDatastoreContext) {
            this.checkSealed();
            this.datastoreContext = newDatastoreContext;
            return this.self();
        }

        public T schemaContextProvider(EffectiveModelContextProvider newSchemaContextProvider) {
            this.checkSealed();
            this.schemaContextProvider = Objects.requireNonNull(newSchemaContextProvider);
            return this.self();
        }

        public T restoreFromSnapshot(DatastoreSnapshot.ShardSnapshot newRestoreFromSnapshot) {
            this.checkSealed();
            this.restoreFromSnapshot = newRestoreFromSnapshot;
            return this.self();
        }

        public T dataTree(DataTree newDataTree) {
            this.checkSealed();
            this.dataTree = newDataTree;
            return this.self();
        }

        public ShardIdentifier getId() {
            return this.id;
        }

        public Map<String, String> getPeerAddresses() {
            return this.peerAddresses;
        }

        public DatastoreContext getDatastoreContext() {
            return this.datastoreContext;
        }

        public EffectiveModelContext getSchemaContext() {
            return (EffectiveModelContext)Verify.verifyNotNull((Object)this.schemaContextProvider.getEffectiveModelContext());
        }

        public DatastoreSnapshot.ShardSnapshot getRestoreFromSnapshot() {
            return this.restoreFromSnapshot;
        }

        public DataTree getDataTree() {
            return this.dataTree;
        }

        public TreeType getTreeType() {
            switch (this.datastoreContext.getLogicalStoreType()) {
                case CONFIGURATION: {
                    return TreeType.CONFIGURATION;
                }
                case OPERATIONAL: {
                    return TreeType.OPERATIONAL;
                }
            }
            throw new IllegalStateException("Unhandled logical store type " + this.datastoreContext.getLogicalStoreType());
        }

        protected void verify() {
            Objects.requireNonNull(this.id, "id should not be null");
            Objects.requireNonNull(this.peerAddresses, "peerAddresses should not be null");
            Objects.requireNonNull(this.datastoreContext, "dataStoreContext should not be null");
            Objects.requireNonNull(this.schemaContextProvider, "schemaContextProvider should not be null");
        }

        public Props props() {
            this.sealed = true;
            this.verify();
            return Props.create(this.shardClass, (Object[])new Object[]{this});
        }
    }
}

