/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.modification;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opendaylight.controller.cluster.datastore.messages.VersionedExternalizableMessage;
import org.opendaylight.controller.cluster.datastore.modification.CompositeModification;
import org.opendaylight.controller.cluster.datastore.modification.DeleteModification;
import org.opendaylight.controller.cluster.datastore.modification.MergeModification;
import org.opendaylight.controller.cluster.datastore.modification.Modification;
import org.opendaylight.controller.cluster.datastore.modification.WriteModification;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.impl.schema.ReusableImmutableNormalizedNodeStreamWriter;

public class MutableCompositeModification
extends VersionedExternalizableMessage
implements CompositeModification {
    private static final long serialVersionUID = 1L;
    private final List<Modification> modifications = new ArrayList<Modification>();
    private List<Modification> immutableModifications = null;

    public MutableCompositeModification() {
        this(11);
    }

    public MutableCompositeModification(short version) {
        super(version);
    }

    @Override
    public void apply(DOMStoreWriteTransaction transaction) {
        for (Modification modification : this.modifications) {
            modification.apply(transaction);
        }
    }

    @Override
    public void apply(DataTreeModification transaction) {
        for (Modification modification : this.modifications) {
            modification.apply(transaction);
        }
    }

    @Override
    public byte getType() {
        return 1;
    }

    public void addModification(Modification modification) {
        this.modifications.add(Objects.requireNonNull(modification));
    }

    public void addModifications(Iterable<Modification> newMods) {
        for (Modification mod : newMods) {
            this.addModification(mod);
        }
    }

    @Override
    public List<Modification> getModifications() {
        if (this.immutableModifications == null) {
            this.immutableModifications = Collections.unmodifiableList(this.modifications);
        }
        return this.immutableModifications;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int size = in.readInt();
        if (size > 0) {
            NormalizedNodeDataInput input = NormalizedNodeDataInput.newDataInputWithoutValidation((DataInput)in);
            ReusableImmutableNormalizedNodeStreamWriter receiver = ReusableImmutableNormalizedNodeStreamWriter.create();
            block5: for (int i = 0; i < size; ++i) {
                byte type = in.readByte();
                switch (type) {
                    case 2: {
                        this.modifications.add(WriteModification.fromStream(input, this.getVersion(), (ReusableStreamReceiver)receiver));
                        continue block5;
                    }
                    case 3: {
                        this.modifications.add(MergeModification.fromStream(input, this.getVersion(), (ReusableStreamReceiver)receiver));
                        continue block5;
                    }
                    case 4: {
                        this.modifications.add(DeleteModification.fromStream(input, this.getVersion()));
                        continue block5;
                    }
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        int size = this.modifications.size();
        out.writeInt(size);
        if (size > 0) {
            try (NormalizedNodeDataOutput stream = this.getStreamVersion().newDataOutput((DataOutput)out);){
                for (Modification mod : this.modifications) {
                    out.writeByte(mod.getType());
                    mod.writeTo(stream);
                }
            }
        }
    }

    public static MutableCompositeModification fromSerializable(Object serializable) {
        Preconditions.checkArgument((boolean)(serializable instanceof MutableCompositeModification));
        return (MutableCompositeModification)serializable;
    }

    @Override
    public void writeTo(NormalizedNodeDataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

