/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.raft.protobuff.client.messages.IdentifiablePayload;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.Identifier;

public abstract class AbstractIdentifiablePayload<T extends Identifier>
extends IdentifiablePayload<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] serialized;
    private final T identifier;

    AbstractIdentifiablePayload(@NonNull T identifier, byte @NonNull [] serialized) {
        this.identifier = (Identifier)Objects.requireNonNull(identifier);
        this.serialized = Objects.requireNonNull(serialized);
    }

    public final T getIdentifier() {
        return this.identifier;
    }

    public final int size() {
        return this.serialized.length;
    }

    protected final Object writeReplace() {
        return Verify.verifyNotNull(this.externalizableProxy(this.serialized));
    }

    protected abstract @NonNull AbstractProxy<T> externalizableProxy(byte @NonNull [] var1);

    protected static abstract class AbstractProxy<T extends Identifier>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private byte[] serialized;
        private T identifier;

        public AbstractProxy() {
        }

        protected AbstractProxy(byte[] serialized) {
            this.serialized = Objects.requireNonNull(serialized);
        }

        @Override
        public final void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.serialized.length);
            out.write(this.serialized);
        }

        @Override
        public final void readExternal(ObjectInput in) throws IOException {
            int length = in.readInt();
            this.serialized = new byte[length];
            in.readFully(this.serialized);
            this.identifier = (Identifier)Verify.verifyNotNull(this.readIdentifier((DataInput)ByteStreams.newDataInput((byte[])this.serialized)));
        }

        protected final Object readResolve() {
            return Verify.verifyNotNull(this.createObject(this.identifier, this.serialized));
        }

        protected abstract @NonNull T readIdentifier(@NonNull DataInput var1) throws IOException;

        protected abstract @NonNull Identifiable<T> createObject(@NonNull T var1, byte @NonNull [] var2);
    }
}

