/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.collect.ImmutableList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.persisted.ShardManagerSnapshot;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;

public class DatastoreSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String type;
    private final ShardManagerSnapshot shardManagerSnapshot;
    private final List<ShardSnapshot> shardSnapshots;

    public DatastoreSnapshot(@NonNull String type, @Nullable ShardManagerSnapshot shardManagerSnapshot, @NonNull List<ShardSnapshot> shardSnapshots) {
        this.type = Objects.requireNonNull(type);
        this.shardManagerSnapshot = shardManagerSnapshot;
        this.shardSnapshots = ImmutableList.copyOf(shardSnapshots);
    }

    public @NonNull String getType() {
        return this.type;
    }

    public @Nullable ShardManagerSnapshot getShardManagerSnapshot() {
        return this.shardManagerSnapshot;
    }

    public @NonNull List<ShardSnapshot> getShardSnapshots() {
        return this.shardSnapshots;
    }

    private Object writeReplace() {
        return new Proxy(this);
    }

    public static class ShardSnapshot
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Snapshot snapshot;

        public ShardSnapshot(@NonNull String name, @NonNull Snapshot snapshot) {
            this.name = Objects.requireNonNull(name);
            this.snapshot = Objects.requireNonNull(snapshot);
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull Snapshot getSnapshot() {
            return this.snapshot;
        }

        private Object writeReplace() {
            return new Proxy(this);
        }

        private static final class Proxy
        implements Externalizable {
            private static final long serialVersionUID = 1L;
            private ShardSnapshot shardSnapshot;

            public Proxy() {
            }

            Proxy(ShardSnapshot shardSnapshot) {
                this.shardSnapshot = shardSnapshot;
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                out.writeObject(this.shardSnapshot.name);
                out.writeObject(this.shardSnapshot.snapshot);
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.shardSnapshot = new ShardSnapshot((String)in.readObject(), (Snapshot)in.readObject());
            }

            private Object readResolve() {
                return this.shardSnapshot;
            }
        }
    }

    private static final class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DatastoreSnapshot datastoreSnapshot;

        public Proxy() {
        }

        Proxy(DatastoreSnapshot datastoreSnapshot) {
            this.datastoreSnapshot = datastoreSnapshot;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.datastoreSnapshot.type);
            out.writeObject(this.datastoreSnapshot.shardManagerSnapshot);
            out.writeInt(this.datastoreSnapshot.shardSnapshots.size());
            for (ShardSnapshot shardSnapshot : this.datastoreSnapshot.shardSnapshots) {
                out.writeObject(shardSnapshot);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            String localType = (String)in.readObject();
            ShardManagerSnapshot localShardManagerSnapshot = (ShardManagerSnapshot)in.readObject();
            int size = in.readInt();
            ArrayList<ShardSnapshot> localShardSnapshots = new ArrayList<ShardSnapshot>(size);
            for (int i = 0; i < size; ++i) {
                localShardSnapshots.add((ShardSnapshot)in.readObject());
            }
            this.datastoreSnapshot = new DatastoreSnapshot(localType, localShardManagerSnapshot, localShardSnapshots);
        }

        private Object readResolve() {
            return this.datastoreSnapshot;
        }
    }
}

