/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.shardmanager;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.OneForOneStrategy;
import akka.actor.PoisonPill;
import akka.actor.Status;
import akka.actor.SupervisorStrategy;
import akka.cluster.ClusterEvent;
import akka.cluster.Member;
import akka.dispatch.Futures;
import akka.dispatch.OnComplete;
import akka.pattern.Patterns;
import akka.persistence.DeleteSnapshotsFailure;
import akka.persistence.DeleteSnapshotsSuccess;
import akka.persistence.RecoveryCompleted;
import akka.persistence.SaveSnapshotFailure;
import akka.persistence.SaveSnapshotSuccess;
import akka.persistence.SnapshotOffer;
import akka.persistence.SnapshotSelectionCriteria;
import akka.util.Timeout;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.SettableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedPersistentActorWithMetering;
import org.opendaylight.controller.cluster.common.actor.Dispatchers;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.Shard;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.config.ModuleShardConfiguration;
import org.opendaylight.controller.cluster.datastore.config.PrefixShardConfiguration;
import org.opendaylight.controller.cluster.datastore.exceptions.AlreadyExistsException;
import org.opendaylight.controller.cluster.datastore.exceptions.NoShardLeaderException;
import org.opendaylight.controller.cluster.datastore.exceptions.NotInitializedException;
import org.opendaylight.controller.cluster.datastore.exceptions.PrimaryNotFoundException;
import org.opendaylight.controller.cluster.datastore.identifiers.ShardIdentifier;
import org.opendaylight.controller.cluster.datastore.messages.ActorInitialized;
import org.opendaylight.controller.cluster.datastore.messages.AddPrefixShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.AddShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.ChangeShardMembersVotingStatus;
import org.opendaylight.controller.cluster.datastore.messages.CreateShard;
import org.opendaylight.controller.cluster.datastore.messages.FindLocalShard;
import org.opendaylight.controller.cluster.datastore.messages.FindPrimary;
import org.opendaylight.controller.cluster.datastore.messages.FlipShardMembersVotingStatus;
import org.opendaylight.controller.cluster.datastore.messages.GetShardRole;
import org.opendaylight.controller.cluster.datastore.messages.GetShardRoleReply;
import org.opendaylight.controller.cluster.datastore.messages.LocalPrimaryShardFound;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardFound;
import org.opendaylight.controller.cluster.datastore.messages.LocalShardNotFound;
import org.opendaylight.controller.cluster.datastore.messages.RemoteFindPrimary;
import org.opendaylight.controller.cluster.datastore.messages.RemotePrimaryShardFound;
import org.opendaylight.controller.cluster.datastore.messages.RemovePrefixShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.RemoveShardReplica;
import org.opendaylight.controller.cluster.datastore.messages.ShardLeaderStateChanged;
import org.opendaylight.controller.cluster.datastore.messages.UpdateSchemaContext;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.persisted.ShardManagerSnapshot;
import org.opendaylight.controller.cluster.datastore.shardmanager.AbstractShardManagerCreator;
import org.opendaylight.controller.cluster.datastore.shardmanager.GetLocalShardIds;
import org.opendaylight.controller.cluster.datastore.shardmanager.RegisterForShardAvailabilityChanges;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardInformation;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManagerGetSnapshotReplyActor;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManagerInfo;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardManagerInfoMBean;
import org.opendaylight.controller.cluster.datastore.shardmanager.ShardPeerAddressResolver;
import org.opendaylight.controller.cluster.datastore.shardmanager.SwitchShardBehavior;
import org.opendaylight.controller.cluster.datastore.utils.ClusterUtils;
import org.opendaylight.controller.cluster.datastore.utils.CompositeOnComplete;
import org.opendaylight.controller.cluster.datastore.utils.PrimaryShardInfoFutureCache;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListener;
import org.opendaylight.controller.cluster.notifications.RegisterRoleChangeListenerReply;
import org.opendaylight.controller.cluster.notifications.RoleChangeNotification;
import org.opendaylight.controller.cluster.raft.base.messages.FollowerInitialSyncUpStatus;
import org.opendaylight.controller.cluster.raft.base.messages.SwitchBehavior;
import org.opendaylight.controller.cluster.raft.client.messages.GetOnDemandRaftState;
import org.opendaylight.controller.cluster.raft.client.messages.GetSnapshot;
import org.opendaylight.controller.cluster.raft.client.messages.OnDemandRaftState;
import org.opendaylight.controller.cluster.raft.client.messages.Shutdown;
import org.opendaylight.controller.cluster.raft.messages.AddServer;
import org.opendaylight.controller.cluster.raft.messages.AddServerReply;
import org.opendaylight.controller.cluster.raft.messages.ChangeServersVotingStatus;
import org.opendaylight.controller.cluster.raft.messages.RemoveServer;
import org.opendaylight.controller.cluster.raft.messages.RemoveServerReply;
import org.opendaylight.controller.cluster.raft.messages.ServerChangeReply;
import org.opendaylight.controller.cluster.raft.messages.ServerChangeStatus;
import org.opendaylight.controller.cluster.raft.messages.ServerRemoved;
import org.opendaylight.controller.cluster.raft.policy.DisableElectionsRaftPolicy;
import org.opendaylight.controller.cluster.sharding.PrefixedShardConfigUpdateHandler;
import org.opendaylight.controller.cluster.sharding.messages.InitConfigListener;
import org.opendaylight.controller.cluster.sharding.messages.PrefixShardCreated;
import org.opendaylight.controller.cluster.sharding.messages.PrefixShardRemoved;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Long;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

class ShardManager
extends AbstractUntypedPersistentActorWithMetering {
    private static final Logger LOG = LoggerFactory.getLogger(ShardManager.class);
    @VisibleForTesting
    final Map<String, ShardInformation> localShards = new HashMap<String, ShardInformation>();
    private final String type;
    private final ClusterWrapper cluster;
    private final Configuration configuration;
    @VisibleForTesting
    final String shardDispatcherPath;
    private final ShardManagerInfo shardManagerMBean;
    private DatastoreContextFactory datastoreContextFactory;
    private final SettableFuture<Void> readinessFuture;
    private final PrimaryShardInfoFutureCache primaryShardInfoCache;
    @VisibleForTesting
    final ShardPeerAddressResolver peerAddressResolver;
    private EffectiveModelContext schemaContext;
    private DatastoreSnapshot restoreFromSnapshot;
    private ShardManagerSnapshot currentSnapshot;
    private final Set<String> shardReplicaOperationsInProgress = new HashSet<String>();
    private final Map<String, CompositeOnComplete<Boolean>> shardActorsStopping = new HashMap<String, CompositeOnComplete<Boolean>>();
    private final Set<Consumer<String>> shardAvailabilityCallbacks = new HashSet<Consumer<String>>();
    private final String persistenceId;
    private final AbstractDataStore dataStore;
    private PrefixedShardConfigUpdateHandler configUpdateHandler;

    ShardManager(AbstractShardManagerCreator<?> builder) {
        this.cluster = builder.getCluster();
        this.configuration = builder.getConfiguration();
        this.datastoreContextFactory = builder.getDatastoreContextFactory();
        this.type = this.datastoreContextFactory.getBaseDatastoreContext().getDataStoreName();
        this.shardDispatcherPath = new Dispatchers(this.context().system().dispatchers()).getDispatcherPath(Dispatchers.DispatcherType.Shard);
        this.readinessFuture = builder.getReadinessFuture();
        this.primaryShardInfoCache = builder.getPrimaryShardInfoCache();
        this.restoreFromSnapshot = builder.getRestoreFromSnapshot();
        String possiblePersistenceId = this.datastoreContextFactory.getBaseDatastoreContext().getShardManagerPersistenceId();
        this.persistenceId = possiblePersistenceId != null ? possiblePersistenceId : "shard-manager-" + this.type;
        this.peerAddressResolver = new ShardPeerAddressResolver(this.type, this.cluster.getCurrentMemberName());
        this.cluster.subscribeToMemberEvents(this.getSelf());
        this.shardManagerMBean = new ShardManagerInfo(this.getSelf(), this.cluster.getCurrentMemberName(), "shard-manager-" + this.type, this.datastoreContextFactory.getBaseDatastoreContext().getDataStoreMXBeanType());
        this.shardManagerMBean.registerMBean();
        this.dataStore = builder.getDistributedDataStore();
    }

    public void preStart() {
        LOG.info("Starting ShardManager {}", (Object)this.persistenceId);
    }

    public void postStop() {
        LOG.info("Stopping ShardManager {}", (Object)this.persistenceId());
        this.shardManagerMBean.unregisterMBean();
    }

    public void handleCommand(Object message) throws Exception {
        if (message instanceof FindPrimary) {
            this.findPrimary((FindPrimary)message);
        } else if (message instanceof FindLocalShard) {
            this.findLocalShard((FindLocalShard)message);
        } else if (message instanceof UpdateSchemaContext) {
            this.updateSchemaContext(message);
        } else if (message instanceof ActorInitialized) {
            this.onActorInitialized(message);
        } else if (message instanceof ClusterEvent.MemberUp) {
            this.memberUp((ClusterEvent.MemberUp)message);
        } else if (message instanceof ClusterEvent.MemberWeaklyUp) {
            this.memberWeaklyUp((ClusterEvent.MemberWeaklyUp)message);
        } else if (message instanceof ClusterEvent.MemberExited) {
            this.memberExited((ClusterEvent.MemberExited)message);
        } else if (message instanceof ClusterEvent.MemberRemoved) {
            this.memberRemoved((ClusterEvent.MemberRemoved)message);
        } else if (message instanceof ClusterEvent.UnreachableMember) {
            this.memberUnreachable((ClusterEvent.UnreachableMember)message);
        } else if (message instanceof ClusterEvent.ReachableMember) {
            this.memberReachable((ClusterEvent.ReachableMember)message);
        } else if (message instanceof DatastoreContextFactory) {
            this.onDatastoreContextFactory((DatastoreContextFactory)message);
        } else if (message instanceof RoleChangeNotification) {
            this.onRoleChangeNotification((RoleChangeNotification)message);
        } else if (message instanceof FollowerInitialSyncUpStatus) {
            this.onFollowerInitialSyncStatus((FollowerInitialSyncUpStatus)message);
        } else if (message instanceof ShardNotInitializedTimeout) {
            this.onShardNotInitializedTimeout((ShardNotInitializedTimeout)message);
        } else if (message instanceof ShardLeaderStateChanged) {
            this.onLeaderStateChanged((ShardLeaderStateChanged)((Object)message));
        } else if (message instanceof SwitchShardBehavior) {
            this.onSwitchShardBehavior((SwitchShardBehavior)message);
        } else if (message instanceof CreateShard) {
            this.onCreateShard((CreateShard)message);
        } else if (message instanceof AddShardReplica) {
            this.onAddShardReplica((AddShardReplica)message);
        } else if (message instanceof AddPrefixShardReplica) {
            this.onAddPrefixShardReplica((AddPrefixShardReplica)message);
        } else if (message instanceof PrefixShardCreated) {
            this.onPrefixShardCreated((PrefixShardCreated)message);
        } else if (message instanceof PrefixShardRemoved) {
            this.onPrefixShardRemoved((PrefixShardRemoved)message);
        } else if (message instanceof InitConfigListener) {
            this.onInitConfigListener();
        } else if (message instanceof ForwardedAddServerReply) {
            ForwardedAddServerReply msg = (ForwardedAddServerReply)message;
            this.onAddServerReply(msg.shardInfo, msg.addServerReply, this.getSender(), msg.leaderPath, msg.removeShardOnFailure);
        } else if (message instanceof ForwardedAddServerFailure) {
            ForwardedAddServerFailure msg = (ForwardedAddServerFailure)message;
            this.onAddServerFailure(msg.shardName, msg.failureMessage, msg.failure, this.getSender(), msg.removeShardOnFailure);
        } else if (message instanceof RemoveShardReplica) {
            this.onRemoveShardReplica((RemoveShardReplica)message);
        } else if (message instanceof RemovePrefixShardReplica) {
            this.onRemovePrefixShardReplica((RemovePrefixShardReplica)message);
        } else if (message instanceof WrappedShardResponse) {
            this.onWrappedShardResponse((WrappedShardResponse)message);
        } else if (message instanceof GetSnapshot) {
            this.onGetSnapshot((GetSnapshot)message);
        } else if (message instanceof ServerRemoved) {
            this.onShardReplicaRemoved((ServerRemoved)message);
        } else if (message instanceof ChangeShardMembersVotingStatus) {
            this.onChangeShardServersVotingStatus((ChangeShardMembersVotingStatus)message);
        } else if (message instanceof FlipShardMembersVotingStatus) {
            this.onFlipShardMembersVotingStatus((FlipShardMembersVotingStatus)message);
        } else if (message instanceof SaveSnapshotSuccess) {
            this.onSaveSnapshotSuccess((SaveSnapshotSuccess)message);
        } else if (message instanceof SaveSnapshotFailure) {
            LOG.error("{}: SaveSnapshotFailure received for saving snapshot of shards", (Object)this.persistenceId(), (Object)((SaveSnapshotFailure)message).cause());
        } else if (message instanceof Shutdown) {
            this.onShutDown();
        } else if (message instanceof GetLocalShardIds) {
            this.onGetLocalShardIds();
        } else if (message instanceof GetShardRole) {
            this.onGetShardRole((GetShardRole)message);
        } else if (message instanceof RunnableMessage) {
            ((RunnableMessage)message).run();
        } else if (message instanceof RegisterForShardAvailabilityChanges) {
            this.onRegisterForShardAvailabilityChanges((RegisterForShardAvailabilityChanges)message);
        } else if (message instanceof DeleteSnapshotsFailure) {
            LOG.warn("{}: Failed to delete prior snapshots", (Object)this.persistenceId(), (Object)((DeleteSnapshotsFailure)message).cause());
        } else if (message instanceof DeleteSnapshotsSuccess) {
            LOG.debug("{}: Successfully deleted prior snapshots", (Object)this.persistenceId());
        } else if (message instanceof RegisterRoleChangeListenerReply) {
            LOG.trace("{}: Received RegisterRoleChangeListenerReply", (Object)this.persistenceId());
        } else if (message instanceof ClusterEvent.MemberEvent) {
            LOG.trace("{}: Received other ClusterEvent.MemberEvent: {}", (Object)this.persistenceId(), message);
        } else {
            this.unknownMessage(message);
        }
    }

    private void onRegisterForShardAvailabilityChanges(RegisterForShardAvailabilityChanges message) {
        LOG.debug("{}: onRegisterForShardAvailabilityChanges: {}", (Object)this.persistenceId(), (Object)message);
        Consumer<String> callback = message.getCallback();
        this.shardAvailabilityCallbacks.add(callback);
        this.getSender().tell((Object)new Status.Success(() -> this.executeInSelf(() -> this.shardAvailabilityCallbacks.remove(callback))), this.self());
    }

    private void onGetShardRole(GetShardRole message) {
        LOG.debug("{}: onGetShardRole for shard: {}", (Object)this.persistenceId(), (Object)message.getName());
        String name = message.getName();
        ShardInformation shardInformation = this.localShards.get(name);
        if (shardInformation == null) {
            LOG.info("{}: no shard information for {} found", (Object)this.persistenceId(), (Object)name);
            this.getSender().tell((Object)new Status.Failure((Throwable)new IllegalArgumentException("Shard with name " + name + " not present.")), ActorRef.noSender());
            return;
        }
        this.getSender().tell((Object)new GetShardRoleReply(shardInformation.getRole()), ActorRef.noSender());
    }

    private void onInitConfigListener() {
        LOG.debug("{}: Initializing config listener on {}", (Object)this.persistenceId(), (Object)this.cluster.getCurrentMemberName());
        LogicalDatastoreType datastoreType = LogicalDatastoreType.valueOf((String)this.datastoreContextFactory.getBaseDatastoreContext().getLogicalStoreType().name());
        if (this.configUpdateHandler != null) {
            this.configUpdateHandler.close();
        }
        this.configUpdateHandler = new PrefixedShardConfigUpdateHandler(this.self(), this.cluster.getCurrentMemberName());
        this.configUpdateHandler.initListener(this.dataStore, datastoreType);
    }

    void onShutDown() {
        ArrayList<Future> stopFutures = new ArrayList<Future>(this.localShards.size());
        for (ShardInformation info : this.localShards.values()) {
            if (info.getActor() == null) continue;
            LOG.debug("{}: Issuing gracefulStop to shard {}", (Object)this.persistenceId(), (Object)info.getShardId());
            FiniteDuration duration = info.getDatastoreContext().getShardRaftConfig().getElectionTimeOutInterval().$times(2L);
            stopFutures.add(Patterns.gracefulStop((ActorRef)info.getActor(), (FiniteDuration)duration, (Object)Shutdown.INSTANCE));
        }
        LOG.info("Shutting down ShardManager {} - waiting on {} shards", (Object)this.persistenceId(), (Object)stopFutures.size());
        ExecutionContext dispatcher = new Dispatchers(this.context().system().dispatchers()).getDispatcher(Dispatchers.DispatcherType.Client);
        Future combinedFutures = Futures.sequence(stopFutures, (ExecutionContext)dispatcher);
        combinedFutures.onComplete((Function1)new OnComplete<Iterable<Boolean>>(){

            public void onComplete(Throwable failure, Iterable<Boolean> results) {
                LOG.debug("{}: All shards shutdown - sending PoisonPill to self", (Object)ShardManager.this.persistenceId());
                ShardManager.this.self().tell((Object)PoisonPill.getInstance(), ShardManager.this.self());
                if (failure != null) {
                    LOG.warn("{}: An error occurred attempting to shut down the shards", (Object)ShardManager.this.persistenceId(), (Object)failure);
                } else {
                    int nfailed = 0;
                    for (Boolean result : results) {
                        if (result.booleanValue()) continue;
                        ++nfailed;
                    }
                    if (nfailed > 0) {
                        LOG.warn("{}: {} shards did not shut down gracefully", (Object)ShardManager.this.persistenceId(), (Object)nfailed);
                    }
                }
            }
        }, dispatcher);
    }

    private void onWrappedShardResponse(WrappedShardResponse message) {
        if (message.getResponse() instanceof RemoveServerReply) {
            this.onRemoveServerReply(this.getSender(), message.getShardId(), (RemoveServerReply)message.getResponse(), message.getLeaderPath());
        }
    }

    private void onRemoveServerReply(ActorRef originalSender, ShardIdentifier shardId, RemoveServerReply replyMsg, String leaderPath) {
        this.shardReplicaOperationsInProgress.remove(shardId.getShardName());
        LOG.debug("{}: Received {} for shard {}", new Object[]{this.persistenceId(), replyMsg, shardId.getShardName()});
        if (replyMsg.getStatus() == ServerChangeStatus.OK) {
            LOG.debug("{}: Leader shard successfully removed the replica shard {}", (Object)this.persistenceId(), (Object)shardId.getShardName());
            originalSender.tell((Object)new Status.Success(null), this.getSelf());
        } else {
            LOG.warn("{}: Leader failed to remove shard replica {} with status {}", new Object[]{this.persistenceId(), shardId, replyMsg.getStatus()});
            Exception failure = ShardManager.getServerChangeException(RemoveServer.class, replyMsg.getStatus(), leaderPath, shardId);
            originalSender.tell((Object)new Status.Failure((Throwable)failure), this.getSelf());
        }
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private void removePrefixShardReplica(RemovePrefixShardReplica contextMessage, final String shardName, final String primaryPath, final ActorRef sender) {
        if (this.isShardReplicaOperationInProgress(shardName, sender)) {
            return;
        }
        this.shardReplicaOperationsInProgress.add(shardName);
        final ShardIdentifier shardId = this.getShardIdentifier(contextMessage.getMemberName(), shardName);
        DatastoreContext datastoreContext = this.newShardDatastoreContextBuilder(shardName).build();
        LOG.debug("{}: Sending RemoveServer message to peer {} for shard {}", new Object[]{this.persistenceId(), primaryPath, shardId});
        Timeout removeServerTimeout = new Timeout(datastoreContext.getShardLeaderElectionTimeout().duration());
        Future futureObj = Patterns.ask((ActorSelection)this.getContext().actorSelection(primaryPath), (Object)new RemoveServer(shardId.toString()), (Timeout)removeServerTimeout);
        futureObj.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    ShardManager.this.shardReplicaOperationsInProgress.remove(shardName);
                    LOG.debug("{}: RemoveServer request to leader {} for shard {} failed", new Object[]{ShardManager.this.persistenceId(), primaryPath, shardName, failure});
                    sender.tell((Object)new Status.Failure((Throwable)new RuntimeException(String.format("RemoveServer request to leader %s for shard %s failed", primaryPath, shardName), failure)), ShardManager.this.self());
                } else {
                    ShardManager.this.self().tell((Object)new WrappedShardResponse(shardId, response, primaryPath), sender);
                }
            }
        }, new Dispatchers(this.context().system().dispatchers()).getDispatcher(Dispatchers.DispatcherType.Client));
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private void removeShardReplica(RemoveShardReplica contextMessage, final String shardName, final String primaryPath, final ActorRef sender) {
        if (this.isShardReplicaOperationInProgress(shardName, sender)) {
            return;
        }
        this.shardReplicaOperationsInProgress.add(shardName);
        final ShardIdentifier shardId = this.getShardIdentifier(contextMessage.getMemberName(), shardName);
        DatastoreContext datastoreContext = this.newShardDatastoreContextBuilder(shardName).build();
        LOG.debug("{}: Sending RemoveServer message to peer {} for shard {}", new Object[]{this.persistenceId(), primaryPath, shardId});
        Timeout removeServerTimeout = new Timeout(datastoreContext.getShardLeaderElectionTimeout().duration());
        Future futureObj = Patterns.ask((ActorSelection)this.getContext().actorSelection(primaryPath), (Object)new RemoveServer(shardId.toString()), (Timeout)removeServerTimeout);
        futureObj.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    ShardManager.this.shardReplicaOperationsInProgress.remove(shardName);
                    LOG.debug("{}: RemoveServer request to leader {} for shard {} failed", new Object[]{ShardManager.this.persistenceId(), primaryPath, shardName, failure});
                    sender.tell((Object)new Status.Failure((Throwable)new RuntimeException(String.format("RemoveServer request to leader %s for shard %s failed", primaryPath, shardName), failure)), ShardManager.this.self());
                } else {
                    ShardManager.this.self().tell((Object)new WrappedShardResponse(shardId, response, primaryPath), sender);
                }
            }
        }, new Dispatchers(this.context().system().dispatchers()).getDispatcher(Dispatchers.DispatcherType.Client));
    }

    private void onShardReplicaRemoved(ServerRemoved message) {
        this.removeShard(new ShardIdentifier.Builder().fromShardIdString(message.getServerId()).build());
    }

    private void removeShard(ShardIdentifier shardId) {
        final String shardName = shardId.getShardName();
        ShardInformation shardInformation = this.localShards.remove(shardName);
        if (shardInformation == null) {
            LOG.debug("{} : Shard replica {} is not present in list", (Object)this.persistenceId(), (Object)shardId.toString());
            return;
        }
        final ActorRef shardActor = shardInformation.getActor();
        if (shardActor != null) {
            long timeoutInMS = Math.max(shardInformation.getDatastoreContext().getShardRaftConfig().getElectionTimeOutInterval().$times(3L).toMillis(), 10000L);
            LOG.debug("{} : Sending Shutdown to Shard actor {} with {} ms timeout", new Object[]{this.persistenceId(), shardActor, timeoutInMS});
            Future stopFuture = Patterns.gracefulStop((ActorRef)shardActor, (FiniteDuration)FiniteDuration.apply((long)timeoutInMS, (TimeUnit)TimeUnit.MILLISECONDS), (Object)Shutdown.INSTANCE);
            CompositeOnComplete<Boolean> onComplete = new CompositeOnComplete<Boolean>(){

                public void onComplete(Throwable failure, Boolean result) {
                    if (failure == null) {
                        LOG.debug("{} : Successfully shut down Shard actor {}", (Object)ShardManager.this.persistenceId(), (Object)shardActor);
                    } else {
                        LOG.warn("{}: Failed to shut down Shard actor {}", new Object[]{ShardManager.this.persistenceId(), shardActor, failure});
                    }
                    ShardManager.this.self().tell(() -> {
                        ShardManager.this.primaryShardInfoCache.remove(shardName);
                        ShardManager.this.shardActorsStopping.remove(shardName);
                        this.notifyOnCompleteTasks(failure, result);
                    }, ActorRef.noSender());
                }
            };
            this.shardActorsStopping.put(shardName, onComplete);
            stopFuture.onComplete((Function1)onComplete, new Dispatchers(this.context().system().dispatchers()).getDispatcher(Dispatchers.DispatcherType.Client));
        }
        LOG.debug("{} : Local Shard replica for shard {} has been removed", (Object)this.persistenceId(), (Object)shardName);
        this.persistShardList();
    }

    private void onGetSnapshot(GetSnapshot getSnapshot) {
        LOG.debug("{}: onGetSnapshot", (Object)this.persistenceId());
        ArrayList<String> notInitialized = null;
        for (ShardInformation shardInfo : this.localShards.values()) {
            if (shardInfo.isShardInitialized()) continue;
            if (notInitialized == null) {
                notInitialized = new ArrayList<String>();
            }
            notInitialized.add(shardInfo.getShardName());
        }
        if (notInitialized != null) {
            this.getSender().tell((Object)new Status.Failure((Throwable)new IllegalStateException(String.format("%d shard(s) %s are not initialized", notInitialized.size(), notInitialized))), this.getSelf());
            return;
        }
        ActorRef replyActor = this.getContext().actorOf(ShardManagerGetSnapshotReplyActor.props(new ArrayList<String>(this.localShards.keySet()), this.type, this.currentSnapshot, this.getSender(), this.persistenceId(), this.datastoreContextFactory.getBaseDatastoreContext().getShardInitializationTimeout().duration()));
        for (ShardInformation shardInfo : this.localShards.values()) {
            shardInfo.getActor().tell((Object)getSnapshot, replyActor);
        }
    }

    private void onCreateShard(CreateShard createShard) {
        Status.Failure reply;
        LOG.debug("{}: onCreateShard: {}", (Object)this.persistenceId(), (Object)createShard);
        try {
            String shardName = createShard.getModuleShardConfig().getShardName();
            if (this.localShards.containsKey(shardName)) {
                LOG.debug("{}: Shard {} already exists", (Object)this.persistenceId(), (Object)shardName);
                reply = new Status.Success((Object)String.format("Shard with name %s already exists", shardName));
            } else {
                this.doCreateShard(createShard);
                reply = new Status.Success(null);
            }
        }
        catch (Exception e) {
            LOG.error("{}: onCreateShard failed", (Object)this.persistenceId(), (Object)e);
            reply = new Status.Failure((Throwable)e);
        }
        if (this.getSender() != null && !this.getContext().system().deadLetters().equals((Object)this.getSender())) {
            this.getSender().tell((Object)reply, this.getSelf());
        }
    }

    private void onPrefixShardCreated(PrefixShardCreated message) {
        LOG.debug("{}: onPrefixShardCreated: {}", (Object)this.persistenceId(), (Object)message);
        PrefixShardConfiguration config = message.getConfiguration();
        ShardIdentifier shardId = this.getShardIdentifier(this.cluster.getCurrentMemberName(), ClusterUtils.getCleanShardName(config.getPrefix().getRootIdentifier()));
        String shardName = shardId.getShardName();
        if (this.isPreviousShardActorStopInProgress(shardName, message)) {
            return;
        }
        if (this.localShards.containsKey(shardName)) {
            LOG.debug("{}: Received create for an already existing shard {}", (Object)this.persistenceId(), (Object)shardName);
            PrefixShardConfiguration existing = this.configuration.getAllPrefixShardConfigurations().get(config.getPrefix());
            if (existing != null && existing.equals(config)) {
                return;
            }
        }
        this.doCreatePrefixShard(config, shardId, shardName);
    }

    private boolean isPreviousShardActorStopInProgress(final String shardName, final Object messageToDefer) {
        CompositeOnComplete<Boolean> stopOnComplete = this.shardActorsStopping.get(shardName);
        if (stopOnComplete == null) {
            return false;
        }
        LOG.debug("{} : Stop is in progress for shard {} - adding OnComplete callback to defer {}", new Object[]{this.persistenceId(), shardName, messageToDefer});
        final ActorRef sender = this.getSender();
        stopOnComplete.addOnComplete(new OnComplete<Boolean>(){

            public void onComplete(Throwable failure, Boolean result) {
                LOG.debug("{} : Stop complete for shard {} - re-queing {}", new Object[]{ShardManager.this.persistenceId(), shardName, messageToDefer});
                ShardManager.this.self().tell(messageToDefer, sender);
            }
        });
        return true;
    }

    private void doCreatePrefixShard(PrefixShardConfiguration config, ShardIdentifier shardId, String shardName) {
        this.configuration.addPrefixShardConfiguration(config);
        DatastoreContext.Builder builder = this.newShardDatastoreContextBuilder(shardName);
        builder.logicalStoreType(config.getPrefix().getDatastoreType()).storeRoot(config.getPrefix().getRootIdentifier());
        DatastoreContext shardDatastoreContext = builder.build();
        Map<String, String> peerAddresses = this.getPeerAddresses(shardName);
        boolean isActiveMember = true;
        LOG.debug("{} doCreatePrefixShard: shardId: {}, memberNames: {}, peerAddresses: {}, isActiveMember: {}", new Object[]{this.persistenceId(), shardId, config.getShardMemberNames(), peerAddresses, true});
        ShardInformation info = new ShardInformation(shardName, shardId, peerAddresses, shardDatastoreContext, Shard.builder(), this.peerAddressResolver);
        info.setActiveMember(true);
        this.localShards.put(info.getShardName(), info);
        if (this.schemaContext != null) {
            info.setSchemaContext(this.schemaContext);
            info.setActor(this.newShardActor(info));
        }
    }

    private void onPrefixShardRemoved(PrefixShardRemoved message) {
        LOG.debug("{}: onPrefixShardRemoved : {}", (Object)this.persistenceId(), (Object)message);
        DOMDataTreeIdentifier prefix = message.getPrefix();
        ShardIdentifier shardId = this.getShardIdentifier(this.cluster.getCurrentMemberName(), ClusterUtils.getCleanShardName(prefix.getRootIdentifier()));
        this.configuration.removePrefixShardConfiguration(prefix);
        this.removeShard(shardId);
    }

    private void doCreateShard(CreateShard createShard) {
        boolean isActiveMember;
        Map<String, String> peerAddresses;
        boolean shardWasInRecoveredSnapshot;
        ModuleShardConfiguration moduleShardConfig = createShard.getModuleShardConfig();
        String shardName = moduleShardConfig.getShardName();
        this.configuration.addModuleShardConfiguration(moduleShardConfig);
        DatastoreContext shardDatastoreContext = createShard.getDatastoreContext();
        shardDatastoreContext = shardDatastoreContext == null ? this.newShardDatastoreContext(shardName) : DatastoreContext.newBuilderFrom(shardDatastoreContext).shardPeerAddressResolver(this.peerAddressResolver).build();
        ShardIdentifier shardId = this.getShardIdentifier(this.cluster.getCurrentMemberName(), shardName);
        boolean bl = shardWasInRecoveredSnapshot = this.currentSnapshot != null && this.currentSnapshot.getShardList().contains(shardName);
        if (shardWasInRecoveredSnapshot || this.configuration.getMembersFromShardName(shardName).contains(this.cluster.getCurrentMemberName())) {
            peerAddresses = this.getPeerAddresses(shardName);
            isActiveMember = true;
        } else {
            isActiveMember = false;
            peerAddresses = Collections.emptyMap();
            shardDatastoreContext = DatastoreContext.newBuilderFrom(shardDatastoreContext).customRaftPolicyImplementation(DisableElectionsRaftPolicy.class.getName()).build();
        }
        LOG.debug("{} doCreateShard: shardId: {}, memberNames: {}, peerAddresses: {}, isActiveMember: {}", new Object[]{this.persistenceId(), shardId, moduleShardConfig.getShardMemberNames(), peerAddresses, isActiveMember});
        ShardInformation info = new ShardInformation(shardName, shardId, peerAddresses, shardDatastoreContext, createShard.getShardBuilder(), this.peerAddressResolver);
        info.setActiveMember(isActiveMember);
        this.localShards.put(info.getShardName(), info);
        if (this.schemaContext != null) {
            info.setSchemaContext(this.schemaContext);
            info.setActor(this.newShardActor(info));
        }
    }

    private DatastoreContext.Builder newShardDatastoreContextBuilder(String shardName) {
        return DatastoreContext.newBuilderFrom(this.datastoreContextFactory.getShardDatastoreContext(shardName)).shardPeerAddressResolver(this.peerAddressResolver);
    }

    private DatastoreContext newShardDatastoreContext(String shardName) {
        return this.newShardDatastoreContextBuilder(shardName).build();
    }

    private void checkReady() {
        if (this.isReadyWithLeaderId()) {
            LOG.info("{}: All Shards are ready - data store {} is ready", (Object)this.persistenceId(), (Object)this.type);
            this.readinessFuture.set(null);
        }
    }

    private void onLeaderStateChanged(ShardLeaderStateChanged leaderStateChanged) {
        LOG.info("{}: Received LeaderStateChanged message: {}", (Object)this.persistenceId(), (Object)leaderStateChanged);
        ShardInformation shardInformation = this.findShardInformation(leaderStateChanged.getMemberId());
        if (shardInformation != null) {
            shardInformation.setLocalDataTree(leaderStateChanged.getLocalShardDataTree());
            shardInformation.setLeaderVersion(leaderStateChanged.getLeaderPayloadVersion());
            if (shardInformation.setLeaderId(leaderStateChanged.getLeaderId())) {
                this.primaryShardInfoCache.remove(shardInformation.getShardName());
                this.notifyShardAvailabilityCallbacks(shardInformation);
            }
            this.checkReady();
        } else {
            LOG.debug("No shard found with member Id {}", (Object)leaderStateChanged.getMemberId());
        }
    }

    private void notifyShardAvailabilityCallbacks(ShardInformation shardInformation) {
        this.shardAvailabilityCallbacks.forEach(callback -> callback.accept(shardInformation.getShardName()));
    }

    private void onShardNotInitializedTimeout(ShardNotInitializedTimeout message) {
        ShardInformation shardInfo = message.getShardInfo();
        LOG.debug("{}: Received ShardNotInitializedTimeout message for shard {}", (Object)this.persistenceId(), (Object)shardInfo.getShardName());
        shardInfo.removeOnShardInitialized(message.getOnShardInitialized());
        if (!shardInfo.isShardInitialized()) {
            LOG.debug("{}: Returning NotInitializedException for shard {}", (Object)this.persistenceId(), (Object)shardInfo.getShardName());
            message.getSender().tell((Object)ShardManager.createNotInitializedException(shardInfo.getShardId()), this.getSelf());
        } else {
            LOG.debug("{}: Returning NoShardLeaderException for shard {}", (Object)this.persistenceId(), (Object)shardInfo.getShardName());
            message.getSender().tell((Object)new NoShardLeaderException(shardInfo.getShardId()), this.getSelf());
        }
    }

    private void onFollowerInitialSyncStatus(FollowerInitialSyncUpStatus status) {
        LOG.info("{} Received follower initial sync status for {} status sync done {}", new Object[]{this.persistenceId(), status.getName(), status.isInitialSyncDone()});
        ShardInformation shardInformation = this.findShardInformation(status.getName());
        if (shardInformation != null) {
            shardInformation.setFollowerSyncStatus(status.isInitialSyncDone());
            this.shardManagerMBean.setSyncStatus(this.isInSync());
        }
    }

    private void onRoleChangeNotification(RoleChangeNotification roleChanged) {
        LOG.info("{}: Received role changed for {} from {} to {}", new Object[]{this.persistenceId(), roleChanged.getMemberId(), roleChanged.getOldRole(), roleChanged.getNewRole()});
        ShardInformation shardInformation = this.findShardInformation(roleChanged.getMemberId());
        if (shardInformation != null) {
            shardInformation.setRole(roleChanged.getNewRole());
            this.checkReady();
            this.shardManagerMBean.setSyncStatus(this.isInSync());
        }
    }

    private ShardInformation findShardInformation(String memberId) {
        for (ShardInformation info : this.localShards.values()) {
            if (!info.getShardId().toString().equals(memberId)) continue;
            return info;
        }
        return null;
    }

    private boolean isReadyWithLeaderId() {
        boolean isReady = true;
        for (ShardInformation info : this.localShards.values()) {
            if (info.isShardReadyWithLeaderId()) continue;
            isReady = false;
            break;
        }
        return isReady;
    }

    private boolean isInSync() {
        for (ShardInformation info : this.localShards.values()) {
            if (info.isInSync()) continue;
            return false;
        }
        return true;
    }

    private void onActorInitialized(Object message) {
        ShardIdentifier shardId;
        ActorRef sender = this.getSender();
        if (sender == null) {
            return;
        }
        String actorName = sender.path().name();
        try {
            shardId = ShardIdentifier.fromShardIdString(actorName);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("{}: ignoring actor {}", new Object[]{this.persistenceId, actorName, e});
            return;
        }
        this.markShardAsInitialized(shardId.getShardName());
    }

    private void markShardAsInitialized(String shardName) {
        LOG.debug("{}: Initializing shard [{}]", (Object)this.persistenceId(), (Object)shardName);
        ShardInformation shardInformation = this.localShards.get(shardName);
        if (shardInformation != null) {
            shardInformation.setActorInitialized();
            shardInformation.getActor().tell((Object)new RegisterRoleChangeListener(), this.self());
        }
    }

    protected void handleRecover(Object message) throws Exception {
        if (message instanceof RecoveryCompleted) {
            this.onRecoveryCompleted();
        } else if (message instanceof SnapshotOffer) {
            this.applyShardManagerSnapshot((ShardManagerSnapshot)((SnapshotOffer)message).snapshot());
        }
    }

    private void onRecoveryCompleted() {
        LOG.info("Recovery complete : {}", (Object)this.persistenceId());
        if (this.currentSnapshot == null && this.restoreFromSnapshot != null && this.restoreFromSnapshot.getShardManagerSnapshot() != null) {
            ShardManagerSnapshot snapshot = this.restoreFromSnapshot.getShardManagerSnapshot();
            LOG.debug("{}: Restoring from ShardManagerSnapshot: {}", (Object)this.persistenceId(), (Object)snapshot);
            this.applyShardManagerSnapshot(snapshot);
        }
        this.createLocalShards();
    }

    private void sendResponse(ShardInformation shardInformation, boolean doWait, boolean wantShardReady, Supplier<Object> messageSupplier) {
        if (!shardInformation.isShardInitialized() || wantShardReady && !shardInformation.isShardReadyWithLeaderId()) {
            if (doWait) {
                ActorRef sender = this.getSender();
                ActorRef self = this.self();
                Runnable replyRunnable = () -> sender.tell(messageSupplier.get(), self);
                OnShardInitialized onShardInitialized = wantShardReady ? new OnShardReady(replyRunnable) : new OnShardInitialized(replyRunnable);
                shardInformation.addOnShardInitialized(onShardInitialized);
                FiniteDuration timeout = shardInformation.getDatastoreContext().getShardInitializationTimeout().duration();
                if (shardInformation.isShardInitialized()) {
                    timeout = FiniteDuration.create((long)(shardInformation.getDatastoreContext().getShardRaftConfig().getElectionTimeOutInterval().toMillis() * 2L), (TimeUnit)TimeUnit.MILLISECONDS);
                }
                LOG.debug("{}: Scheduling {} ms timer to wait for shard {}", new Object[]{this.persistenceId(), timeout.toMillis(), shardInformation});
                Cancellable timeoutSchedule = this.getContext().system().scheduler().scheduleOnce(timeout, this.getSelf(), (Object)new ShardNotInitializedTimeout(shardInformation, onShardInitialized, sender), (ExecutionContext)this.getContext().dispatcher(), this.getSelf());
                onShardInitialized.setTimeoutSchedule(timeoutSchedule);
            } else if (!shardInformation.isShardInitialized()) {
                LOG.debug("{}: Returning NotInitializedException for shard {}", (Object)this.persistenceId(), (Object)shardInformation.getShardName());
                this.getSender().tell((Object)ShardManager.createNotInitializedException(shardInformation.getShardId()), this.getSelf());
            } else {
                LOG.debug("{}: Returning NoShardLeaderException for shard {}", (Object)this.persistenceId(), (Object)shardInformation.getShardName());
                this.getSender().tell((Object)new NoShardLeaderException(shardInformation.getShardId()), this.getSelf());
            }
            return;
        }
        this.getSender().tell(messageSupplier.get(), this.getSelf());
    }

    private static NotInitializedException createNotInitializedException(ShardIdentifier shardId) {
        return new NotInitializedException(String.format("Found primary shard %s but it's not initialized yet. Please try again later", shardId));
    }

    @VisibleForTesting
    static MemberName memberToName(Member member) {
        return MemberName.forName((String)((String)member.roles().iterator().next()));
    }

    private void memberRemoved(ClusterEvent.MemberRemoved message) {
        MemberName memberName = ShardManager.memberToName(message.member());
        LOG.info("{}: Received MemberRemoved: memberName: {}, address: {}", new Object[]{this.persistenceId(), memberName, message.member().address()});
        this.peerAddressResolver.removePeerAddress(memberName);
        for (ShardInformation info : this.localShards.values()) {
            info.peerDown(memberName, this.getShardIdentifier(memberName, info.getShardName()).toString(), this.getSelf());
        }
    }

    private void memberExited(ClusterEvent.MemberExited message) {
        MemberName memberName = ShardManager.memberToName(message.member());
        LOG.info("{}: Received MemberExited: memberName: {}, address: {}", new Object[]{this.persistenceId(), memberName, message.member().address()});
        this.peerAddressResolver.removePeerAddress(memberName);
        for (ShardInformation info : this.localShards.values()) {
            info.peerDown(memberName, this.getShardIdentifier(memberName, info.getShardName()).toString(), this.getSelf());
        }
    }

    private void memberUp(ClusterEvent.MemberUp message) {
        MemberName memberName = ShardManager.memberToName(message.member());
        LOG.info("{}: Received MemberUp: memberName: {}, address: {}", new Object[]{this.persistenceId(), memberName, message.member().address()});
        this.memberUp(memberName, message.member().address());
    }

    private void memberUp(MemberName memberName, Address address) {
        this.addPeerAddress(memberName, address);
        this.checkReady();
    }

    private void memberWeaklyUp(ClusterEvent.MemberWeaklyUp message) {
        MemberName memberName = ShardManager.memberToName(message.member());
        LOG.info("{}: Received MemberWeaklyUp: memberName: {}, address: {}", new Object[]{this.persistenceId(), memberName, message.member().address()});
        this.memberUp(memberName, message.member().address());
    }

    private void addPeerAddress(MemberName memberName, Address address) {
        this.peerAddressResolver.addPeerAddress(memberName, address);
        for (ShardInformation info : this.localShards.values()) {
            String shardName = info.getShardName();
            String peerId = this.getShardIdentifier(memberName, shardName).toString();
            info.updatePeerAddress(peerId, this.peerAddressResolver.getShardActorAddress(shardName, memberName), this.getSelf());
            info.peerUp(memberName, peerId, this.getSelf());
        }
    }

    private void memberReachable(ClusterEvent.ReachableMember message) {
        MemberName memberName = ShardManager.memberToName(message.member());
        LOG.info("Received ReachableMember: memberName {}, address: {}", (Object)memberName, (Object)message.member().address());
        this.addPeerAddress(memberName, message.member().address());
        this.markMemberAvailable(memberName);
    }

    private void memberUnreachable(ClusterEvent.UnreachableMember message) {
        MemberName memberName = ShardManager.memberToName(message.member());
        LOG.info("Received UnreachableMember: memberName {}, address: {}", (Object)memberName, (Object)message.member().address());
        this.markMemberUnavailable(memberName);
    }

    private void markMemberUnavailable(MemberName memberName) {
        for (ShardInformation info : this.localShards.values()) {
            String leaderId = info.getLeaderId();
            if (leaderId != null && ShardIdentifier.fromShardIdString(leaderId).getMemberName().equals((Object)memberName)) {
                LOG.debug("Marking Leader {} as unavailable.", (Object)leaderId);
                info.setLeaderAvailable(false);
                this.primaryShardInfoCache.remove(info.getShardName());
                this.notifyShardAvailabilityCallbacks(info);
            }
            info.peerDown(memberName, this.getShardIdentifier(memberName, info.getShardName()).toString(), this.getSelf());
        }
    }

    private void markMemberAvailable(MemberName memberName) {
        for (ShardInformation info : this.localShards.values()) {
            String leaderId = info.getLeaderId();
            if (leaderId != null && ShardIdentifier.fromShardIdString(leaderId).getMemberName().equals((Object)memberName)) {
                LOG.debug("Marking Leader {} as available.", (Object)leaderId);
                info.setLeaderAvailable(true);
            }
            info.peerUp(memberName, this.getShardIdentifier(memberName, info.getShardName()).toString(), this.getSelf());
        }
    }

    private void onDatastoreContextFactory(DatastoreContextFactory factory) {
        this.datastoreContextFactory = factory;
        for (ShardInformation info : this.localShards.values()) {
            info.setDatastoreContext(this.newShardDatastoreContext(info.getShardName()), this.getSelf());
        }
    }

    private void onGetLocalShardIds() {
        ArrayList<String> response = new ArrayList<String>(this.localShards.size());
        for (ShardInformation info : this.localShards.values()) {
            response.add(info.getShardId().toString());
        }
        this.getSender().tell((Object)new Status.Success(response), this.getSelf());
    }

    private void onSwitchShardBehavior(SwitchShardBehavior message) {
        ShardIdentifier identifier = message.getShardId();
        if (identifier != null) {
            ShardInformation info = this.localShards.get(identifier.getShardName());
            if (info == null) {
                this.getSender().tell((Object)new Status.Failure((Throwable)new IllegalArgumentException("Shard " + identifier + " is not local")), this.getSelf());
                return;
            }
            this.switchShardBehavior(info, new SwitchBehavior(message.getNewState(), message.getTerm()));
        } else {
            for (ShardInformation info : this.localShards.values()) {
                this.switchShardBehavior(info, new SwitchBehavior(message.getNewState(), message.getTerm()));
            }
        }
        this.getSender().tell((Object)new Status.Success(null), this.getSelf());
    }

    private void switchShardBehavior(ShardInformation info, SwitchBehavior switchBehavior) {
        ActorRef actor = info.getActor();
        if (actor != null) {
            actor.tell((Object)switchBehavior, this.getSelf());
        } else {
            LOG.warn("Could not switch the behavior of shard {} to {} - shard is not yet available", (Object)info.getShardName(), (Object)switchBehavior.getNewState());
        }
    }

    private void updateSchemaContext(Object message) {
        this.schemaContext = ((UpdateSchemaContext)((Object)message)).getEffectiveModelContext();
        LOG.debug("Got updated SchemaContext: # of modules {}", (Object)this.schemaContext.getModules().size());
        for (ShardInformation info : this.localShards.values()) {
            info.setSchemaContext(this.schemaContext);
            if (info.getActor() == null) {
                LOG.debug("Creating Shard {}", (Object)info.getShardId());
                info.setActor(this.newShardActor(info));
                String shardName = info.getShardName();
                for (MemberName memberName : this.peerAddressResolver.getPeerMembers()) {
                    String peerId = this.getShardIdentifier(memberName, shardName).toString();
                    String peerAddress = this.peerAddressResolver.getShardActorAddress(shardName, memberName);
                    info.updatePeerAddress(peerId, peerAddress, this.getSelf());
                    info.peerUp(memberName, peerId, this.getSelf());
                    LOG.debug("{}: updated peer {} on member {} with address {} on shard {} whose actor address is {}", new Object[]{this.persistenceId(), peerId, memberName, peerAddress, info.getShardId(), info.getActor()});
                }
                continue;
            }
            info.getActor().tell(message, this.getSelf());
        }
    }

    @VisibleForTesting
    protected ClusterWrapper getCluster() {
        return this.cluster;
    }

    @VisibleForTesting
    protected ActorRef newShardActor(ShardInformation info) {
        return this.getContext().actorOf(info.newProps().withDispatcher(this.shardDispatcherPath), info.getShardId().toString());
    }

    private void findPrimary(FindPrimary message) {
        LOG.debug("{}: In findPrimary: {}", (Object)this.persistenceId(), (Object)message);
        String shardName = message.getShardName();
        boolean canReturnLocalShardState = !(message instanceof RemoteFindPrimary);
        ShardInformation info = this.localShards.get(shardName);
        if (info != null && info.isActiveMember()) {
            this.sendResponse(info, message.isWaitUntilReady(), true, () -> {
                String primaryPath = info.getSerializedLeaderActor();
                Object found = canReturnLocalShardState && info.isLeader() ? new LocalPrimaryShardFound(primaryPath, info.getLocalShardDataTree().get()) : new RemotePrimaryShardFound(primaryPath, info.getLeaderVersion());
                LOG.debug("{}: Found primary for {}: {}", new Object[]{this.persistenceId(), shardName, found});
                return found;
            });
            return;
        }
        Collection<String> visitedAddresses = message instanceof RemoteFindPrimary ? ((RemoteFindPrimary)message).getVisitedAddresses() : new ArrayList(1);
        visitedAddresses.add(this.peerAddressResolver.getShardManagerActorPathBuilder(this.cluster.getSelfAddress()).toString());
        for (String address : this.peerAddressResolver.getShardManagerPeerActorAddresses()) {
            if (visitedAddresses.contains(address)) continue;
            LOG.debug("{}: findPrimary for {} forwarding to remote ShardManager {}, visitedAddresses: {}", new Object[]{this.persistenceId(), shardName, address, visitedAddresses});
            this.getContext().actorSelection(address).forward((Object)new RemoteFindPrimary(shardName, message.isWaitUntilReady(), visitedAddresses), (ActorContext)this.getContext());
            return;
        }
        LOG.debug("{}: No shard found for {}", (Object)this.persistenceId(), (Object)shardName);
        this.getSender().tell((Object)new PrimaryNotFoundException(String.format("No primary shard found for %s.", shardName)), this.getSelf());
    }

    private void findPrimary(String shardName, final FindPrimaryResponseHandler handler) {
        Timeout findPrimaryTimeout = new Timeout(this.datastoreContextFactory.getBaseDatastoreContext().getShardInitializationTimeout().duration().$times(2L));
        Future futureObj = Patterns.ask((ActorRef)this.getSelf(), (Object)new FindPrimary(shardName, true), (Timeout)findPrimaryTimeout);
        futureObj.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    handler.onFailure(failure);
                } else if (response instanceof RemotePrimaryShardFound) {
                    handler.onRemotePrimaryShardFound((RemotePrimaryShardFound)response);
                } else if (response instanceof LocalPrimaryShardFound) {
                    handler.onLocalPrimaryFound((LocalPrimaryShardFound)response);
                } else {
                    handler.onUnknownResponse(response);
                }
            }
        }, new Dispatchers(this.context().system().dispatchers()).getDispatcher(Dispatchers.DispatcherType.Client));
    }

    private ShardIdentifier getShardIdentifier(MemberName memberName, String shardName) {
        return this.peerAddressResolver.getShardIdentifier(memberName, shardName);
    }

    private void createLocalShards() {
        MemberName memberName = this.cluster.getCurrentMemberName();
        Collection<String> memberShardNames = this.configuration.getMemberShardNames(memberName);
        HashMap<String, DatastoreSnapshot.ShardSnapshot> shardSnapshots = new HashMap<String, DatastoreSnapshot.ShardSnapshot>();
        if (this.restoreFromSnapshot != null) {
            for (DatastoreSnapshot.ShardSnapshot snapshot : this.restoreFromSnapshot.getShardSnapshots()) {
                shardSnapshots.put(snapshot.getName(), snapshot);
            }
        }
        this.restoreFromSnapshot = null;
        for (String shardName : memberShardNames) {
            ShardIdentifier shardId = this.getShardIdentifier(memberName, shardName);
            LOG.debug("{}: Creating local shard: {}", (Object)this.persistenceId(), (Object)shardId);
            Map<String, String> peerAddresses = this.getPeerAddresses(shardName);
            this.localShards.put(shardName, this.createShardInfoFor(shardName, shardId, peerAddresses, this.newShardDatastoreContext(shardName), shardSnapshots));
        }
    }

    @VisibleForTesting
    ShardInformation createShardInfoFor(String shardName, ShardIdentifier shardId, Map<String, String> peerAddresses, DatastoreContext datastoreContext, Map<String, DatastoreSnapshot.ShardSnapshot> shardSnapshots) {
        return new ShardInformation(shardName, shardId, peerAddresses, datastoreContext, (Shard.AbstractBuilder<?, ?>)Shard.builder().restoreFromSnapshot(shardSnapshots.get(shardName)), this.peerAddressResolver);
    }

    Map<String, String> getPeerAddresses(String shardName) {
        Collection<MemberName> members = this.configuration.getMembersFromShardName(shardName);
        return this.getPeerAddresses(shardName, members);
    }

    private Map<String, String> getPeerAddresses(String shardName, Collection<MemberName> members) {
        HashMap<String, String> peerAddresses = new HashMap<String, String>();
        MemberName currentMemberName = this.cluster.getCurrentMemberName();
        for (MemberName memberName : members) {
            if (currentMemberName.equals((Object)memberName)) continue;
            ShardIdentifier shardId = this.getShardIdentifier(memberName, shardName);
            String address = this.peerAddressResolver.getShardActorAddress(shardName, memberName);
            peerAddresses.put(shardId.toString(), address);
        }
        return peerAddresses;
    }

    public SupervisorStrategy supervisorStrategy() {
        return new OneForOneStrategy(10, (Duration)FiniteDuration.create((long)1L, (TimeUnit)TimeUnit.MINUTES), t -> {
            LOG.warn("Supervisor Strategy caught unexpected exception - resuming", t);
            return SupervisorStrategy.resume();
        });
    }

    public String persistenceId() {
        return this.persistenceId;
    }

    @VisibleForTesting
    ShardManagerInfoMBean getMBean() {
        return this.shardManagerMBean;
    }

    private boolean isShardReplicaOperationInProgress(String shardName, ActorRef sender) {
        if (this.shardReplicaOperationsInProgress.contains(shardName)) {
            LOG.debug("{}: A shard replica operation for {} is already in progress", (Object)this.persistenceId(), (Object)shardName);
            sender.tell((Object)new Status.Failure((Throwable)new IllegalStateException(String.format("A shard replica operation for %s is already in progress", shardName))), this.getSelf());
            return true;
        }
        return false;
    }

    private void onAddPrefixShardReplica(final AddPrefixShardReplica message) {
        LOG.debug("{}: onAddPrefixShardReplica: {}", (Object)this.persistenceId(), (Object)message);
        ShardIdentifier shardId = this.getShardIdentifier(this.cluster.getCurrentMemberName(), ClusterUtils.getCleanShardName(message.getShardPrefix()));
        String shardName = shardId.getShardName();
        if (this.schemaContext == null) {
            LOG.debug("{}: No SchemaContext is available in order to create a local shard instance for {}", (Object)this.persistenceId(), (Object)shardName);
            this.getSender().tell((Object)new Status.Failure((Throwable)new IllegalStateException("No SchemaContext is available in order to create a local shard instance for " + shardName)), this.getSelf());
            return;
        }
        this.findPrimary(shardName, new AutoFindPrimaryFailureResponseHandler(this.getSender(), shardName, this.persistenceId(), this.getSelf()){

            @Override
            public void onRemotePrimaryShardFound(RemotePrimaryShardFound response) {
                RunnableMessage runnable = () -> ShardManager.this.addPrefixShard(this.getShardName(), message.getShardPrefix(), response, ShardManager.this.getSender());
                if (!ShardManager.this.isPreviousShardActorStopInProgress(this.getShardName(), runnable)) {
                    ShardManager.this.getSelf().tell((Object)runnable, this.getTargetActor());
                }
            }

            @Override
            public void onLocalPrimaryFound(LocalPrimaryShardFound message2) {
                ShardManager.this.sendLocalReplicaAlreadyExistsReply(this.getShardName(), this.getTargetActor());
            }
        });
    }

    private void onAddShardReplica(AddShardReplica shardReplicaMsg) {
        String shardName = shardReplicaMsg.getShardName();
        LOG.debug("{}: onAddShardReplica: {}", (Object)this.persistenceId(), (Object)shardReplicaMsg);
        if (!this.configuration.isShardConfigured(shardName)) {
            LOG.debug("{}: No module configuration exists for shard {}", (Object)this.persistenceId(), (Object)shardName);
            this.getSender().tell((Object)new Status.Failure((Throwable)new IllegalArgumentException("No module configuration exists for shard " + shardName)), this.getSelf());
            return;
        }
        if (this.schemaContext == null) {
            LOG.debug("{}: No SchemaContext is available in order to create a local shard instance for {}", (Object)this.persistenceId(), (Object)shardName);
            this.getSender().tell((Object)new Status.Failure((Throwable)new IllegalStateException("No SchemaContext is available in order to create a local shard instance for " + shardName)), this.getSelf());
            return;
        }
        this.findPrimary(shardName, new AutoFindPrimaryFailureResponseHandler(this.getSender(), shardName, this.persistenceId(), this.getSelf()){

            @Override
            public void onRemotePrimaryShardFound(RemotePrimaryShardFound response) {
                RunnableMessage runnable = () -> ShardManager.this.addShard(this.getShardName(), response, ShardManager.this.getSender());
                if (!ShardManager.this.isPreviousShardActorStopInProgress(this.getShardName(), runnable)) {
                    ShardManager.this.getSelf().tell((Object)runnable, this.getTargetActor());
                }
            }

            @Override
            public void onLocalPrimaryFound(LocalPrimaryShardFound message) {
                ShardManager.this.sendLocalReplicaAlreadyExistsReply(this.getShardName(), this.getTargetActor());
            }
        });
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private void sendLocalReplicaAlreadyExistsReply(String shardName, ActorRef sender) {
        LOG.debug("{}: Local shard {} already exists", (Object)this.persistenceId(), (Object)shardName);
        sender.tell((Object)new Status.Failure((Throwable)new AlreadyExistsException(String.format("Local shard %s already exists", shardName))), this.getSelf());
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private void addPrefixShard(String shardName, YangInstanceIdentifier shardPrefix, RemotePrimaryShardFound response, ActorRef sender) {
        ShardInformation shardInfo;
        boolean removeShardOnFailure;
        if (this.isShardReplicaOperationInProgress(shardName, sender)) {
            return;
        }
        this.shardReplicaOperationsInProgress.add(shardName);
        ShardInformation existingShardInfo = this.localShards.get(shardName);
        if (existingShardInfo == null) {
            removeShardOnFailure = true;
            ShardIdentifier shardId = this.getShardIdentifier(this.cluster.getCurrentMemberName(), shardName);
            DatastoreContext.Builder builder = this.newShardDatastoreContextBuilder(shardName);
            builder.storeRoot(shardPrefix).customRaftPolicyImplementation(DisableElectionsRaftPolicy.class.getName());
            DatastoreContext datastoreContext = builder.build();
            shardInfo = new ShardInformation(shardName, shardId, this.getPeerAddresses(shardName), datastoreContext, Shard.builder(), this.peerAddressResolver);
            shardInfo.setActiveMember(false);
            shardInfo.setSchemaContext(this.schemaContext);
            this.localShards.put(shardName, shardInfo);
            shardInfo.setActor(this.newShardActor(shardInfo));
        } else {
            removeShardOnFailure = false;
            shardInfo = existingShardInfo;
        }
        this.execAddShard(shardName, shardInfo, response, removeShardOnFailure, sender);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private void addShard(String shardName, RemotePrimaryShardFound response, ActorRef sender) {
        ShardInformation shardInfo;
        boolean removeShardOnFailure;
        if (this.isShardReplicaOperationInProgress(shardName, sender)) {
            return;
        }
        this.shardReplicaOperationsInProgress.add(shardName);
        ShardInformation existingShardInfo = this.localShards.get(shardName);
        if (existingShardInfo == null) {
            removeShardOnFailure = true;
            ShardIdentifier shardId = this.getShardIdentifier(this.cluster.getCurrentMemberName(), shardName);
            DatastoreContext datastoreContext = this.newShardDatastoreContextBuilder(shardName).customRaftPolicyImplementation(DisableElectionsRaftPolicy.class.getName()).build();
            shardInfo = new ShardInformation(shardName, shardId, this.getPeerAddresses(shardName), datastoreContext, Shard.builder(), this.peerAddressResolver);
            shardInfo.setActiveMember(false);
            shardInfo.setSchemaContext(this.schemaContext);
            this.localShards.put(shardName, shardInfo);
            shardInfo.setActor(this.newShardActor(shardInfo));
        } else {
            removeShardOnFailure = false;
            shardInfo = existingShardInfo;
        }
        this.execAddShard(shardName, shardInfo, response, removeShardOnFailure, sender);
    }

    private void execAddShard(final String shardName, final ShardInformation shardInfo, final RemotePrimaryShardFound response, final boolean removeShardOnFailure, final ActorRef sender) {
        String localShardAddress = this.peerAddressResolver.getShardActorAddress(shardName, this.cluster.getCurrentMemberName());
        LOG.debug("{}: Sending AddServer message to peer {} for shard {}", new Object[]{this.persistenceId(), response.getPrimaryPath(), shardInfo.getShardId()});
        Timeout addServerTimeout = new Timeout(shardInfo.getDatastoreContext().getShardLeaderElectionTimeout().duration());
        Future futureObj = Patterns.ask((ActorSelection)this.getContext().actorSelection(response.getPrimaryPath()), (Object)new AddServer(shardInfo.getShardId().toString(), localShardAddress, true), (Timeout)addServerTimeout);
        futureObj.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object addServerResponse) {
                if (failure != null) {
                    LOG.debug("{}: AddServer request to {} for {} failed", new Object[]{ShardManager.this.persistenceId(), response.getPrimaryPath(), shardName, failure});
                    String msg = String.format("AddServer request to leader %s for shard %s failed", response.getPrimaryPath(), shardName);
                    ShardManager.this.self().tell((Object)new ForwardedAddServerFailure(shardName, msg, failure, removeShardOnFailure), sender);
                } else {
                    ShardManager.this.self().tell((Object)new ForwardedAddServerReply(shardInfo, (AddServerReply)addServerResponse, response.getPrimaryPath(), removeShardOnFailure), sender);
                }
            }
        }, new Dispatchers(this.context().system().dispatchers()).getDispatcher(Dispatchers.DispatcherType.Client));
    }

    private void onAddServerFailure(String shardName, String message, Throwable failure, ActorRef sender, boolean removeShardOnFailure) {
        ShardInformation shardInfo;
        this.shardReplicaOperationsInProgress.remove(shardName);
        if (removeShardOnFailure && (shardInfo = this.localShards.remove(shardName)).getActor() != null) {
            shardInfo.getActor().tell((Object)PoisonPill.getInstance(), this.getSelf());
        }
        sender.tell((Object)new Status.Failure(message == null ? failure : new RuntimeException(message, failure)), this.getSelf());
    }

    private void onAddServerReply(ShardInformation shardInfo, AddServerReply replyMsg, ActorRef sender, String leaderPath, boolean removeShardOnFailure) {
        String shardName = shardInfo.getShardName();
        this.shardReplicaOperationsInProgress.remove(shardName);
        LOG.debug("{}: Received {} for shard {} from leader {}", new Object[]{this.persistenceId(), replyMsg, shardName, leaderPath});
        if (replyMsg.getStatus() == ServerChangeStatus.OK) {
            LOG.debug("{}: Leader shard successfully added the replica shard {}", (Object)this.persistenceId(), (Object)shardName);
            shardInfo.setDatastoreContext(this.newShardDatastoreContext(shardName), this.getSelf());
            shardInfo.setActiveMember(true);
            this.persistShardList();
            sender.tell((Object)new Status.Success(null), this.getSelf());
        } else if (replyMsg.getStatus() == ServerChangeStatus.ALREADY_EXISTS) {
            this.sendLocalReplicaAlreadyExistsReply(shardName, sender);
        } else {
            LOG.warn("{}: Leader failed to add shard replica {} with status {}", new Object[]{this.persistenceId(), shardName, replyMsg.getStatus()});
            Exception failure = ShardManager.getServerChangeException(AddServer.class, replyMsg.getStatus(), leaderPath, shardInfo.getShardId());
            this.onAddServerFailure(shardName, null, failure, sender, removeShardOnFailure);
        }
    }

    private static Exception getServerChangeException(Class<?> serverChange, ServerChangeStatus serverChangeStatus, String leaderPath, ShardIdentifier shardId) {
        switch (serverChangeStatus) {
            case TIMEOUT: {
                return new TimeoutException(String.format("The shard leader %s timed out trying to replicate the initial data to the new shard %s.Possible causes - there was a problem replicating the data or shard leadership changed while replicating the shard data", leaderPath, shardId.getShardName()));
            }
            case NO_LEADER: {
                return new NoShardLeaderException(shardId);
            }
            case NOT_SUPPORTED: {
                return new UnsupportedOperationException(String.format("%s request is not supported for shard %s", serverChange.getSimpleName(), shardId.getShardName()));
            }
        }
        return new RuntimeException(String.format("%s request to leader %s for shard %s failed with status %s", serverChange.getSimpleName(), leaderPath, shardId.getShardName(), serverChangeStatus));
    }

    private void onRemoveShardReplica(final RemoveShardReplica shardReplicaMsg) {
        LOG.debug("{}: onRemoveShardReplica: {}", (Object)this.persistenceId(), (Object)shardReplicaMsg);
        this.findPrimary(shardReplicaMsg.getShardName(), new AutoFindPrimaryFailureResponseHandler(this.getSender(), shardReplicaMsg.getShardName(), this.persistenceId(), this.getSelf()){

            @Override
            public void onRemotePrimaryShardFound(RemotePrimaryShardFound response) {
                this.doRemoveShardReplicaAsync(response.getPrimaryPath());
            }

            @Override
            public void onLocalPrimaryFound(LocalPrimaryShardFound response) {
                this.doRemoveShardReplicaAsync(response.getPrimaryPath());
            }

            private void doRemoveShardReplicaAsync(String primaryPath) {
                ShardManager.this.getSelf().tell(() -> ShardManager.this.removeShardReplica(shardReplicaMsg, this.getShardName(), primaryPath, ShardManager.this.getSender()), this.getTargetActor());
            }
        });
    }

    private void onRemovePrefixShardReplica(final RemovePrefixShardReplica message) {
        LOG.debug("{}: onRemovePrefixShardReplica: {}", (Object)this.persistenceId(), (Object)message);
        ShardIdentifier shardId = this.getShardIdentifier(this.cluster.getCurrentMemberName(), ClusterUtils.getCleanShardName(message.getShardPrefix()));
        String shardName = shardId.getShardName();
        this.findPrimary(shardName, new AutoFindPrimaryFailureResponseHandler(this.getSender(), shardName, this.persistenceId(), this.getSelf()){

            @Override
            public void onRemotePrimaryShardFound(RemotePrimaryShardFound response) {
                this.doRemoveShardReplicaAsync(response.getPrimaryPath());
            }

            @Override
            public void onLocalPrimaryFound(LocalPrimaryShardFound response) {
                this.doRemoveShardReplicaAsync(response.getPrimaryPath());
            }

            private void doRemoveShardReplicaAsync(String primaryPath) {
                ShardManager.this.getSelf().tell(() -> ShardManager.this.removePrefixShardReplica(message, this.getShardName(), primaryPath, ShardManager.this.getSender()), this.getTargetActor());
            }
        });
    }

    private void persistShardList() {
        ArrayList<String> shardList = new ArrayList<String>(this.localShards.keySet());
        for (ShardInformation shardInfo : this.localShards.values()) {
            if (shardInfo.isActiveMember()) continue;
            shardList.remove(shardInfo.getShardName());
        }
        LOG.debug("{}: persisting the shard list {}", (Object)this.persistenceId(), shardList);
        this.saveSnapshot(this.updateShardManagerSnapshot(shardList, this.configuration.getAllPrefixShardConfigurations()));
    }

    private ShardManagerSnapshot updateShardManagerSnapshot(List<String> shardList, Map<DOMDataTreeIdentifier, PrefixShardConfiguration> allPrefixShardConfigurations) {
        this.currentSnapshot = new ShardManagerSnapshot(shardList, allPrefixShardConfigurations);
        return this.currentSnapshot;
    }

    private void applyShardManagerSnapshot(ShardManagerSnapshot snapshot) {
        this.currentSnapshot = snapshot;
        LOG.debug("{}: onSnapshotOffer: {}", (Object)this.persistenceId(), (Object)this.currentSnapshot);
        MemberName currentMember = this.cluster.getCurrentMemberName();
        HashSet<String> configuredShardList = new HashSet<String>(this.configuration.getMemberShardNames(currentMember));
        for (String shard : this.currentSnapshot.getShardList()) {
            if (!configuredShardList.contains(shard)) {
                LOG.debug("{}: adding shard {}", (Object)this.persistenceId(), (Object)shard);
                this.configuration.addMemberReplicaForShard(shard, currentMember);
                continue;
            }
            configuredShardList.remove(shard);
        }
        for (String shard : configuredShardList) {
            LOG.debug("{}: removing shard {}", (Object)this.persistenceId(), (Object)shard);
            this.configuration.removeMemberReplicaForShard(shard, currentMember);
        }
    }

    private void onSaveSnapshotSuccess(SaveSnapshotSuccess successMessage) {
        LOG.debug("{} saved ShardManager snapshot successfully. Deleting the prev snapshot if available", (Object)this.persistenceId());
        this.deleteSnapshots(new SnapshotSelectionCriteria(Long.MaxValue(), successMessage.metadata().timestamp() - 1L, 0L, 0L));
    }

    private void onChangeShardServersVotingStatus(ChangeShardMembersVotingStatus changeMembersVotingStatus) {
        LOG.debug("{}: onChangeShardServersVotingStatus: {}", (Object)this.persistenceId(), (Object)changeMembersVotingStatus);
        String shardName = changeMembersVotingStatus.getShardName();
        HashMap<String, Boolean> serverVotingStatusMap = new HashMap<String, Boolean>();
        for (Map.Entry<String, Boolean> e : changeMembersVotingStatus.getMeberVotingStatusMap().entrySet()) {
            serverVotingStatusMap.put(this.getShardIdentifier(MemberName.forName((String)e.getKey()), shardName).toString(), e.getValue());
        }
        ChangeServersVotingStatus changeServersVotingStatus = new ChangeServersVotingStatus(serverVotingStatusMap);
        this.findLocalShard(shardName, this.getSender(), localShardFound -> this.changeShardMembersVotingStatus(changeServersVotingStatus, shardName, localShardFound.getPath(), this.getSender()));
    }

    private void onFlipShardMembersVotingStatus(FlipShardMembersVotingStatus flipMembersVotingStatus) {
        LOG.debug("{}: onFlipShardMembersVotingStatus: {}", (Object)this.persistenceId(), (Object)flipMembersVotingStatus);
        final ActorRef sender = this.getSender();
        final String shardName = flipMembersVotingStatus.getShardName();
        this.findLocalShard(shardName, sender, localShardFound -> {
            Future future = Patterns.ask((ActorRef)localShardFound.getPath(), (Object)GetOnDemandRaftState.INSTANCE, (Timeout)Timeout.apply((long)30L, (TimeUnit)TimeUnit.SECONDS));
            future.onComplete((Function1)new OnComplete<Object>(){

                public void onComplete(Throwable failure, Object response) {
                    if (failure != null) {
                        sender.tell((Object)new Status.Failure((Throwable)new RuntimeException(String.format("Failed to access local shard %s", shardName), failure)), ShardManager.this.self());
                        return;
                    }
                    OnDemandRaftState raftState = (OnDemandRaftState)response;
                    HashMap<String, Boolean> serverVotingStatusMap = new HashMap<String, Boolean>();
                    for (Map.Entry e : raftState.getPeerVotingStates().entrySet()) {
                        serverVotingStatusMap.put((String)e.getKey(), (Boolean)e.getValue() == false);
                    }
                    serverVotingStatusMap.put(ShardManager.this.getShardIdentifier(ShardManager.this.cluster.getCurrentMemberName(), shardName).toString(), !raftState.isVoting());
                    ShardManager.this.changeShardMembersVotingStatus(new ChangeServersVotingStatus(serverVotingStatusMap), shardName, localShardFound.getPath(), sender);
                }
            }, new Dispatchers(this.context().system().dispatchers()).getDispatcher(Dispatchers.DispatcherType.Client));
        });
    }

    private void findLocalShard(FindLocalShard message) {
        LOG.debug("{}: findLocalShard : {}", (Object)this.persistenceId(), (Object)message.getShardName());
        ShardInformation shardInformation = this.localShards.get(message.getShardName());
        if (shardInformation == null) {
            LOG.debug("{}: Local shard {} not found - shards present: {}", new Object[]{this.persistenceId(), message.getShardName(), this.localShards.keySet()});
            this.getSender().tell((Object)new LocalShardNotFound(message.getShardName()), this.getSelf());
            return;
        }
        this.sendResponse(shardInformation, message.isWaitUntilInitialized(), false, () -> new LocalShardFound(shardInformation.getActor()));
    }

    private void findLocalShard(final String shardName, final ActorRef sender, final Consumer<LocalShardFound> onLocalShardFound) {
        Timeout findLocalTimeout = new Timeout(this.datastoreContextFactory.getBaseDatastoreContext().getShardInitializationTimeout().duration().$times(2L));
        Future futureObj = Patterns.ask((ActorRef)this.getSelf(), (Object)new FindLocalShard(shardName, true), (Timeout)findLocalTimeout);
        futureObj.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                if (failure != null) {
                    LOG.debug("{}: Received failure from FindLocalShard for shard {}", new Object[]{ShardManager.this.persistenceId, shardName, failure});
                    sender.tell((Object)new Status.Failure((Throwable)new RuntimeException(String.format("Failed to find local shard %s", shardName), failure)), ShardManager.this.self());
                } else if (response instanceof LocalShardFound) {
                    ShardManager.this.getSelf().tell(() -> onLocalShardFound.accept((LocalShardFound)response), sender);
                } else if (response instanceof LocalShardNotFound) {
                    LOG.debug("{}: Local shard {} does not exist", (Object)ShardManager.this.persistenceId, (Object)shardName);
                    sender.tell((Object)new Status.Failure((Throwable)new IllegalArgumentException(String.format("Local shard %s does not exist", shardName))), ShardManager.this.self());
                } else {
                    LOG.debug("{}: Failed to find local shard {}: received response: {}", new Object[]{ShardManager.this.persistenceId, shardName, response});
                    sender.tell((Object)new Status.Failure(response instanceof Throwable ? (Throwable)response : new RuntimeException(String.format("Failed to find local shard %s: received response: %s", shardName, response))), ShardManager.this.self());
                }
            }
        }, new Dispatchers(this.context().system().dispatchers()).getDispatcher(Dispatchers.DispatcherType.Client));
    }

    private void changeShardMembersVotingStatus(ChangeServersVotingStatus changeServersVotingStatus, final String shardName, final ActorRef shardActorRef, final ActorRef sender) {
        if (this.isShardReplicaOperationInProgress(shardName, sender)) {
            return;
        }
        this.shardReplicaOperationsInProgress.add(shardName);
        DatastoreContext datastoreContext = this.newShardDatastoreContextBuilder(shardName).build();
        final ShardIdentifier shardId = this.getShardIdentifier(this.cluster.getCurrentMemberName(), shardName);
        LOG.debug("{}: Sending ChangeServersVotingStatus message {} to local shard {}", new Object[]{this.persistenceId(), changeServersVotingStatus, shardActorRef.path()});
        Timeout timeout = new Timeout(datastoreContext.getShardLeaderElectionTimeout().duration().$times(2L));
        Future futureObj = Patterns.ask((ActorRef)shardActorRef, (Object)changeServersVotingStatus, (Timeout)timeout);
        futureObj.onComplete((Function1)new OnComplete<Object>(){

            public void onComplete(Throwable failure, Object response) {
                ShardManager.this.shardReplicaOperationsInProgress.remove(shardName);
                if (failure != null) {
                    LOG.debug("{}: ChangeServersVotingStatus request to local shard {} failed", new Object[]{ShardManager.this.persistenceId(), shardActorRef.path(), failure});
                    sender.tell((Object)new Status.Failure((Throwable)new RuntimeException(String.format("ChangeServersVotingStatus request to local shard %s failed", shardActorRef.path()), failure)), ShardManager.this.self());
                } else {
                    LOG.debug("{}: Received {} from local shard {}", new Object[]{ShardManager.this.persistenceId(), response, shardActorRef.path()});
                    ServerChangeReply replyMsg = (ServerChangeReply)response;
                    if (replyMsg.getStatus() == ServerChangeStatus.OK) {
                        LOG.debug("{}: ChangeServersVotingStatus succeeded for shard {}", (Object)ShardManager.this.persistenceId(), (Object)shardName);
                        sender.tell((Object)new Status.Success(null), ShardManager.this.getSelf());
                    } else if (replyMsg.getStatus() == ServerChangeStatus.INVALID_REQUEST) {
                        sender.tell((Object)new Status.Failure((Throwable)new IllegalArgumentException(String.format("The requested voting state change for shard %s is invalid. At least one member must be voting", shardId.getShardName()))), ShardManager.this.getSelf());
                    } else {
                        LOG.warn("{}: ChangeServersVotingStatus failed for shard {} with status {}", new Object[]{ShardManager.this.persistenceId(), shardName, replyMsg.getStatus()});
                        Exception error = ShardManager.getServerChangeException(ChangeServersVotingStatus.class, replyMsg.getStatus(), shardActorRef.path().toString(), shardId);
                        sender.tell((Object)new Status.Failure((Throwable)error), ShardManager.this.getSelf());
                    }
                }
            }
        }, new Dispatchers(this.context().system().dispatchers()).getDispatcher(Dispatchers.DispatcherType.Client));
    }

    private static final class ShardNotInitializedTimeout {
        private final ActorRef sender;
        private final ShardInformation shardInfo;
        private final OnShardInitialized onShardInitialized;

        ShardNotInitializedTimeout(ShardInformation shardInfo, OnShardInitialized onShardInitialized, ActorRef sender) {
            this.sender = sender;
            this.shardInfo = shardInfo;
            this.onShardInitialized = onShardInitialized;
        }

        ActorRef getSender() {
            return this.sender;
        }

        ShardInformation getShardInfo() {
            return this.shardInfo;
        }

        OnShardInitialized getOnShardInitialized() {
            return this.onShardInitialized;
        }
    }

    private static final class WrappedShardResponse {
        private final ShardIdentifier shardId;
        private final Object response;
        private final String leaderPath;

        WrappedShardResponse(ShardIdentifier shardId, Object response, String leaderPath) {
            this.shardId = shardId;
            this.response = response;
            this.leaderPath = leaderPath;
        }

        ShardIdentifier getShardId() {
            return this.shardId;
        }

        Object getResponse() {
            return this.response;
        }

        String getLeaderPath() {
            return this.leaderPath;
        }
    }

    private static abstract class AutoFindPrimaryFailureResponseHandler
    implements FindPrimaryResponseHandler {
        private final ActorRef targetActor;
        private final String shardName;
        private final String persistenceId;
        private final ActorRef shardManagerActor;

        protected AutoFindPrimaryFailureResponseHandler(ActorRef targetActor, String shardName, String persistenceId, ActorRef shardManagerActor) {
            this.targetActor = Objects.requireNonNull(targetActor);
            this.shardName = Objects.requireNonNull(shardName);
            this.persistenceId = Objects.requireNonNull(persistenceId);
            this.shardManagerActor = Objects.requireNonNull(shardManagerActor);
        }

        public ActorRef getTargetActor() {
            return this.targetActor;
        }

        public String getShardName() {
            return this.shardName;
        }

        @Override
        public void onFailure(Throwable failure) {
            LOG.debug("{}: Received failure from FindPrimary for shard {}", new Object[]{this.persistenceId, this.shardName, failure});
            this.targetActor.tell((Object)new Status.Failure((Throwable)new RuntimeException(String.format("Failed to find leader for shard %s", this.shardName), failure)), this.shardManagerActor);
        }

        @Override
        public void onUnknownResponse(Object response) {
            LOG.debug("{}: Failed to find leader for shard {}: received response: {}", new Object[]{this.persistenceId, this.shardName, response});
            this.targetActor.tell((Object)new Status.Failure(response instanceof Throwable ? (Throwable)response : new RuntimeException(String.format("Failed to find leader for shard %s: received response: %s", this.shardName, response))), this.shardManagerActor);
        }
    }

    private static interface FindPrimaryResponseHandler {
        public void onFailure(Throwable var1);

        public void onRemotePrimaryShardFound(RemotePrimaryShardFound var1);

        public void onLocalPrimaryFound(LocalPrimaryShardFound var1);

        public void onUnknownResponse(Object var1);
    }

    private static interface RunnableMessage
    extends Runnable {
    }

    static class OnShardReady
    extends OnShardInitialized {
        OnShardReady(Runnable replyRunnable) {
            super(replyRunnable);
        }
    }

    static class OnShardInitialized {
        private final Runnable replyRunnable;
        private Cancellable timeoutSchedule;

        OnShardInitialized(Runnable replyRunnable) {
            this.replyRunnable = replyRunnable;
        }

        Runnable getReplyRunnable() {
            return this.replyRunnable;
        }

        Cancellable getTimeoutSchedule() {
            return this.timeoutSchedule;
        }

        void setTimeoutSchedule(Cancellable timeoutSchedule) {
            this.timeoutSchedule = timeoutSchedule;
        }
    }

    private static final class ForwardedAddServerFailure {
        String shardName;
        String failureMessage;
        Throwable failure;
        boolean removeShardOnFailure;

        ForwardedAddServerFailure(String shardName, String failureMessage, Throwable failure, boolean removeShardOnFailure) {
            this.shardName = shardName;
            this.failureMessage = failureMessage;
            this.failure = failure;
            this.removeShardOnFailure = removeShardOnFailure;
        }
    }

    private static final class ForwardedAddServerReply {
        ShardInformation shardInfo;
        AddServerReply addServerReply;
        String leaderPath;
        boolean removeShardOnFailure;

        ForwardedAddServerReply(ShardInformation shardInfo, AddServerReply addServerReply, String leaderPath, boolean removeShardOnFailure) {
            this.shardInfo = shardInfo;
            this.addServerReply = addServerReply;
            this.leaderPath = leaderPath;
            this.removeShardOnFailure = removeShardOnFailure;
        }
    }
}

