/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.sharding;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientLocalHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.DataStoreClient;
import org.opendaylight.controller.cluster.sharding.DistributedShardModificationFactory;
import org.opendaylight.controller.cluster.sharding.ShardProxyTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardProducer;
import org.opendaylight.mdsal.dom.spi.shard.DOMDataTreeShardWriteTransaction;

class ShardProxyProducer
implements DOMDataTreeShardProducer {
    private final DOMDataTreeIdentifier shardRoot;
    private final Collection<DOMDataTreeIdentifier> prefixes;
    private final ClientLocalHistory history;
    private DistributedShardModificationFactory modificationFactory;

    ShardProxyProducer(DOMDataTreeIdentifier shardRoot, Collection<DOMDataTreeIdentifier> prefixes, DataStoreClient client, DistributedShardModificationFactory modificationFactory) {
        this.shardRoot = Objects.requireNonNull(shardRoot);
        this.prefixes = ImmutableList.copyOf(prefixes);
        this.modificationFactory = Objects.requireNonNull(modificationFactory);
        this.history = Objects.requireNonNull(client).createLocalHistory();
    }

    public Collection<DOMDataTreeIdentifier> getPrefixes() {
        return this.prefixes;
    }

    public DOMDataTreeShardWriteTransaction createTransaction() {
        return new ShardProxyTransaction(this.shardRoot, this.prefixes, this.modificationFactory.createModification(this.history.createTransaction()));
    }

    DistributedShardModificationFactory getModificationFactory() {
        return this.modificationFactory;
    }

    void setModificationFactory(DistributedShardModificationFactory modificationFactory) {
        this.modificationFactory = Objects.requireNonNull(modificationFactory);
    }

    public void close() {
    }
}

