/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStorePropertiesContainer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.HeartbeatIntervalType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.NonZeroUint32Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.OperationTimeoutType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.Percentage;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class DataStorePropertiesContainerBuilder
implements Builder<DataStorePropertiesContainer> {
    private NonZeroUint32Type _backendAlivenessTimerIntervalInSeconds;
    private NonZeroUint32Type _boundedMailboxCapacity;
    private String _customRaftPolicyImplementation;
    private NonZeroUint32Type _fileBackedStreamingThresholdInMegabytes;
    private NonZeroUint32Type _frontendNoProgressTimeoutInSeconds;
    private NonZeroUint32Type _frontendRequestTimeoutInSeconds;
    private NonZeroUint32Type _initialPayloadSerializedBufferCapacity;
    private Uint32 _initialSettleTimeoutMultiplier;
    private NonZeroUint32Type _maxShardDataChangeExecutorPoolSize;
    private NonZeroUint32Type _maxShardDataChangeExecutorQueueSize;
    private NonZeroUint32Type _maxShardDataChangeListenerQueueSize;
    private NonZeroUint32Type _maxShardDataStoreExecutorQueueSize;
    private NonZeroUint32Type _maximumMessageSliceSize;
    private OperationTimeoutType _operationTimeoutInSeconds;
    private Uint32 _recoverySnapshotIntervalSeconds;
    private NonZeroUint32Type _shardBatchedModificationCount;
    private NonZeroUint32Type _shardCommitQueueExpiryTimeoutInSeconds;
    private NonZeroUint32Type _shardElectionTimeoutFactor;
    private HeartbeatIntervalType _shardHeartbeatIntervalInMillis;
    private NonZeroUint32Type _shardInitializationTimeoutInSeconds;
    private HeartbeatIntervalType _shardIsolatedLeaderCheckIntervalInMillis;
    private NonZeroUint32Type _shardJournalRecoveryLogBatchSize;
    private NonZeroUint32Type _shardLeaderElectionTimeoutInSeconds;
    private NonZeroUint32Type _shardSnapshotBatchCount;
    private NonZeroUint32Type _shardSnapshotChunkSize;
    private Uint32 _shardSnapshotDataThreshold;
    private Percentage _shardSnapshotDataThresholdPercentage;
    private NonZeroUint32Type _shardTransactionCommitQueueCapacity;
    private NonZeroUint32Type _shardTransactionCommitTimeoutInSeconds;
    private NonZeroUint32Type _shardTransactionIdleTimeoutInMinutes;
    private NonZeroUint32Type _syncIndexThreshold;
    private NonZeroUint32Type _transactionCreationInitialRateLimit;
    private Boolean _enableMetricCapture;
    private Boolean _persistent;
    private Boolean _snapshotOnRootOverwrite;
    private Boolean _transactionDebugContextEnabled;
    private Boolean _useLz4Compression;
    private Boolean _useTellBasedProtocol;
    Map<Class<? extends Augmentation<DataStorePropertiesContainer>>, Augmentation<DataStorePropertiesContainer>> augmentation = Collections.emptyMap();

    public DataStorePropertiesContainerBuilder() {
    }

    public DataStorePropertiesContainerBuilder(DataStoreProperties arg) {
        this._maxShardDataChangeExecutorQueueSize = arg.getMaxShardDataChangeExecutorQueueSize();
        this._maxShardDataChangeExecutorPoolSize = arg.getMaxShardDataChangeExecutorPoolSize();
        this._maxShardDataChangeListenerQueueSize = arg.getMaxShardDataChangeListenerQueueSize();
        this._maxShardDataStoreExecutorQueueSize = arg.getMaxShardDataStoreExecutorQueueSize();
        this._shardTransactionIdleTimeoutInMinutes = arg.getShardTransactionIdleTimeoutInMinutes();
        this._shardSnapshotBatchCount = arg.getShardSnapshotBatchCount();
        this._shardSnapshotDataThresholdPercentage = arg.getShardSnapshotDataThresholdPercentage();
        this._shardSnapshotDataThreshold = arg.getShardSnapshotDataThreshold();
        this._shardHeartbeatIntervalInMillis = arg.getShardHeartbeatIntervalInMillis();
        this._shardElectionTimeoutFactor = arg.getShardElectionTimeoutFactor();
        this._operationTimeoutInSeconds = arg.getOperationTimeoutInSeconds();
        this._shardJournalRecoveryLogBatchSize = arg.getShardJournalRecoveryLogBatchSize();
        this._shardTransactionCommitTimeoutInSeconds = arg.getShardTransactionCommitTimeoutInSeconds();
        this._shardTransactionCommitQueueCapacity = arg.getShardTransactionCommitQueueCapacity();
        this._shardCommitQueueExpiryTimeoutInSeconds = arg.getShardCommitQueueExpiryTimeoutInSeconds();
        this._shardInitializationTimeoutInSeconds = arg.getShardInitializationTimeoutInSeconds();
        this._shardLeaderElectionTimeoutInSeconds = arg.getShardLeaderElectionTimeoutInSeconds();
        this._initialSettleTimeoutMultiplier = arg.getInitialSettleTimeoutMultiplier();
        this._recoverySnapshotIntervalSeconds = arg.getRecoverySnapshotIntervalSeconds();
        this._shardBatchedModificationCount = arg.getShardBatchedModificationCount();
        this._enableMetricCapture = arg.isEnableMetricCapture();
        this._boundedMailboxCapacity = arg.getBoundedMailboxCapacity();
        this._persistent = arg.isPersistent();
        this._snapshotOnRootOverwrite = arg.isSnapshotOnRootOverwrite();
        this._shardIsolatedLeaderCheckIntervalInMillis = arg.getShardIsolatedLeaderCheckIntervalInMillis();
        this._transactionCreationInitialRateLimit = arg.getTransactionCreationInitialRateLimit();
        this._transactionDebugContextEnabled = arg.isTransactionDebugContextEnabled();
        this._customRaftPolicyImplementation = arg.getCustomRaftPolicyImplementation();
        this._shardSnapshotChunkSize = arg.getShardSnapshotChunkSize();
        this._maximumMessageSliceSize = arg.getMaximumMessageSliceSize();
        this._useTellBasedProtocol = arg.isUseTellBasedProtocol();
        this._fileBackedStreamingThresholdInMegabytes = arg.getFileBackedStreamingThresholdInMegabytes();
        this._syncIndexThreshold = arg.getSyncIndexThreshold();
        this._backendAlivenessTimerIntervalInSeconds = arg.getBackendAlivenessTimerIntervalInSeconds();
        this._frontendRequestTimeoutInSeconds = arg.getFrontendRequestTimeoutInSeconds();
        this._frontendNoProgressTimeoutInSeconds = arg.getFrontendNoProgressTimeoutInSeconds();
        this._initialPayloadSerializedBufferCapacity = arg.getInitialPayloadSerializedBufferCapacity();
        this._useLz4Compression = arg.isUseLz4Compression();
    }

    public DataStorePropertiesContainerBuilder(DataStorePropertiesContainer base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DataStorePropertiesContainer>>, Augmentation<DataStorePropertiesContainer>>(aug);
        }
        this._backendAlivenessTimerIntervalInSeconds = base.getBackendAlivenessTimerIntervalInSeconds();
        this._boundedMailboxCapacity = base.getBoundedMailboxCapacity();
        this._customRaftPolicyImplementation = base.getCustomRaftPolicyImplementation();
        this._fileBackedStreamingThresholdInMegabytes = base.getFileBackedStreamingThresholdInMegabytes();
        this._frontendNoProgressTimeoutInSeconds = base.getFrontendNoProgressTimeoutInSeconds();
        this._frontendRequestTimeoutInSeconds = base.getFrontendRequestTimeoutInSeconds();
        this._initialPayloadSerializedBufferCapacity = base.getInitialPayloadSerializedBufferCapacity();
        this._initialSettleTimeoutMultiplier = base.getInitialSettleTimeoutMultiplier();
        this._maxShardDataChangeExecutorPoolSize = base.getMaxShardDataChangeExecutorPoolSize();
        this._maxShardDataChangeExecutorQueueSize = base.getMaxShardDataChangeExecutorQueueSize();
        this._maxShardDataChangeListenerQueueSize = base.getMaxShardDataChangeListenerQueueSize();
        this._maxShardDataStoreExecutorQueueSize = base.getMaxShardDataStoreExecutorQueueSize();
        this._maximumMessageSliceSize = base.getMaximumMessageSliceSize();
        this._operationTimeoutInSeconds = base.getOperationTimeoutInSeconds();
        this._recoverySnapshotIntervalSeconds = base.getRecoverySnapshotIntervalSeconds();
        this._shardBatchedModificationCount = base.getShardBatchedModificationCount();
        this._shardCommitQueueExpiryTimeoutInSeconds = base.getShardCommitQueueExpiryTimeoutInSeconds();
        this._shardElectionTimeoutFactor = base.getShardElectionTimeoutFactor();
        this._shardHeartbeatIntervalInMillis = base.getShardHeartbeatIntervalInMillis();
        this._shardInitializationTimeoutInSeconds = base.getShardInitializationTimeoutInSeconds();
        this._shardIsolatedLeaderCheckIntervalInMillis = base.getShardIsolatedLeaderCheckIntervalInMillis();
        this._shardJournalRecoveryLogBatchSize = base.getShardJournalRecoveryLogBatchSize();
        this._shardLeaderElectionTimeoutInSeconds = base.getShardLeaderElectionTimeoutInSeconds();
        this._shardSnapshotBatchCount = base.getShardSnapshotBatchCount();
        this._shardSnapshotChunkSize = base.getShardSnapshotChunkSize();
        this._shardSnapshotDataThreshold = base.getShardSnapshotDataThreshold();
        this._shardSnapshotDataThresholdPercentage = base.getShardSnapshotDataThresholdPercentage();
        this._shardTransactionCommitQueueCapacity = base.getShardTransactionCommitQueueCapacity();
        this._shardTransactionCommitTimeoutInSeconds = base.getShardTransactionCommitTimeoutInSeconds();
        this._shardTransactionIdleTimeoutInMinutes = base.getShardTransactionIdleTimeoutInMinutes();
        this._syncIndexThreshold = base.getSyncIndexThreshold();
        this._transactionCreationInitialRateLimit = base.getTransactionCreationInitialRateLimit();
        this._enableMetricCapture = base.isEnableMetricCapture();
        this._persistent = base.isPersistent();
        this._snapshotOnRootOverwrite = base.isSnapshotOnRootOverwrite();
        this._transactionDebugContextEnabled = base.isTransactionDebugContextEnabled();
        this._useLz4Compression = base.isUseLz4Compression();
        this._useTellBasedProtocol = base.isUseTellBasedProtocol();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DataStoreProperties) {
            this._maxShardDataChangeExecutorQueueSize = ((DataStoreProperties)arg).getMaxShardDataChangeExecutorQueueSize();
            this._maxShardDataChangeExecutorPoolSize = ((DataStoreProperties)arg).getMaxShardDataChangeExecutorPoolSize();
            this._maxShardDataChangeListenerQueueSize = ((DataStoreProperties)arg).getMaxShardDataChangeListenerQueueSize();
            this._maxShardDataStoreExecutorQueueSize = ((DataStoreProperties)arg).getMaxShardDataStoreExecutorQueueSize();
            this._shardTransactionIdleTimeoutInMinutes = ((DataStoreProperties)arg).getShardTransactionIdleTimeoutInMinutes();
            this._shardSnapshotBatchCount = ((DataStoreProperties)arg).getShardSnapshotBatchCount();
            this._shardSnapshotDataThresholdPercentage = ((DataStoreProperties)arg).getShardSnapshotDataThresholdPercentage();
            this._shardSnapshotDataThreshold = ((DataStoreProperties)arg).getShardSnapshotDataThreshold();
            this._shardHeartbeatIntervalInMillis = ((DataStoreProperties)arg).getShardHeartbeatIntervalInMillis();
            this._shardElectionTimeoutFactor = ((DataStoreProperties)arg).getShardElectionTimeoutFactor();
            this._operationTimeoutInSeconds = ((DataStoreProperties)arg).getOperationTimeoutInSeconds();
            this._shardJournalRecoveryLogBatchSize = ((DataStoreProperties)arg).getShardJournalRecoveryLogBatchSize();
            this._shardTransactionCommitTimeoutInSeconds = ((DataStoreProperties)arg).getShardTransactionCommitTimeoutInSeconds();
            this._shardTransactionCommitQueueCapacity = ((DataStoreProperties)arg).getShardTransactionCommitQueueCapacity();
            this._shardCommitQueueExpiryTimeoutInSeconds = ((DataStoreProperties)arg).getShardCommitQueueExpiryTimeoutInSeconds();
            this._shardInitializationTimeoutInSeconds = ((DataStoreProperties)arg).getShardInitializationTimeoutInSeconds();
            this._shardLeaderElectionTimeoutInSeconds = ((DataStoreProperties)arg).getShardLeaderElectionTimeoutInSeconds();
            this._initialSettleTimeoutMultiplier = ((DataStoreProperties)arg).getInitialSettleTimeoutMultiplier();
            this._recoverySnapshotIntervalSeconds = ((DataStoreProperties)arg).getRecoverySnapshotIntervalSeconds();
            this._shardBatchedModificationCount = ((DataStoreProperties)arg).getShardBatchedModificationCount();
            this._enableMetricCapture = ((DataStoreProperties)arg).isEnableMetricCapture();
            this._boundedMailboxCapacity = ((DataStoreProperties)arg).getBoundedMailboxCapacity();
            this._persistent = ((DataStoreProperties)arg).isPersistent();
            this._snapshotOnRootOverwrite = ((DataStoreProperties)arg).isSnapshotOnRootOverwrite();
            this._shardIsolatedLeaderCheckIntervalInMillis = ((DataStoreProperties)arg).getShardIsolatedLeaderCheckIntervalInMillis();
            this._transactionCreationInitialRateLimit = ((DataStoreProperties)arg).getTransactionCreationInitialRateLimit();
            this._transactionDebugContextEnabled = ((DataStoreProperties)arg).isTransactionDebugContextEnabled();
            this._customRaftPolicyImplementation = ((DataStoreProperties)arg).getCustomRaftPolicyImplementation();
            this._shardSnapshotChunkSize = ((DataStoreProperties)arg).getShardSnapshotChunkSize();
            this._maximumMessageSliceSize = ((DataStoreProperties)arg).getMaximumMessageSliceSize();
            this._useTellBasedProtocol = ((DataStoreProperties)arg).isUseTellBasedProtocol();
            this._fileBackedStreamingThresholdInMegabytes = ((DataStoreProperties)arg).getFileBackedStreamingThresholdInMegabytes();
            this._syncIndexThreshold = ((DataStoreProperties)arg).getSyncIndexThreshold();
            this._backendAlivenessTimerIntervalInSeconds = ((DataStoreProperties)arg).getBackendAlivenessTimerIntervalInSeconds();
            this._frontendRequestTimeoutInSeconds = ((DataStoreProperties)arg).getFrontendRequestTimeoutInSeconds();
            this._frontendNoProgressTimeoutInSeconds = ((DataStoreProperties)arg).getFrontendNoProgressTimeoutInSeconds();
            this._initialPayloadSerializedBufferCapacity = ((DataStoreProperties)arg).getInitialPayloadSerializedBufferCapacity();
            this._useLz4Compression = ((DataStoreProperties)arg).isUseLz4Compression();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStoreProperties]");
    }

    public NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds() {
        return this._backendAlivenessTimerIntervalInSeconds;
    }

    public NonZeroUint32Type getBoundedMailboxCapacity() {
        return this._boundedMailboxCapacity;
    }

    public String getCustomRaftPolicyImplementation() {
        return this._customRaftPolicyImplementation;
    }

    public NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes() {
        return this._fileBackedStreamingThresholdInMegabytes;
    }

    public NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds() {
        return this._frontendNoProgressTimeoutInSeconds;
    }

    public NonZeroUint32Type getFrontendRequestTimeoutInSeconds() {
        return this._frontendRequestTimeoutInSeconds;
    }

    public NonZeroUint32Type getInitialPayloadSerializedBufferCapacity() {
        return this._initialPayloadSerializedBufferCapacity;
    }

    public Uint32 getInitialSettleTimeoutMultiplier() {
        return this._initialSettleTimeoutMultiplier;
    }

    public NonZeroUint32Type getMaxShardDataChangeExecutorPoolSize() {
        return this._maxShardDataChangeExecutorPoolSize;
    }

    public NonZeroUint32Type getMaxShardDataChangeExecutorQueueSize() {
        return this._maxShardDataChangeExecutorQueueSize;
    }

    public NonZeroUint32Type getMaxShardDataChangeListenerQueueSize() {
        return this._maxShardDataChangeListenerQueueSize;
    }

    public NonZeroUint32Type getMaxShardDataStoreExecutorQueueSize() {
        return this._maxShardDataStoreExecutorQueueSize;
    }

    public NonZeroUint32Type getMaximumMessageSliceSize() {
        return this._maximumMessageSliceSize;
    }

    public OperationTimeoutType getOperationTimeoutInSeconds() {
        return this._operationTimeoutInSeconds;
    }

    public Uint32 getRecoverySnapshotIntervalSeconds() {
        return this._recoverySnapshotIntervalSeconds;
    }

    public NonZeroUint32Type getShardBatchedModificationCount() {
        return this._shardBatchedModificationCount;
    }

    public NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds() {
        return this._shardCommitQueueExpiryTimeoutInSeconds;
    }

    public NonZeroUint32Type getShardElectionTimeoutFactor() {
        return this._shardElectionTimeoutFactor;
    }

    public HeartbeatIntervalType getShardHeartbeatIntervalInMillis() {
        return this._shardHeartbeatIntervalInMillis;
    }

    public NonZeroUint32Type getShardInitializationTimeoutInSeconds() {
        return this._shardInitializationTimeoutInSeconds;
    }

    public HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis() {
        return this._shardIsolatedLeaderCheckIntervalInMillis;
    }

    public NonZeroUint32Type getShardJournalRecoveryLogBatchSize() {
        return this._shardJournalRecoveryLogBatchSize;
    }

    public NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds() {
        return this._shardLeaderElectionTimeoutInSeconds;
    }

    public NonZeroUint32Type getShardSnapshotBatchCount() {
        return this._shardSnapshotBatchCount;
    }

    public NonZeroUint32Type getShardSnapshotChunkSize() {
        return this._shardSnapshotChunkSize;
    }

    public Uint32 getShardSnapshotDataThreshold() {
        return this._shardSnapshotDataThreshold;
    }

    public Percentage getShardSnapshotDataThresholdPercentage() {
        return this._shardSnapshotDataThresholdPercentage;
    }

    public NonZeroUint32Type getShardTransactionCommitQueueCapacity() {
        return this._shardTransactionCommitQueueCapacity;
    }

    public NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds() {
        return this._shardTransactionCommitTimeoutInSeconds;
    }

    public NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes() {
        return this._shardTransactionIdleTimeoutInMinutes;
    }

    public NonZeroUint32Type getSyncIndexThreshold() {
        return this._syncIndexThreshold;
    }

    public NonZeroUint32Type getTransactionCreationInitialRateLimit() {
        return this._transactionCreationInitialRateLimit;
    }

    public Boolean isEnableMetricCapture() {
        return this._enableMetricCapture;
    }

    public Boolean isPersistent() {
        return this._persistent;
    }

    public Boolean isSnapshotOnRootOverwrite() {
        return this._snapshotOnRootOverwrite;
    }

    public Boolean isTransactionDebugContextEnabled() {
        return this._transactionDebugContextEnabled;
    }

    public Boolean isUseLz4Compression() {
        return this._useLz4Compression;
    }

    public Boolean isUseTellBasedProtocol() {
        return this._useTellBasedProtocol;
    }

    public <E$$ extends Augmentation<DataStorePropertiesContainer>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public DataStorePropertiesContainerBuilder setBackendAlivenessTimerIntervalInSeconds(NonZeroUint32Type value) {
        this._backendAlivenessTimerIntervalInSeconds = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setBoundedMailboxCapacity(NonZeroUint32Type value) {
        this._boundedMailboxCapacity = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setCustomRaftPolicyImplementation(String value) {
        this._customRaftPolicyImplementation = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setFileBackedStreamingThresholdInMegabytes(NonZeroUint32Type value) {
        this._fileBackedStreamingThresholdInMegabytes = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setFrontendNoProgressTimeoutInSeconds(NonZeroUint32Type value) {
        this._frontendNoProgressTimeoutInSeconds = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setFrontendRequestTimeoutInSeconds(NonZeroUint32Type value) {
        this._frontendRequestTimeoutInSeconds = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setInitialPayloadSerializedBufferCapacity(NonZeroUint32Type value) {
        this._initialPayloadSerializedBufferCapacity = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setInitialSettleTimeoutMultiplier(Uint32 value) {
        this._initialSettleTimeoutMultiplier = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public DataStorePropertiesContainerBuilder setInitialSettleTimeoutMultiplier(Long value) {
        return this.setInitialSettleTimeoutMultiplier(CodeHelpers.compatUint((Long)value));
    }

    public DataStorePropertiesContainerBuilder setMaxShardDataChangeExecutorPoolSize(NonZeroUint32Type value) {
        this._maxShardDataChangeExecutorPoolSize = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setMaxShardDataChangeExecutorQueueSize(NonZeroUint32Type value) {
        this._maxShardDataChangeExecutorQueueSize = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setMaxShardDataChangeListenerQueueSize(NonZeroUint32Type value) {
        this._maxShardDataChangeListenerQueueSize = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setMaxShardDataStoreExecutorQueueSize(NonZeroUint32Type value) {
        this._maxShardDataStoreExecutorQueueSize = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setMaximumMessageSliceSize(NonZeroUint32Type value) {
        this._maximumMessageSliceSize = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setOperationTimeoutInSeconds(OperationTimeoutType value) {
        this._operationTimeoutInSeconds = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setRecoverySnapshotIntervalSeconds(Uint32 value) {
        this._recoverySnapshotIntervalSeconds = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public DataStorePropertiesContainerBuilder setRecoverySnapshotIntervalSeconds(Long value) {
        return this.setRecoverySnapshotIntervalSeconds(CodeHelpers.compatUint((Long)value));
    }

    public DataStorePropertiesContainerBuilder setShardBatchedModificationCount(NonZeroUint32Type value) {
        this._shardBatchedModificationCount = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardCommitQueueExpiryTimeoutInSeconds(NonZeroUint32Type value) {
        this._shardCommitQueueExpiryTimeoutInSeconds = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardElectionTimeoutFactor(NonZeroUint32Type value) {
        this._shardElectionTimeoutFactor = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardHeartbeatIntervalInMillis(HeartbeatIntervalType value) {
        this._shardHeartbeatIntervalInMillis = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardInitializationTimeoutInSeconds(NonZeroUint32Type value) {
        this._shardInitializationTimeoutInSeconds = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardIsolatedLeaderCheckIntervalInMillis(HeartbeatIntervalType value) {
        this._shardIsolatedLeaderCheckIntervalInMillis = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardJournalRecoveryLogBatchSize(NonZeroUint32Type value) {
        this._shardJournalRecoveryLogBatchSize = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardLeaderElectionTimeoutInSeconds(NonZeroUint32Type value) {
        this._shardLeaderElectionTimeoutInSeconds = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardSnapshotBatchCount(NonZeroUint32Type value) {
        this._shardSnapshotBatchCount = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardSnapshotChunkSize(NonZeroUint32Type value) {
        this._shardSnapshotChunkSize = value;
        return this;
    }

    private static void checkShardSnapshotDataThresholdRange(long value) {
    }

    public DataStorePropertiesContainerBuilder setShardSnapshotDataThreshold(Uint32 value) {
        if (value != null) {
            DataStorePropertiesContainerBuilder.checkShardSnapshotDataThresholdRange(value.longValue());
        }
        this._shardSnapshotDataThreshold = value;
        return this;
    }

    @Deprecated(forRemoval=true)
    public DataStorePropertiesContainerBuilder setShardSnapshotDataThreshold(Long value) {
        return this.setShardSnapshotDataThreshold(CodeHelpers.compatUint((Long)value));
    }

    public DataStorePropertiesContainerBuilder setShardSnapshotDataThresholdPercentage(Percentage value) {
        this._shardSnapshotDataThresholdPercentage = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardTransactionCommitQueueCapacity(NonZeroUint32Type value) {
        this._shardTransactionCommitQueueCapacity = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardTransactionCommitTimeoutInSeconds(NonZeroUint32Type value) {
        this._shardTransactionCommitTimeoutInSeconds = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setShardTransactionIdleTimeoutInMinutes(NonZeroUint32Type value) {
        this._shardTransactionIdleTimeoutInMinutes = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setSyncIndexThreshold(NonZeroUint32Type value) {
        this._syncIndexThreshold = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setTransactionCreationInitialRateLimit(NonZeroUint32Type value) {
        this._transactionCreationInitialRateLimit = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setEnableMetricCapture(Boolean value) {
        this._enableMetricCapture = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setPersistent(Boolean value) {
        this._persistent = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setSnapshotOnRootOverwrite(Boolean value) {
        this._snapshotOnRootOverwrite = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setTransactionDebugContextEnabled(Boolean value) {
        this._transactionDebugContextEnabled = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setUseLz4Compression(Boolean value) {
        this._useLz4Compression = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder setUseTellBasedProtocol(Boolean value) {
        this._useTellBasedProtocol = value;
        return this;
    }

    public DataStorePropertiesContainerBuilder addAugmentation(Augmentation<DataStorePropertiesContainer> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public DataStorePropertiesContainerBuilder addAugmentation(Class<? extends Augmentation<DataStorePropertiesContainer>> augmentationType, Augmentation<DataStorePropertiesContainer> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public DataStorePropertiesContainerBuilder removeAugmentation(Class<? extends Augmentation<DataStorePropertiesContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private DataStorePropertiesContainerBuilder doAddAugmentation(Class<? extends Augmentation<DataStorePropertiesContainer>> augmentationType, Augmentation<DataStorePropertiesContainer> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<DataStorePropertiesContainer>>, Augmentation<DataStorePropertiesContainer>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DataStorePropertiesContainer build() {
        return new DataStorePropertiesContainerImpl(this);
    }

    private static final class DataStorePropertiesContainerImpl
    extends AbstractAugmentable<DataStorePropertiesContainer>
    implements DataStorePropertiesContainer {
        private final NonZeroUint32Type _backendAlivenessTimerIntervalInSeconds;
        private final NonZeroUint32Type _boundedMailboxCapacity;
        private final String _customRaftPolicyImplementation;
        private final NonZeroUint32Type _fileBackedStreamingThresholdInMegabytes;
        private final NonZeroUint32Type _frontendNoProgressTimeoutInSeconds;
        private final NonZeroUint32Type _frontendRequestTimeoutInSeconds;
        private final NonZeroUint32Type _initialPayloadSerializedBufferCapacity;
        private final Uint32 _initialSettleTimeoutMultiplier;
        private final NonZeroUint32Type _maxShardDataChangeExecutorPoolSize;
        private final NonZeroUint32Type _maxShardDataChangeExecutorQueueSize;
        private final NonZeroUint32Type _maxShardDataChangeListenerQueueSize;
        private final NonZeroUint32Type _maxShardDataStoreExecutorQueueSize;
        private final NonZeroUint32Type _maximumMessageSliceSize;
        private final OperationTimeoutType _operationTimeoutInSeconds;
        private final Uint32 _recoverySnapshotIntervalSeconds;
        private final NonZeroUint32Type _shardBatchedModificationCount;
        private final NonZeroUint32Type _shardCommitQueueExpiryTimeoutInSeconds;
        private final NonZeroUint32Type _shardElectionTimeoutFactor;
        private final HeartbeatIntervalType _shardHeartbeatIntervalInMillis;
        private final NonZeroUint32Type _shardInitializationTimeoutInSeconds;
        private final HeartbeatIntervalType _shardIsolatedLeaderCheckIntervalInMillis;
        private final NonZeroUint32Type _shardJournalRecoveryLogBatchSize;
        private final NonZeroUint32Type _shardLeaderElectionTimeoutInSeconds;
        private final NonZeroUint32Type _shardSnapshotBatchCount;
        private final NonZeroUint32Type _shardSnapshotChunkSize;
        private final Uint32 _shardSnapshotDataThreshold;
        private final Percentage _shardSnapshotDataThresholdPercentage;
        private final NonZeroUint32Type _shardTransactionCommitQueueCapacity;
        private final NonZeroUint32Type _shardTransactionCommitTimeoutInSeconds;
        private final NonZeroUint32Type _shardTransactionIdleTimeoutInMinutes;
        private final NonZeroUint32Type _syncIndexThreshold;
        private final NonZeroUint32Type _transactionCreationInitialRateLimit;
        private final Boolean _enableMetricCapture;
        private final Boolean _persistent;
        private final Boolean _snapshotOnRootOverwrite;
        private final Boolean _transactionDebugContextEnabled;
        private final Boolean _useLz4Compression;
        private final Boolean _useTellBasedProtocol;
        private int hash = 0;
        private volatile boolean hashValid = false;

        DataStorePropertiesContainerImpl(DataStorePropertiesContainerBuilder base) {
            super(base.augmentation);
            this._backendAlivenessTimerIntervalInSeconds = base.getBackendAlivenessTimerIntervalInSeconds();
            this._boundedMailboxCapacity = base.getBoundedMailboxCapacity();
            this._customRaftPolicyImplementation = base.getCustomRaftPolicyImplementation();
            this._fileBackedStreamingThresholdInMegabytes = base.getFileBackedStreamingThresholdInMegabytes();
            this._frontendNoProgressTimeoutInSeconds = base.getFrontendNoProgressTimeoutInSeconds();
            this._frontendRequestTimeoutInSeconds = base.getFrontendRequestTimeoutInSeconds();
            this._initialPayloadSerializedBufferCapacity = base.getInitialPayloadSerializedBufferCapacity();
            this._initialSettleTimeoutMultiplier = base.getInitialSettleTimeoutMultiplier();
            this._maxShardDataChangeExecutorPoolSize = base.getMaxShardDataChangeExecutorPoolSize();
            this._maxShardDataChangeExecutorQueueSize = base.getMaxShardDataChangeExecutorQueueSize();
            this._maxShardDataChangeListenerQueueSize = base.getMaxShardDataChangeListenerQueueSize();
            this._maxShardDataStoreExecutorQueueSize = base.getMaxShardDataStoreExecutorQueueSize();
            this._maximumMessageSliceSize = base.getMaximumMessageSliceSize();
            this._operationTimeoutInSeconds = base.getOperationTimeoutInSeconds();
            this._recoverySnapshotIntervalSeconds = base.getRecoverySnapshotIntervalSeconds();
            this._shardBatchedModificationCount = base.getShardBatchedModificationCount();
            this._shardCommitQueueExpiryTimeoutInSeconds = base.getShardCommitQueueExpiryTimeoutInSeconds();
            this._shardElectionTimeoutFactor = base.getShardElectionTimeoutFactor();
            this._shardHeartbeatIntervalInMillis = base.getShardHeartbeatIntervalInMillis();
            this._shardInitializationTimeoutInSeconds = base.getShardInitializationTimeoutInSeconds();
            this._shardIsolatedLeaderCheckIntervalInMillis = base.getShardIsolatedLeaderCheckIntervalInMillis();
            this._shardJournalRecoveryLogBatchSize = base.getShardJournalRecoveryLogBatchSize();
            this._shardLeaderElectionTimeoutInSeconds = base.getShardLeaderElectionTimeoutInSeconds();
            this._shardSnapshotBatchCount = base.getShardSnapshotBatchCount();
            this._shardSnapshotChunkSize = base.getShardSnapshotChunkSize();
            this._shardSnapshotDataThreshold = base.getShardSnapshotDataThreshold();
            this._shardSnapshotDataThresholdPercentage = base.getShardSnapshotDataThresholdPercentage();
            this._shardTransactionCommitQueueCapacity = base.getShardTransactionCommitQueueCapacity();
            this._shardTransactionCommitTimeoutInSeconds = base.getShardTransactionCommitTimeoutInSeconds();
            this._shardTransactionIdleTimeoutInMinutes = base.getShardTransactionIdleTimeoutInMinutes();
            this._syncIndexThreshold = base.getSyncIndexThreshold();
            this._transactionCreationInitialRateLimit = base.getTransactionCreationInitialRateLimit();
            this._enableMetricCapture = base.isEnableMetricCapture();
            this._persistent = base.isPersistent();
            this._snapshotOnRootOverwrite = base.isSnapshotOnRootOverwrite();
            this._transactionDebugContextEnabled = base.isTransactionDebugContextEnabled();
            this._useLz4Compression = base.isUseLz4Compression();
            this._useTellBasedProtocol = base.isUseTellBasedProtocol();
        }

        @Override
        public NonZeroUint32Type getBackendAlivenessTimerIntervalInSeconds() {
            return this._backendAlivenessTimerIntervalInSeconds;
        }

        @Override
        public NonZeroUint32Type getBoundedMailboxCapacity() {
            return this._boundedMailboxCapacity;
        }

        @Override
        public String getCustomRaftPolicyImplementation() {
            return this._customRaftPolicyImplementation;
        }

        @Override
        public NonZeroUint32Type getFileBackedStreamingThresholdInMegabytes() {
            return this._fileBackedStreamingThresholdInMegabytes;
        }

        @Override
        public NonZeroUint32Type getFrontendNoProgressTimeoutInSeconds() {
            return this._frontendNoProgressTimeoutInSeconds;
        }

        @Override
        public NonZeroUint32Type getFrontendRequestTimeoutInSeconds() {
            return this._frontendRequestTimeoutInSeconds;
        }

        @Override
        public NonZeroUint32Type getInitialPayloadSerializedBufferCapacity() {
            return this._initialPayloadSerializedBufferCapacity;
        }

        @Override
        public Uint32 getInitialSettleTimeoutMultiplier() {
            return this._initialSettleTimeoutMultiplier;
        }

        @Override
        public NonZeroUint32Type getMaxShardDataChangeExecutorPoolSize() {
            return this._maxShardDataChangeExecutorPoolSize;
        }

        @Override
        public NonZeroUint32Type getMaxShardDataChangeExecutorQueueSize() {
            return this._maxShardDataChangeExecutorQueueSize;
        }

        @Override
        public NonZeroUint32Type getMaxShardDataChangeListenerQueueSize() {
            return this._maxShardDataChangeListenerQueueSize;
        }

        @Override
        public NonZeroUint32Type getMaxShardDataStoreExecutorQueueSize() {
            return this._maxShardDataStoreExecutorQueueSize;
        }

        @Override
        public NonZeroUint32Type getMaximumMessageSliceSize() {
            return this._maximumMessageSliceSize;
        }

        @Override
        public OperationTimeoutType getOperationTimeoutInSeconds() {
            return this._operationTimeoutInSeconds;
        }

        @Override
        public Uint32 getRecoverySnapshotIntervalSeconds() {
            return this._recoverySnapshotIntervalSeconds;
        }

        @Override
        public NonZeroUint32Type getShardBatchedModificationCount() {
            return this._shardBatchedModificationCount;
        }

        @Override
        public NonZeroUint32Type getShardCommitQueueExpiryTimeoutInSeconds() {
            return this._shardCommitQueueExpiryTimeoutInSeconds;
        }

        @Override
        public NonZeroUint32Type getShardElectionTimeoutFactor() {
            return this._shardElectionTimeoutFactor;
        }

        @Override
        public HeartbeatIntervalType getShardHeartbeatIntervalInMillis() {
            return this._shardHeartbeatIntervalInMillis;
        }

        @Override
        public NonZeroUint32Type getShardInitializationTimeoutInSeconds() {
            return this._shardInitializationTimeoutInSeconds;
        }

        @Override
        public HeartbeatIntervalType getShardIsolatedLeaderCheckIntervalInMillis() {
            return this._shardIsolatedLeaderCheckIntervalInMillis;
        }

        @Override
        public NonZeroUint32Type getShardJournalRecoveryLogBatchSize() {
            return this._shardJournalRecoveryLogBatchSize;
        }

        @Override
        public NonZeroUint32Type getShardLeaderElectionTimeoutInSeconds() {
            return this._shardLeaderElectionTimeoutInSeconds;
        }

        @Override
        public NonZeroUint32Type getShardSnapshotBatchCount() {
            return this._shardSnapshotBatchCount;
        }

        @Override
        public NonZeroUint32Type getShardSnapshotChunkSize() {
            return this._shardSnapshotChunkSize;
        }

        @Override
        public Uint32 getShardSnapshotDataThreshold() {
            return this._shardSnapshotDataThreshold;
        }

        @Override
        public Percentage getShardSnapshotDataThresholdPercentage() {
            return this._shardSnapshotDataThresholdPercentage;
        }

        @Override
        public NonZeroUint32Type getShardTransactionCommitQueueCapacity() {
            return this._shardTransactionCommitQueueCapacity;
        }

        @Override
        public NonZeroUint32Type getShardTransactionCommitTimeoutInSeconds() {
            return this._shardTransactionCommitTimeoutInSeconds;
        }

        @Override
        public NonZeroUint32Type getShardTransactionIdleTimeoutInMinutes() {
            return this._shardTransactionIdleTimeoutInMinutes;
        }

        @Override
        public NonZeroUint32Type getSyncIndexThreshold() {
            return this._syncIndexThreshold;
        }

        @Override
        public NonZeroUint32Type getTransactionCreationInitialRateLimit() {
            return this._transactionCreationInitialRateLimit;
        }

        @Override
        public Boolean isEnableMetricCapture() {
            return this._enableMetricCapture;
        }

        @Override
        public Boolean isPersistent() {
            return this._persistent;
        }

        @Override
        public Boolean isSnapshotOnRootOverwrite() {
            return this._snapshotOnRootOverwrite;
        }

        @Override
        public Boolean isTransactionDebugContextEnabled() {
            return this._transactionDebugContextEnabled;
        }

        @Override
        public Boolean isUseLz4Compression() {
            return this._useLz4Compression;
        }

        @Override
        public Boolean isUseTellBasedProtocol() {
            return this._useTellBasedProtocol;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._backendAlivenessTimerIntervalInSeconds);
            result = 31 * result + Objects.hashCode(this._boundedMailboxCapacity);
            result = 31 * result + Objects.hashCode(this._customRaftPolicyImplementation);
            result = 31 * result + Objects.hashCode(this._fileBackedStreamingThresholdInMegabytes);
            result = 31 * result + Objects.hashCode(this._frontendNoProgressTimeoutInSeconds);
            result = 31 * result + Objects.hashCode(this._frontendRequestTimeoutInSeconds);
            result = 31 * result + Objects.hashCode(this._initialPayloadSerializedBufferCapacity);
            result = 31 * result + Objects.hashCode(this._initialSettleTimeoutMultiplier);
            result = 31 * result + Objects.hashCode(this._maxShardDataChangeExecutorPoolSize);
            result = 31 * result + Objects.hashCode(this._maxShardDataChangeExecutorQueueSize);
            result = 31 * result + Objects.hashCode(this._maxShardDataChangeListenerQueueSize);
            result = 31 * result + Objects.hashCode(this._maxShardDataStoreExecutorQueueSize);
            result = 31 * result + Objects.hashCode(this._maximumMessageSliceSize);
            result = 31 * result + Objects.hashCode(this._operationTimeoutInSeconds);
            result = 31 * result + Objects.hashCode(this._recoverySnapshotIntervalSeconds);
            result = 31 * result + Objects.hashCode(this._shardBatchedModificationCount);
            result = 31 * result + Objects.hashCode(this._shardCommitQueueExpiryTimeoutInSeconds);
            result = 31 * result + Objects.hashCode(this._shardElectionTimeoutFactor);
            result = 31 * result + Objects.hashCode(this._shardHeartbeatIntervalInMillis);
            result = 31 * result + Objects.hashCode(this._shardInitializationTimeoutInSeconds);
            result = 31 * result + Objects.hashCode(this._shardIsolatedLeaderCheckIntervalInMillis);
            result = 31 * result + Objects.hashCode(this._shardJournalRecoveryLogBatchSize);
            result = 31 * result + Objects.hashCode(this._shardLeaderElectionTimeoutInSeconds);
            result = 31 * result + Objects.hashCode(this._shardSnapshotBatchCount);
            result = 31 * result + Objects.hashCode(this._shardSnapshotChunkSize);
            result = 31 * result + Objects.hashCode(this._shardSnapshotDataThreshold);
            result = 31 * result + Objects.hashCode(this._shardSnapshotDataThresholdPercentage);
            result = 31 * result + Objects.hashCode(this._shardTransactionCommitQueueCapacity);
            result = 31 * result + Objects.hashCode(this._shardTransactionCommitTimeoutInSeconds);
            result = 31 * result + Objects.hashCode(this._shardTransactionIdleTimeoutInMinutes);
            result = 31 * result + Objects.hashCode(this._syncIndexThreshold);
            result = 31 * result + Objects.hashCode(this._transactionCreationInitialRateLimit);
            result = 31 * result + Objects.hashCode(this._enableMetricCapture);
            result = 31 * result + Objects.hashCode(this._persistent);
            result = 31 * result + Objects.hashCode(this._snapshotOnRootOverwrite);
            result = 31 * result + Objects.hashCode(this._transactionDebugContextEnabled);
            result = 31 * result + Objects.hashCode(this._useLz4Compression);
            result = 31 * result + Objects.hashCode(this._useTellBasedProtocol);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DataStorePropertiesContainer.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            DataStorePropertiesContainer other = (DataStorePropertiesContainer)obj;
            if (!Objects.equals(this._backendAlivenessTimerIntervalInSeconds, other.getBackendAlivenessTimerIntervalInSeconds())) {
                return false;
            }
            if (!Objects.equals(this._boundedMailboxCapacity, other.getBoundedMailboxCapacity())) {
                return false;
            }
            if (!Objects.equals(this._customRaftPolicyImplementation, other.getCustomRaftPolicyImplementation())) {
                return false;
            }
            if (!Objects.equals(this._fileBackedStreamingThresholdInMegabytes, other.getFileBackedStreamingThresholdInMegabytes())) {
                return false;
            }
            if (!Objects.equals(this._frontendNoProgressTimeoutInSeconds, other.getFrontendNoProgressTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(this._frontendRequestTimeoutInSeconds, other.getFrontendRequestTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(this._initialPayloadSerializedBufferCapacity, other.getInitialPayloadSerializedBufferCapacity())) {
                return false;
            }
            if (!Objects.equals(this._initialSettleTimeoutMultiplier, other.getInitialSettleTimeoutMultiplier())) {
                return false;
            }
            if (!Objects.equals(this._maxShardDataChangeExecutorPoolSize, other.getMaxShardDataChangeExecutorPoolSize())) {
                return false;
            }
            if (!Objects.equals(this._maxShardDataChangeExecutorQueueSize, other.getMaxShardDataChangeExecutorQueueSize())) {
                return false;
            }
            if (!Objects.equals(this._maxShardDataChangeListenerQueueSize, other.getMaxShardDataChangeListenerQueueSize())) {
                return false;
            }
            if (!Objects.equals(this._maxShardDataStoreExecutorQueueSize, other.getMaxShardDataStoreExecutorQueueSize())) {
                return false;
            }
            if (!Objects.equals(this._maximumMessageSliceSize, other.getMaximumMessageSliceSize())) {
                return false;
            }
            if (!Objects.equals(this._operationTimeoutInSeconds, other.getOperationTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(this._recoverySnapshotIntervalSeconds, other.getRecoverySnapshotIntervalSeconds())) {
                return false;
            }
            if (!Objects.equals(this._shardBatchedModificationCount, other.getShardBatchedModificationCount())) {
                return false;
            }
            if (!Objects.equals(this._shardCommitQueueExpiryTimeoutInSeconds, other.getShardCommitQueueExpiryTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(this._shardElectionTimeoutFactor, other.getShardElectionTimeoutFactor())) {
                return false;
            }
            if (!Objects.equals(this._shardHeartbeatIntervalInMillis, other.getShardHeartbeatIntervalInMillis())) {
                return false;
            }
            if (!Objects.equals(this._shardInitializationTimeoutInSeconds, other.getShardInitializationTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(this._shardIsolatedLeaderCheckIntervalInMillis, other.getShardIsolatedLeaderCheckIntervalInMillis())) {
                return false;
            }
            if (!Objects.equals(this._shardJournalRecoveryLogBatchSize, other.getShardJournalRecoveryLogBatchSize())) {
                return false;
            }
            if (!Objects.equals(this._shardLeaderElectionTimeoutInSeconds, other.getShardLeaderElectionTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(this._shardSnapshotBatchCount, other.getShardSnapshotBatchCount())) {
                return false;
            }
            if (!Objects.equals(this._shardSnapshotChunkSize, other.getShardSnapshotChunkSize())) {
                return false;
            }
            if (!Objects.equals(this._shardSnapshotDataThreshold, other.getShardSnapshotDataThreshold())) {
                return false;
            }
            if (!Objects.equals(this._shardSnapshotDataThresholdPercentage, other.getShardSnapshotDataThresholdPercentage())) {
                return false;
            }
            if (!Objects.equals(this._shardTransactionCommitQueueCapacity, other.getShardTransactionCommitQueueCapacity())) {
                return false;
            }
            if (!Objects.equals(this._shardTransactionCommitTimeoutInSeconds, other.getShardTransactionCommitTimeoutInSeconds())) {
                return false;
            }
            if (!Objects.equals(this._shardTransactionIdleTimeoutInMinutes, other.getShardTransactionIdleTimeoutInMinutes())) {
                return false;
            }
            if (!Objects.equals(this._syncIndexThreshold, other.getSyncIndexThreshold())) {
                return false;
            }
            if (!Objects.equals(this._transactionCreationInitialRateLimit, other.getTransactionCreationInitialRateLimit())) {
                return false;
            }
            if (!Objects.equals(this._enableMetricCapture, other.isEnableMetricCapture())) {
                return false;
            }
            if (!Objects.equals(this._persistent, other.isPersistent())) {
                return false;
            }
            if (!Objects.equals(this._snapshotOnRootOverwrite, other.isSnapshotOnRootOverwrite())) {
                return false;
            }
            if (!Objects.equals(this._transactionDebugContextEnabled, other.isTransactionDebugContextEnabled())) {
                return false;
            }
            if (!Objects.equals(this._useLz4Compression, other.isUseLz4Compression())) {
                return false;
            }
            if (!Objects.equals(this._useTellBasedProtocol, other.isUseTellBasedProtocol())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DataStorePropertiesContainerImpl otherImpl = (DataStorePropertiesContainerImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"DataStorePropertiesContainer");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_backendAlivenessTimerIntervalInSeconds", (Object)this._backendAlivenessTimerIntervalInSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_boundedMailboxCapacity", (Object)this._boundedMailboxCapacity);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_customRaftPolicyImplementation", (Object)this._customRaftPolicyImplementation);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_fileBackedStreamingThresholdInMegabytes", (Object)this._fileBackedStreamingThresholdInMegabytes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_frontendNoProgressTimeoutInSeconds", (Object)this._frontendNoProgressTimeoutInSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_frontendRequestTimeoutInSeconds", (Object)this._frontendRequestTimeoutInSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_initialPayloadSerializedBufferCapacity", (Object)this._initialPayloadSerializedBufferCapacity);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_initialSettleTimeoutMultiplier", (Object)this._initialSettleTimeoutMultiplier);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxShardDataChangeExecutorPoolSize", (Object)this._maxShardDataChangeExecutorPoolSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxShardDataChangeExecutorQueueSize", (Object)this._maxShardDataChangeExecutorQueueSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxShardDataChangeListenerQueueSize", (Object)this._maxShardDataChangeListenerQueueSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maxShardDataStoreExecutorQueueSize", (Object)this._maxShardDataStoreExecutorQueueSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_maximumMessageSliceSize", (Object)this._maximumMessageSliceSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_operationTimeoutInSeconds", (Object)this._operationTimeoutInSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_recoverySnapshotIntervalSeconds", (Object)this._recoverySnapshotIntervalSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardBatchedModificationCount", (Object)this._shardBatchedModificationCount);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardCommitQueueExpiryTimeoutInSeconds", (Object)this._shardCommitQueueExpiryTimeoutInSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardElectionTimeoutFactor", (Object)this._shardElectionTimeoutFactor);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardHeartbeatIntervalInMillis", (Object)this._shardHeartbeatIntervalInMillis);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardInitializationTimeoutInSeconds", (Object)this._shardInitializationTimeoutInSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardIsolatedLeaderCheckIntervalInMillis", (Object)this._shardIsolatedLeaderCheckIntervalInMillis);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardJournalRecoveryLogBatchSize", (Object)this._shardJournalRecoveryLogBatchSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardLeaderElectionTimeoutInSeconds", (Object)this._shardLeaderElectionTimeoutInSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardSnapshotBatchCount", (Object)this._shardSnapshotBatchCount);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardSnapshotChunkSize", (Object)this._shardSnapshotChunkSize);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardSnapshotDataThreshold", (Object)this._shardSnapshotDataThreshold);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardSnapshotDataThresholdPercentage", (Object)this._shardSnapshotDataThresholdPercentage);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardTransactionCommitQueueCapacity", (Object)this._shardTransactionCommitQueueCapacity);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardTransactionCommitTimeoutInSeconds", (Object)this._shardTransactionCommitTimeoutInSeconds);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardTransactionIdleTimeoutInMinutes", (Object)this._shardTransactionIdleTimeoutInMinutes);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_syncIndexThreshold", (Object)this._syncIndexThreshold);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_transactionCreationInitialRateLimit", (Object)this._transactionCreationInitialRateLimit);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_enableMetricCapture", (Object)this._enableMetricCapture);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_persistent", (Object)this._persistent);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_snapshotOnRootOverwrite", (Object)this._snapshotOnRootOverwrite);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_transactionDebugContextEnabled", (Object)this._transactionDebugContextEnabled);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_useLz4Compression", (Object)this._useLz4Compression);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_useTellBasedProtocol", (Object)this._useTellBasedProtocol);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

