/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.node.identifiers;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.NodeType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.node.identifiers.NodeIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.node.identifiers.NodeIdentifierKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeIdentifierBuilder
implements Builder<NodeIdentifier> {
    private Uri _identifier;
    private Class<? extends NodeType> _type;
    private NodeIdentifierKey key;
    Map<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>> augmentation = Collections.emptyMap();

    public NodeIdentifierBuilder() {
    }

    public NodeIdentifierBuilder(NodeIdentifier base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>>(aug);
        }
        this.key = base.key();
        this._identifier = base.getIdentifier();
        this._type = base.getType();
    }

    public NodeIdentifierKey key() {
        return this.key;
    }

    public Uri getIdentifier() {
        return this._identifier;
    }

    public Class<? extends NodeType> getType() {
        return this._type;
    }

    public <E$$ extends Augmentation<NodeIdentifier>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NodeIdentifierBuilder withKey(NodeIdentifierKey key) {
        this.key = key;
        return this;
    }

    public NodeIdentifierBuilder setIdentifier(Uri value) {
        this._identifier = value;
        return this;
    }

    public NodeIdentifierBuilder setType(Class<? extends NodeType> value) {
        this._type = value;
        return this;
    }

    public NodeIdentifierBuilder addAugmentation(Augmentation<NodeIdentifier> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public NodeIdentifierBuilder addAugmentation(Class<? extends Augmentation<NodeIdentifier>> augmentationType, Augmentation<NodeIdentifier> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public NodeIdentifierBuilder removeAugmentation(Class<? extends Augmentation<NodeIdentifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private NodeIdentifierBuilder doAddAugmentation(Class<? extends Augmentation<NodeIdentifier>> augmentationType, Augmentation<NodeIdentifier> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NodeIdentifier build() {
        return new NodeIdentifierImpl(this);
    }

    private static final class NodeIdentifierImpl
    extends AbstractAugmentable<NodeIdentifier>
    implements NodeIdentifier {
        private final Uri _identifier;
        private final Class<? extends NodeType> _type;
        private final NodeIdentifierKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodeIdentifierImpl(NodeIdentifierBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new NodeIdentifierKey(base.getIdentifier(), base.getType());
            this._identifier = this.key.getIdentifier();
            this._type = this.key.getType();
        }

        @Override
        public NodeIdentifierKey key() {
            return this.key;
        }

        @Override
        public Uri getIdentifier() {
            return this._identifier;
        }

        @Override
        public Class<? extends NodeType> getType() {
            return this._type;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._identifier);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NodeIdentifier.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            NodeIdentifier other = (NodeIdentifier)obj;
            if (!Objects.equals(this._identifier, other.getIdentifier())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodeIdentifierImpl otherImpl = (NodeIdentifierImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NodeIdentifier");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_identifier", (Object)this._identifier);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_type", this._type);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

