/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeNode;
import org.opendaylight.mdsal.dom.spi.RegistrationTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public abstract class AbstractRegistrationTree<T> {
    private final RegistrationTreeNode<T> rootNode = new RegistrationTreeNode(null, null);
    private final Lock writeLock;
    private final Lock readLock;

    protected AbstractRegistrationTree() {
        StampedLock lock = new StampedLock();
        this.readLock = lock.asReadLock();
        this.writeLock = lock.asWriteLock();
    }

    protected final void takeLock() {
        this.writeLock.lock();
    }

    protected final void releaseLock() {
        this.writeLock.unlock();
    }

    protected final @NonNull RegistrationTreeNode<T> findNodeFor(@NonNull Iterable<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument> path) {
        RegistrationTreeNode<T> walkNode = this.rootNode;
        for (YangInstanceIdentifier.PathArgument arg : path) {
            walkNode = walkNode.ensureChild(arg);
        }
        return walkNode;
    }

    protected final void addRegistration(@NonNull RegistrationTreeNode<T> node, @NonNull T registration) {
        node.addRegistration(registration);
    }

    protected final void removeRegistration(@NonNull RegistrationTreeNode<T> node, @NonNull T registration) {
        this.writeLock.lock();
        try {
            node.removeRegistration(registration);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public final @NonNull RegistrationTreeSnapshot<T> takeSnapshot() {
        this.readLock.lock();
        return new RegistrationTreeSnapshot<T>(this.readLock, this.rootNode);
    }
}

