/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.query;

import com.google.common.collect.ImmutableList;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opendaylight.mdsal.dom.api.query.DOMQuery;
import org.opendaylight.mdsal.dom.api.query.DOMQueryPredicate;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;

public final class DOMQueryEvaluator {
    private DOMQueryEvaluator() {
    }

    public static List<? extends Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>>> evaluate(DOMQuery query, NormalizedNode<?, ?> root) {
        YangInstanceIdentifier path = query.getSelect();
        return path.isEmpty() ? DOMQueryEvaluator.evalSingle(root, query) : DOMQueryEvaluator.evalPath(new ArrayDeque<YangInstanceIdentifier.PathArgument>(path.getPathArguments()), root, query);
    }

    private static List<? extends Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>>> evalPath(ArrayDeque<YangInstanceIdentifier.PathArgument> remaining, NormalizedNode<?, ?> data, DOMQuery query) {
        ArrayList result = new ArrayList();
        DOMQueryEvaluator.evalPath(result, query.getRoot(), remaining, data, query);
        return result;
    }

    private static void evalPath(List<Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>>> result, YangInstanceIdentifier path, ArrayDeque<YangInstanceIdentifier.PathArgument> remaining, NormalizedNode<?, ?> data, DOMQuery query) {
        YangInstanceIdentifier.PathArgument next = remaining.poll();
        if (next == null) {
            if (DOMQueryEvaluator.matches(data, query)) {
                result.add(new AbstractMap.SimpleImmutableEntry(query.getRoot(), data));
            }
            return;
        }
        NormalizedNodes.findNode(data, (YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{next}).ifPresent(child -> DOMQueryEvaluator.evalPath(result, path.node(next), remaining, child, query));
        remaining.push(next);
    }

    private static List<? extends Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>>> evalSingle(NormalizedNode<?, ?> data, DOMQuery query) {
        return DOMQueryEvaluator.matches(data, query) ? ImmutableList.of() : ImmutableList.of(new AbstractMap.SimpleImmutableEntry(query.getRoot(), data));
    }

    private static boolean matches(NormalizedNode<?, ?> data, DOMQuery query) {
        for (DOMQueryPredicate pred : query.getPredicates()) {
            if (pred.test(data)) continue;
            return false;
        }
        return true;
    }
}

