/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.annotations.Beta;
import java.util.ArrayDeque;
import java.util.Deque;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.shard.WriteCursorStrategy;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
public abstract class AbstractDataModificationCursor<M>
implements DOMDataTreeWriteCursor {
    private final Deque<WriteCursorStrategy> stack = new ArrayDeque<WriteCursorStrategy>();

    public AbstractDataModificationCursor(M root) {
        this.stack.push(this.getRootOperation(root));
    }

    protected abstract WriteCursorStrategy getRootOperation(M var1);

    private WriteCursorStrategy getCurrent() {
        return this.stack.peek();
    }

    public void enter(YangInstanceIdentifier.PathArgument child) {
        WriteCursorStrategy nextOp = this.getCurrent().enter(child);
        this.stack.push(nextOp);
    }

    public void enter(YangInstanceIdentifier.PathArgument ... path) {
        for (YangInstanceIdentifier.PathArgument pathArgument : path) {
            this.enter(pathArgument);
        }
    }

    public void enter(Iterable<YangInstanceIdentifier.PathArgument> path) {
        for (YangInstanceIdentifier.PathArgument pathArgument : path) {
            this.enter(pathArgument);
        }
    }

    public void exit() {
        WriteCursorStrategy op = this.stack.pop();
        op.exit();
    }

    public void exit(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.exit();
        }
    }

    public abstract void close();

    public void delete(YangInstanceIdentifier.PathArgument child) {
        this.getCurrent().delete(child);
    }

    public void merge(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
        this.getCurrent().merge(child, data);
    }

    public void write(YangInstanceIdentifier.PathArgument child, NormalizedNode<?, ?> data) {
        this.getCurrent().write(child, data);
    }
}

