/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.annotations.Beta;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.shard.ModificationContextNodeBuilder;
import org.opendaylight.mdsal.dom.spi.shard.WriteableSubshardBoundaryNode;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@Beta
public abstract class AbstractShardModificationFactoryBuilder<T>
extends ModificationContextNodeBuilder
implements Builder<T> {
    protected final Map<DOMDataTreeIdentifier, ForeignShardModificationContext> childShards = new HashMap<DOMDataTreeIdentifier, ForeignShardModificationContext>();
    protected final DOMDataTreeIdentifier root;

    public AbstractShardModificationFactoryBuilder(DOMDataTreeIdentifier root) {
        this.root = Objects.requireNonNull(root);
    }

    public void addSubshard(ForeignShardModificationContext value) {
        WriteableSubshardBoundaryNode leafNode = WriteableSubshardBoundaryNode.from(value);
        this.putNode(value.getIdentifier().getRootIdentifier(), leafNode);
    }

    public void addSubshard(DOMDataTreeIdentifier prefix, ForeignShardModificationContext value) {
        this.childShards.put(prefix, value);
    }

    public abstract T build();

    private void putNode(YangInstanceIdentifier key, WriteableSubshardBoundaryNode subshardNode) {
        Iterator toBoundary = this.toRelative(key).getPathArguments().iterator();
        if (toBoundary.hasNext()) {
            ModificationContextNodeBuilder current = this;
            while (true) {
                YangInstanceIdentifier.PathArgument nextArg = (YangInstanceIdentifier.PathArgument)toBoundary.next();
                if (!toBoundary.hasNext()) {
                    current.addBoundary(nextArg, subshardNode);
                    break;
                }
                current = current.getInterior(nextArg);
            }
        }
    }

    private YangInstanceIdentifier toRelative(YangInstanceIdentifier key) {
        return (YangInstanceIdentifier)key.relativeTo(this.root.getRootIdentifier()).get();
    }
}

