/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi.shard;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.shard.DelegatingWriteCursorStrategy;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.shard.WriteCursorStrategy;
import org.opendaylight.mdsal.dom.spi.shard.WriteableModificationNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@Beta
public class WriteableSubshardBoundaryNode
extends WriteableModificationNode {
    private final ForeignShardModificationContext boundary;

    WriteableSubshardBoundaryNode(ForeignShardModificationContext boundary) {
        this.boundary = Objects.requireNonNull(boundary);
    }

    public static WriteableSubshardBoundaryNode from(ForeignShardModificationContext value) {
        return new WriteableSubshardBoundaryNode(value);
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.boundary.getIdentifier().getRootIdentifier().getLastPathArgument();
    }

    @Override
    public WriteCursorStrategy createOperation(final DOMDataTreeWriteCursor parentCursor) {
        return new DelegatingWriteCursorStrategy(){

            @Override
            public void exit() {
                parentCursor.exit();
            }

            @Override
            protected DelegatingWriteCursorStrategy childStrategy() {
                return new DelegatingWriteCursorStrategy(){

                    @Override
                    protected DOMDataTreeWriteCursor delegate() {
                        return WriteableSubshardBoundaryNode.this.boundary.getCursor();
                    }
                };
            }

            @Override
            protected DOMDataTreeWriteCursor delegate() {
                return WriteableSubshardBoundaryNode.this.boundary.getCursor();
            }
        };
    }

    @Override
    public WriteableModificationNode getChild(YangInstanceIdentifier.PathArgument node) {
        return null;
    }

    @Override
    public void markDeleted() {
    }

    @Override
    public Map<YangInstanceIdentifier.PathArgument, WriteableModificationNode> getChildrenWithSubshards() {
        return ImmutableMap.of();
    }
}

