/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.annotations.Beta;
import org.opendaylight.mdsal.model.ietf.util.AbstractIetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;

@Beta
public final class IetfInetUtil
extends AbstractIetfInetUtil<Ipv4Address, Ipv4AddressNoZone, Ipv4Prefix, Ipv6Address, Ipv6AddressNoZone, Ipv6Prefix, IpAddress, IpAddressNoZone, IpPrefix> {
    public static final IetfInetUtil INSTANCE = new IetfInetUtil();

    private IetfInetUtil() {
        super(Ipv4AddressNoZone.class, Ipv4Prefix.class, Ipv6AddressNoZone.class, Ipv6Prefix.class);
    }

    protected IpAddress ipv4Address(Ipv4AddressNoZone addr) {
        return new IpAddress(addr);
    }

    protected IpAddressNoZone ipv4AddressNoZone(Ipv4AddressNoZone addr) {
        return new IpAddressNoZone(addr);
    }

    protected IpAddressNoZone ipv6AddressNoZone(Ipv6AddressNoZone addr) {
        return new IpAddressNoZone(addr);
    }

    protected IpAddress ipv6Address(Ipv6AddressNoZone addr) {
        return new IpAddress(addr);
    }

    protected IpPrefix ipv4Prefix(Ipv4Prefix addr) {
        return new IpPrefix(addr);
    }

    protected IpPrefix ipv6Prefix(Ipv6Prefix addr) {
        return new IpPrefix(addr);
    }

    protected String ipv4AddressString(Ipv4Address addr) {
        return addr.getValue();
    }

    protected String ipv6AddressString(Ipv6Address addr) {
        return addr.getValue();
    }

    protected String ipv4PrefixString(Ipv4Prefix prefix) {
        return prefix.getValue();
    }

    protected String ipv6PrefixString(Ipv6Prefix prefix) {
        return prefix.getValue();
    }

    protected Ipv4Address maybeIpv4Address(IpAddress addr) {
        return addr.getIpv4Address();
    }

    protected Ipv4AddressNoZone maybeIpv4AddressNoZone(IpAddressNoZone addr) {
        return addr.getIpv4AddressNoZone();
    }

    protected Ipv6Address maybeIpv6Address(IpAddress addr) {
        return addr.getIpv6Address();
    }

    protected Ipv6AddressNoZone maybeIpv6AddressNoZone(IpAddressNoZone addr) {
        return addr.getIpv6AddressNoZone();
    }
}

