/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.spi;

import com.google.common.annotations.Beta;
import com.google.common.collect.ForwardingObject;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingLazyContainerNode;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;

@Beta
public abstract class AbstractBindingLazyContainerNode<T extends DataObject, C>
extends ForwardingObject
implements BindingLazyContainerNode<T> {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier identifier;
    private final @NonNull T bindingData;
    private volatile @Nullable ContainerNode delegate;
    private @GuardedBy(value={"this"}) @Nullable C context;

    protected AbstractBindingLazyContainerNode(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier identifier, @NonNull T bindingData, C context) {
        this.identifier = Objects.requireNonNull(identifier);
        this.bindingData = (DataObject)Objects.requireNonNull(bindingData);
        this.context = context;
    }

    public final @NonNull T getDataObject() {
        return this.bindingData;
    }

    public final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier getIdentifier() {
        return this.identifier;
    }

    public final QName getNodeType() {
        return this.identifier.getNodeType();
    }

    public final ContainerNode getDelegate() {
        return this.delegate();
    }

    public Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getValue() {
        return this.delegate().getValue();
    }

    public Optional<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getChild(YangInstanceIdentifier.PathArgument child) {
        return this.delegate().getChild(child);
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContainerNode)) {
            return false;
        }
        ContainerNode other = (ContainerNode)obj;
        return this.delegate().equals(other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final @NonNull ContainerNode delegate() {
        ContainerNode local = this.delegate;
        if (local == null) {
            AbstractBindingLazyContainerNode abstractBindingLazyContainerNode = this;
            synchronized (abstractBindingLazyContainerNode) {
                local = this.delegate;
                if (local == null) {
                    local = this.delegate = Objects.requireNonNull(this.computeContainerNode(this.context));
                    this.context = null;
                }
            }
        }
        return local;
    }

    protected abstract @GuardedBy(value={"this"}) @NonNull ContainerNode computeContainerNode(C var1);
}

