/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.opendaylight.mdsal.dom.store.inmemory.InMemoryDOMDataStoreConfigProperties;

@Generated(from="InMemoryDOMDataStoreConfigProperties", generator="Immutables")
@SuppressFBWarnings
public final class InMemoryDOMDataStoreConfigPropertiesBuilder {
    private static final long OPT_BIT_DEBUG_TRANSACTIONS = 1L;
    private static final long OPT_BIT_MAX_DATA_CHANGE_EXECUTOR_QUEUE_SIZE = 2L;
    private static final long OPT_BIT_MAX_DATA_CHANGE_EXECUTOR_POOL_SIZE = 4L;
    private static final long OPT_BIT_MAX_DATA_CHANGE_LISTENER_QUEUE_SIZE = 8L;
    private static final long OPT_BIT_MAX_DATA_STORE_EXECUTOR_QUEUE_SIZE = 16L;
    private long optBits;
    private boolean debugTransactions;
    private int maxDataChangeExecutorQueueSize;
    private int maxDataChangeExecutorPoolSize;
    private int maxDataChangeListenerQueueSize;
    private int maxDataStoreExecutorQueueSize;

    @CanIgnoreReturnValue
    public final InMemoryDOMDataStoreConfigPropertiesBuilder from(InMemoryDOMDataStoreConfigProperties instance) {
        Objects.requireNonNull(instance, "instance");
        this.debugTransactions(instance.getDebugTransactions());
        this.maxDataChangeExecutorQueueSize(instance.getMaxDataChangeExecutorQueueSize());
        this.maxDataChangeExecutorPoolSize(instance.getMaxDataChangeExecutorPoolSize());
        this.maxDataChangeListenerQueueSize(instance.getMaxDataChangeListenerQueueSize());
        this.maxDataStoreExecutorQueueSize(instance.getMaxDataStoreExecutorQueueSize());
        return this;
    }

    @CanIgnoreReturnValue
    public final InMemoryDOMDataStoreConfigPropertiesBuilder debugTransactions(boolean debugTransactions) {
        this.debugTransactions = debugTransactions;
        this.optBits |= 1L;
        return this;
    }

    @CanIgnoreReturnValue
    public final InMemoryDOMDataStoreConfigPropertiesBuilder maxDataChangeExecutorQueueSize(int maxDataChangeExecutorQueueSize) {
        this.maxDataChangeExecutorQueueSize = maxDataChangeExecutorQueueSize;
        this.optBits |= 2L;
        return this;
    }

    @CanIgnoreReturnValue
    public final InMemoryDOMDataStoreConfigPropertiesBuilder maxDataChangeExecutorPoolSize(int maxDataChangeExecutorPoolSize) {
        this.maxDataChangeExecutorPoolSize = maxDataChangeExecutorPoolSize;
        this.optBits |= 4L;
        return this;
    }

    @CanIgnoreReturnValue
    public final InMemoryDOMDataStoreConfigPropertiesBuilder maxDataChangeListenerQueueSize(int maxDataChangeListenerQueueSize) {
        this.maxDataChangeListenerQueueSize = maxDataChangeListenerQueueSize;
        this.optBits |= 8L;
        return this;
    }

    @CanIgnoreReturnValue
    public final InMemoryDOMDataStoreConfigPropertiesBuilder maxDataStoreExecutorQueueSize(int maxDataStoreExecutorQueueSize) {
        this.maxDataStoreExecutorQueueSize = maxDataStoreExecutorQueueSize;
        this.optBits |= 0x10L;
        return this;
    }

    public InMemoryDOMDataStoreConfigProperties build() {
        return new ImmutableInMemoryDOMDataStoreConfigProperties(this);
    }

    private boolean debugTransactionsIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private boolean maxDataChangeExecutorQueueSizeIsSet() {
        return (this.optBits & 2L) != 0L;
    }

    private boolean maxDataChangeExecutorPoolSizeIsSet() {
        return (this.optBits & 4L) != 0L;
    }

    private boolean maxDataChangeListenerQueueSizeIsSet() {
        return (this.optBits & 8L) != 0L;
    }

    private boolean maxDataStoreExecutorQueueSizeIsSet() {
        return (this.optBits & 0x10L) != 0L;
    }

    @Generated(from="InMemoryDOMDataStoreConfigProperties", generator="Immutables")
    private static final class ImmutableInMemoryDOMDataStoreConfigProperties
    extends InMemoryDOMDataStoreConfigProperties {
        private final boolean debugTransactions;
        private final int maxDataChangeExecutorQueueSize;
        private final int maxDataChangeExecutorPoolSize;
        private final int maxDataChangeListenerQueueSize;
        private final int maxDataStoreExecutorQueueSize;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private ImmutableInMemoryDOMDataStoreConfigProperties(InMemoryDOMDataStoreConfigPropertiesBuilder builder) {
            if (builder.debugTransactionsIsSet()) {
                this.initShim.debugTransactions(builder.debugTransactions);
            }
            if (builder.maxDataChangeExecutorQueueSizeIsSet()) {
                this.initShim.maxDataChangeExecutorQueueSize(builder.maxDataChangeExecutorQueueSize);
            }
            if (builder.maxDataChangeExecutorPoolSizeIsSet()) {
                this.initShim.maxDataChangeExecutorPoolSize(builder.maxDataChangeExecutorPoolSize);
            }
            if (builder.maxDataChangeListenerQueueSizeIsSet()) {
                this.initShim.maxDataChangeListenerQueueSize(builder.maxDataChangeListenerQueueSize);
            }
            if (builder.maxDataStoreExecutorQueueSizeIsSet()) {
                this.initShim.maxDataStoreExecutorQueueSize(builder.maxDataStoreExecutorQueueSize);
            }
            this.debugTransactions = this.initShim.getDebugTransactions();
            this.maxDataChangeExecutorQueueSize = this.initShim.getMaxDataChangeExecutorQueueSize();
            this.maxDataChangeExecutorPoolSize = this.initShim.getMaxDataChangeExecutorPoolSize();
            this.maxDataChangeListenerQueueSize = this.initShim.getMaxDataChangeListenerQueueSize();
            this.maxDataStoreExecutorQueueSize = this.initShim.getMaxDataStoreExecutorQueueSize();
            this.initShim = null;
        }

        @Override
        public boolean getDebugTransactions() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getDebugTransactions() : this.debugTransactions;
        }

        @Override
        public int getMaxDataChangeExecutorQueueSize() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getMaxDataChangeExecutorQueueSize() : this.maxDataChangeExecutorQueueSize;
        }

        @Override
        public int getMaxDataChangeExecutorPoolSize() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getMaxDataChangeExecutorPoolSize() : this.maxDataChangeExecutorPoolSize;
        }

        @Override
        public int getMaxDataChangeListenerQueueSize() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getMaxDataChangeListenerQueueSize() : this.maxDataChangeListenerQueueSize;
        }

        @Override
        public int getMaxDataStoreExecutorQueueSize() {
            InitShim shim = this.initShim;
            return shim != null ? shim.getMaxDataStoreExecutorQueueSize() : this.maxDataStoreExecutorQueueSize;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableInMemoryDOMDataStoreConfigProperties && this.equalTo((ImmutableInMemoryDOMDataStoreConfigProperties)another);
        }

        private boolean equalTo(ImmutableInMemoryDOMDataStoreConfigProperties another) {
            return this.debugTransactions == another.debugTransactions && this.maxDataChangeExecutorQueueSize == another.maxDataChangeExecutorQueueSize && this.maxDataChangeExecutorPoolSize == another.maxDataChangeExecutorPoolSize && this.maxDataChangeListenerQueueSize == another.maxDataChangeListenerQueueSize && this.maxDataStoreExecutorQueueSize == another.maxDataStoreExecutorQueueSize;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Booleans.hashCode((boolean)this.debugTransactions);
            h += (h << 5) + this.maxDataChangeExecutorQueueSize;
            h += (h << 5) + this.maxDataChangeExecutorPoolSize;
            h += (h << 5) + this.maxDataChangeListenerQueueSize;
            h += (h << 5) + this.maxDataStoreExecutorQueueSize;
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"InMemoryDOMDataStoreConfigProperties").omitNullValues().add("debugTransactions", this.debugTransactions).add("maxDataChangeExecutorQueueSize", this.maxDataChangeExecutorQueueSize).add("maxDataChangeExecutorPoolSize", this.maxDataChangeExecutorPoolSize).add("maxDataChangeListenerQueueSize", this.maxDataChangeListenerQueueSize).add("maxDataStoreExecutorQueueSize", this.maxDataStoreExecutorQueueSize).toString();
        }

        @Generated(from="InMemoryDOMDataStoreConfigProperties", generator="Immutables")
        private final class InitShim {
            private byte debugTransactionsBuildStage = 0;
            private boolean debugTransactions;
            private byte maxDataChangeExecutorQueueSizeBuildStage = 0;
            private int maxDataChangeExecutorQueueSize;
            private byte maxDataChangeExecutorPoolSizeBuildStage = 0;
            private int maxDataChangeExecutorPoolSize;
            private byte maxDataChangeListenerQueueSizeBuildStage = 0;
            private int maxDataChangeListenerQueueSize;
            private byte maxDataStoreExecutorQueueSizeBuildStage = 0;
            private int maxDataStoreExecutorQueueSize;

            private InitShim() {
            }

            boolean getDebugTransactions() {
                if (this.debugTransactionsBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.debugTransactionsBuildStage == 0) {
                    this.debugTransactionsBuildStage = (byte)-1;
                    this.debugTransactions = ImmutableInMemoryDOMDataStoreConfigProperties.super.getDebugTransactions();
                    this.debugTransactionsBuildStage = 1;
                }
                return this.debugTransactions;
            }

            void debugTransactions(boolean debugTransactions) {
                this.debugTransactions = debugTransactions;
                this.debugTransactionsBuildStage = 1;
            }

            int getMaxDataChangeExecutorQueueSize() {
                if (this.maxDataChangeExecutorQueueSizeBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.maxDataChangeExecutorQueueSizeBuildStage == 0) {
                    this.maxDataChangeExecutorQueueSizeBuildStage = (byte)-1;
                    this.maxDataChangeExecutorQueueSize = ImmutableInMemoryDOMDataStoreConfigProperties.super.getMaxDataChangeExecutorQueueSize();
                    this.maxDataChangeExecutorQueueSizeBuildStage = 1;
                }
                return this.maxDataChangeExecutorQueueSize;
            }

            void maxDataChangeExecutorQueueSize(int maxDataChangeExecutorQueueSize) {
                this.maxDataChangeExecutorQueueSize = maxDataChangeExecutorQueueSize;
                this.maxDataChangeExecutorQueueSizeBuildStage = 1;
            }

            int getMaxDataChangeExecutorPoolSize() {
                if (this.maxDataChangeExecutorPoolSizeBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.maxDataChangeExecutorPoolSizeBuildStage == 0) {
                    this.maxDataChangeExecutorPoolSizeBuildStage = (byte)-1;
                    this.maxDataChangeExecutorPoolSize = ImmutableInMemoryDOMDataStoreConfigProperties.super.getMaxDataChangeExecutorPoolSize();
                    this.maxDataChangeExecutorPoolSizeBuildStage = 1;
                }
                return this.maxDataChangeExecutorPoolSize;
            }

            void maxDataChangeExecutorPoolSize(int maxDataChangeExecutorPoolSize) {
                this.maxDataChangeExecutorPoolSize = maxDataChangeExecutorPoolSize;
                this.maxDataChangeExecutorPoolSizeBuildStage = 1;
            }

            int getMaxDataChangeListenerQueueSize() {
                if (this.maxDataChangeListenerQueueSizeBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.maxDataChangeListenerQueueSizeBuildStage == 0) {
                    this.maxDataChangeListenerQueueSizeBuildStage = (byte)-1;
                    this.maxDataChangeListenerQueueSize = ImmutableInMemoryDOMDataStoreConfigProperties.super.getMaxDataChangeListenerQueueSize();
                    this.maxDataChangeListenerQueueSizeBuildStage = 1;
                }
                return this.maxDataChangeListenerQueueSize;
            }

            void maxDataChangeListenerQueueSize(int maxDataChangeListenerQueueSize) {
                this.maxDataChangeListenerQueueSize = maxDataChangeListenerQueueSize;
                this.maxDataChangeListenerQueueSizeBuildStage = 1;
            }

            int getMaxDataStoreExecutorQueueSize() {
                if (this.maxDataStoreExecutorQueueSizeBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.maxDataStoreExecutorQueueSizeBuildStage == 0) {
                    this.maxDataStoreExecutorQueueSizeBuildStage = (byte)-1;
                    this.maxDataStoreExecutorQueueSize = ImmutableInMemoryDOMDataStoreConfigProperties.super.getMaxDataStoreExecutorQueueSize();
                    this.maxDataStoreExecutorQueueSizeBuildStage = 1;
                }
                return this.maxDataStoreExecutorQueueSize;
            }

            void maxDataStoreExecutorQueueSize(int maxDataStoreExecutorQueueSize) {
                this.maxDataStoreExecutorQueueSize = maxDataStoreExecutorQueueSize;
                this.maxDataStoreExecutorQueueSizeBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.debugTransactionsBuildStage == -1) {
                    attributes.add("debugTransactions");
                }
                if (this.maxDataChangeExecutorQueueSizeBuildStage == -1) {
                    attributes.add("maxDataChangeExecutorQueueSize");
                }
                if (this.maxDataChangeExecutorPoolSizeBuildStage == -1) {
                    attributes.add("maxDataChangeExecutorPoolSize");
                }
                if (this.maxDataChangeListenerQueueSizeBuildStage == -1) {
                    attributes.add("maxDataChangeListenerQueueSize");
                }
                if (this.maxDataStoreExecutorQueueSizeBuildStage == -1) {
                    attributes.add("maxDataStoreExecutorQueueSize");
                }
                return "Cannot build InMemoryDOMDataStoreConfigProperties, attribute initializers form cycle " + attributes;
            }
        }
    }
}

