/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.store.inmemory.DataTreeModificationCursorAdaptor;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;

class ShardRootModificationContext
implements Identifiable<DOMDataTreeIdentifier> {
    private final DOMDataTreeIdentifier identifier;
    private final CursorAwareDataTreeSnapshot snapshot;
    private CursorAwareDataTreeModification modification = null;
    private DataTreeModificationCursorAdaptor cursor = null;

    ShardRootModificationContext(DOMDataTreeIdentifier identifier, CursorAwareDataTreeSnapshot snapshot) {
        this.identifier = Objects.requireNonNull(identifier);
        this.snapshot = Objects.requireNonNull(snapshot);
    }

    public DOMDataTreeIdentifier getIdentifier() {
        return this.identifier;
    }

    DataTreeModificationCursorAdaptor cursor() {
        if (this.cursor == null) {
            if (this.modification == null) {
                this.modification = this.snapshot.newModification();
            }
            DataTreeModificationCursor dataTreeCursor = (DataTreeModificationCursor)this.modification.openCursor(YangInstanceIdentifier.empty()).get();
            this.cursor = DataTreeModificationCursorAdaptor.of(dataTreeCursor);
        }
        return this.cursor;
    }

    boolean isModified() {
        return this.modification != null;
    }

    DataTreeModification ready() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
        CursorAwareDataTreeModification ret = null;
        if (this.modification != null) {
            this.modification.ready();
            ret = this.modification;
            this.modification = null;
        }
        return ret;
    }

    void closeCursor() {
        this.cursor.close();
        this.cursor = null;
    }
}

