/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.ir;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.AbstractIRObject;

@Beta
public abstract class IRArgument
extends AbstractIRObject {
    IRArgument() {
    }

    static final class Unquoted
    extends Single {
        Unquoted(String string) {
            super(string);
        }
    }

    static final class Identifier
    extends Single {
        Identifier(String string) {
            super(string);
        }
    }

    static final class SingleQuoted
    extends Single {
        static final @NonNull SingleQuoted EMPTY = new SingleQuoted("");

        SingleQuoted(String string) {
            super(string);
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            return super.toYangFragment(sb.append('\'')).append('\'');
        }
    }

    static final class DoubleQuoted
    extends Single {
        DoubleQuoted(String string) {
            super(string);
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            return super.toYangFragment(sb.append('\"')).append('\"');
        }
    }

    public static abstract class Single
    extends IRArgument {
        private final @NonNull String string;

        Single(String string) {
            this.string = Objects.requireNonNull(string);
        }

        public final @NonNull String string() {
            return this.string;
        }

        public final boolean needUnescape() {
            return this instanceof DoubleQuoted;
        }

        public final boolean needQuoteCheck() {
            return this instanceof Unquoted;
        }

        public final boolean isValidIdentifier() {
            return this instanceof Identifier;
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            return sb.append(this.string);
        }
    }

    public static final class Concatenation
    extends IRArgument {
        private final @NonNull ImmutableList<Single> parts;

        Concatenation(List<Single> parts) {
            this.parts = ImmutableList.copyOf(parts);
        }

        public @NonNull List<? extends Single> parts() {
            return this.parts;
        }

        @Override
        StringBuilder toYangFragment(StringBuilder sb) {
            UnmodifiableIterator it = this.parts.iterator();
            ((Single)it.next()).toYangFragment(sb);
            while (it.hasNext()) {
                ((Single)it.next()).toYangFragment(sb.append(" + "));
            }
            return sb;
        }
    }
}

